/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class AccountStore
extends TronStoreWithRevoking<AccountCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(AccountStore.class);
    private static Map<String, byte[]> assertsAddress = new HashMap<String, byte[]>();

    @Autowired
    private AccountStore(@Value(value="account") String dbName) {
        super(dbName);
    }

    @Override
    public AccountCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new AccountCapsule(value);
    }

    @Override
    public AccountCapsule getOnSolidity(byte[] key) {
        byte[] value = this.revokingDB.getUncheckedOnSolidity(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new AccountCapsule(value);
    }

    public AccountCapsule getSun() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Sun"));
    }

    public AccountCapsule getBlackhole() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Blackhole"));
    }

    public AccountCapsule getZion() {
        return (AccountCapsule)this.getUnchecked(assertsAddress.get("Zion"));
    }

    public static void setAccount(Config config) {
        List list = config.getObjectList("genesis.block.assets");
        for (int i = 0; i < list.size(); ++i) {
            ConfigObject obj = (ConfigObject)list.get(i);
            String accountName = obj.get((Object)"accountName").unwrapped().toString();
            byte[] address = Wallet.decodeFromBase58Check(obj.get((Object)"address").unwrapped().toString());
            assertsAddress.put(accountName, address);
        }
    }
}

