/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.storage.SourceInter;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.Utils;
import org.tron.core.config.args.Args;
import org.tron.core.db.RevokingDatabase;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.core.ISession;
import org.tron.core.db2.core.RevokingDBWithCachingOldValue;
import org.tron.core.db2.core.SnapshotManager;
import org.tron.core.exception.RevokingStoreIllegalStateException;

public abstract class AbstractRevokingStore
implements RevokingDatabase {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRevokingStore.class);
    private static final int DEFAULT_STACK_MAX_SIZE = 256;
    private Deque<RevokingState> stack = new LinkedList<RevokingState>();
    private boolean disabled = true;
    private int activeDialog = 0;
    private AtomicInteger maxSize = new AtomicInteger(256);
    private WriteOptions writeOptions = new WriteOptions().sync(Args.getInstance().getStorage().isDbSync());
    private List<LevelDbDataSourceImpl> dbs = new ArrayList<LevelDbDataSourceImpl>();

    @Override
    public ISession buildSession() {
        return this.buildSession(false);
    }

    @Override
    public synchronized ISession buildSession(boolean forceEnable) {
        boolean disableOnExit;
        if (this.disabled && !forceEnable) {
            return new Dialog(this);
        }
        boolean bl = disableOnExit = this.disabled && forceEnable;
        if (forceEnable) {
            this.disabled = false;
        }
        while (this.stack.size() > this.maxSize.get()) {
            this.stack.poll();
        }
        this.stack.add(new RevokingState());
        ++this.activeDialog;
        return new Dialog(this, disableOnExit);
    }

    @Override
    public synchronized void check() {
        LevelDbDataSourceImpl check = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName("tmp"), "tmp");
        check.initDB();
        if (!check.allKeys().isEmpty()) {
            Map<String, LevelDbDataSourceImpl> dbMap = this.dbs.stream().map(db -> Maps.immutableEntry((Object)db.getDBName(), (Object)db)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry e : check) {
                byte[] realValue;
                byte[] key = (byte[])e.getKey();
                byte[] value = (byte[])e.getValue();
                String db2 = SnapshotManager.simpleDecode(key);
                byte[] realKey = Arrays.copyOfRange(key, db2.getBytes().length + 4, key.length);
                byte[] byArray = realValue = value.length == 1 ? null : Arrays.copyOfRange(value, 1, value.length);
                if (realValue != null) {
                    dbMap.get(db2).putData(realKey, realValue, new WriteOptions().sync(Args.getInstance().getStorage().isDbSync()));
                    continue;
                }
                dbMap.get(db2).deleteData(realKey, new WriteOptions().sync(Args.getInstance().getStorage().isDbSync()));
            }
        }
        check.closeDB();
        FileUtil.recursiveDelete(check.getDbPath().toString());
    }

    @Override
    public void add(IRevokingDB revokingDB) {
        this.dbs.add(((RevokingDBWithCachingOldValue)revokingDB).getDbSource());
    }

    public synchronized void onCreate(RevokingTuple tuple, byte[] value) {
        if (this.disabled) {
            return;
        }
        this.addIfEmpty();
        RevokingState state = this.stack.peekLast();
        state.newIds.add(tuple);
    }

    public synchronized void onModify(RevokingTuple tuple, byte[] value) {
        if (this.disabled) {
            return;
        }
        this.addIfEmpty();
        RevokingState state = this.stack.peekLast();
        if (state.newIds.contains(tuple) || state.oldValues.containsKey(tuple)) {
            return;
        }
        state.oldValues.put(tuple, Utils.clone(value));
    }

    public synchronized void onRemove(RevokingTuple tuple, byte[] value) {
        if (this.disabled) {
            return;
        }
        this.addIfEmpty();
        RevokingState state = this.stack.peekLast();
        if (state.newIds.contains(tuple)) {
            state.newIds.remove(tuple);
            return;
        }
        if (state.oldValues.containsKey(tuple)) {
            state.removed.put(tuple, state.oldValues.get(tuple));
            state.oldValues.remove(tuple);
            return;
        }
        if (state.removed.containsKey(tuple)) {
            return;
        }
        state.removed.put(tuple, Utils.clone(value));
    }

    @Override
    public synchronized void merge() {
        if (this.activeDialog <= 0) {
            throw new RevokingStoreIllegalStateException("activeDialog has to be greater than 0");
        }
        if (this.activeDialog == 1 && this.stack.size() == 1) {
            this.stack.pollLast();
            --this.activeDialog;
            return;
        }
        if (this.stack.size() < 2) {
            return;
        }
        RevokingState state = this.stack.peekLast();
        List list = (List)((Object)this.stack);
        RevokingState prevState = (RevokingState)list.get(this.stack.size() - 2);
        state.oldValues.entrySet().stream().filter(e -> !prevState.newIds.contains(e.getKey())).filter(e -> !prevState.oldValues.containsKey(e.getKey())).forEach(e -> prevState.oldValues.put((RevokingTuple)e.getKey(), (byte[])e.getValue()));
        prevState.newIds.addAll(state.newIds);
        state.removed.entrySet().stream().filter(e -> {
            boolean has = prevState.newIds.contains(e.getKey());
            if (has) {
                prevState.newIds.remove(e.getKey());
            }
            return !has;
        }).filter(e -> {
            boolean has = prevState.oldValues.containsKey(e.getKey());
            if (has) {
                prevState.removed.put((RevokingTuple)e.getKey(), prevState.oldValues.get(e.getKey()));
                prevState.oldValues.remove(e.getKey());
            }
            return !has;
        }).forEach(e -> prevState.removed.put((RevokingTuple)e.getKey(), (byte[])e.getValue()));
        this.stack.pollLast();
        --this.activeDialog;
    }

    @Override
    public synchronized void revoke() {
        if (this.disabled) {
            return;
        }
        if (this.activeDialog <= 0) {
            throw new RevokingStoreIllegalStateException("activeDialog has to be greater than 0");
        }
        this.disabled = true;
        try {
            RevokingState state = this.stack.peekLast();
            if (Objects.isNull(state)) {
                return;
            }
            state.oldValues.forEach((k, v) -> ((RevokingTuple)k).database.putData(((RevokingTuple)k).key, v));
            state.newIds.forEach(e -> ((RevokingTuple)e).database.deleteData(((RevokingTuple)e).key));
            state.removed.forEach((k, v) -> ((RevokingTuple)k).database.putData(((RevokingTuple)k).key, v));
            this.stack.pollLast();
        }
        finally {
            this.disabled = false;
        }
        --this.activeDialog;
    }

    @Override
    public synchronized void commit() {
        if (this.activeDialog <= 0) {
            throw new RevokingStoreIllegalStateException("activeDialog has to be greater than 0");
        }
        --this.activeDialog;
    }

    @Override
    public synchronized void pop() {
        this.prune(this.writeOptions);
    }

    @Override
    public synchronized void fastPop() {
        this.prune(new WriteOptions());
    }

    private synchronized void prune(WriteOptions options) {
        if (this.activeDialog != 0) {
            throw new RevokingStoreIllegalStateException("activeDialog has to be equal 0");
        }
        if (this.stack.isEmpty()) {
            throw new RevokingStoreIllegalStateException("stack is empty");
        }
        this.disabled = true;
        try {
            RevokingState state = this.stack.peekLast();
            state.oldValues.forEach((k, v) -> ((RevokingTuple)k).database.putData(((RevokingTuple)k).key, v, options));
            state.newIds.forEach(e -> ((RevokingTuple)e).database.deleteData(((RevokingTuple)e).key, options));
            state.removed.forEach((k, v) -> ((RevokingTuple)k).database.putData(((RevokingTuple)k).key, v, options));
            this.stack.pollLast();
        }
        finally {
            this.disabled = false;
        }
    }

    @Override
    public synchronized void enable() {
        this.disabled = false;
    }

    @Override
    public synchronized void disable() {
        this.disabled = true;
    }

    private void addIfEmpty() {
        if (this.stack.isEmpty()) {
            this.stack.add(new RevokingState());
        }
    }

    @Override
    public synchronized int size() {
        return this.stack.size();
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize.set(maxSize);
    }

    public int getMaxSize() {
        return this.maxSize.get();
    }

    @Override
    public void setMaxFlushCount(int maxFlushCount) {
    }

    @Override
    public synchronized void shutdown() {
        System.err.println("******** begin to pop revokingDb ********");
        System.err.println("******** before revokingDb size:" + this.size());
        try {
            this.disable();
            do {
                try {
                    this.commit();
                }
                catch (RevokingStoreIllegalStateException e) {
                    break;
                }
            } while (this.activeDialog > 0);
            do {
                try {
                    this.pop();
                }
                catch (RevokingStoreIllegalStateException e) {
                    break;
                }
                if (this.activeDialog == 0) continue;
                break;
            } while (!this.stack.isEmpty());
        }
        catch (Exception e) {
            System.err.println("******** failed to pop revokingStore. " + e);
        }
        finally {
            System.err.println("******** after revokingStore size:" + this.stack.size());
            System.err.println("******** after revokingStore contains:" + this.stack);
            System.err.println("******** end to pop revokingStore ********");
        }
    }

    public Deque<RevokingState> getStack() {
        return this.stack;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public int getActiveDialog() {
        return this.activeDialog;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public List<LevelDbDataSourceImpl> getDbs() {
        return this.dbs;
    }

    public static class RevokingTuple {
        private SourceInter<byte[], byte[]> database;
        private byte[] key;

        @ConstructorProperties(value={"database", "key"})
        public RevokingTuple(SourceInter<byte[], byte[]> database, byte[] key) {
            this.database = database;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevokingTuple)) {
                return false;
            }
            RevokingTuple other = (RevokingTuple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SourceInter<byte[], byte[]> this$database = this.getDatabase();
            SourceInter<byte[], byte[]> other$database = other.getDatabase();
            if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
                return false;
            }
            return Arrays.equals(this.getKey(), other.getKey());
        }

        protected boolean canEqual(Object other) {
            return other instanceof RevokingTuple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SourceInter<byte[], byte[]> $database = this.getDatabase();
            result = result * 59 + ($database == null ? 43 : $database.hashCode());
            result = result * 59 + Arrays.hashCode(this.getKey());
            return result;
        }

        public SourceInter<byte[], byte[]> getDatabase() {
            return this.database;
        }

        public byte[] getKey() {
            return this.key;
        }

        public String toString() {
            return "AbstractRevokingStore.RevokingTuple(database=" + this.getDatabase() + ", key=" + Arrays.toString(this.getKey()) + ")";
        }
    }

    static class RevokingState {
        Map<RevokingTuple, byte[]> oldValues = new HashMap<RevokingTuple, byte[]>();
        Set<RevokingTuple> newIds = new HashSet<RevokingTuple>();
        Map<RevokingTuple, byte[]> removed = new HashMap<RevokingTuple, byte[]>();

        RevokingState() {
        }

        public String toString() {
            return "AbstractRevokingStore.RevokingState(oldValues=" + this.getOldValues() + ", newIds=" + this.getNewIds() + ", removed=" + this.getRemoved() + ")";
        }

        public Map<RevokingTuple, byte[]> getOldValues() {
            return this.oldValues;
        }

        public Set<RevokingTuple> getNewIds() {
            return this.newIds;
        }

        public Map<RevokingTuple, byte[]> getRemoved() {
            return this.removed;
        }
    }

    public static class Dialog
    implements ISession {
        private static final Logger logger = LoggerFactory.getLogger(Dialog.class);
        private RevokingDatabase revokingDatabase;
        private boolean applyRevoking = true;
        private boolean disableOnExit = false;

        public Dialog(Dialog dialog) {
            this.revokingDatabase = dialog.revokingDatabase;
            this.applyRevoking = dialog.applyRevoking;
            dialog.applyRevoking = false;
        }

        public Dialog(RevokingDatabase revokingDatabase) {
            this(revokingDatabase, false);
        }

        public Dialog(RevokingDatabase revokingDatabase, boolean disableOnExit) {
            this.revokingDatabase = revokingDatabase;
            this.disableOnExit = disableOnExit;
        }

        @Override
        public void commit() {
            this.applyRevoking = false;
            this.revokingDatabase.commit();
        }

        @Override
        public void revoke() {
            if (this.applyRevoking) {
                this.revokingDatabase.revoke();
            }
            this.applyRevoking = false;
        }

        @Override
        public void merge() {
            if (this.applyRevoking) {
                this.revokingDatabase.merge();
            }
            this.applyRevoking = false;
        }

        void copy(Dialog dialog) {
            if (this.equals(dialog)) {
                return;
            }
            if (this.applyRevoking) {
                this.revokingDatabase.revoke();
            }
            this.applyRevoking = dialog.applyRevoking;
            dialog.applyRevoking = false;
        }

        @Override
        public void destroy() {
            try {
                if (this.applyRevoking) {
                    this.revokingDatabase.revoke();
                }
            }
            catch (Exception e) {
                logger.error("revoke database error.", (Throwable)e);
            }
            if (this.disableOnExit) {
                this.revokingDatabase.disable();
            }
        }

        @Override
        public void close() {
            try {
                if (this.applyRevoking) {
                    this.revokingDatabase.revoke();
                }
            }
            catch (Exception e) {
                logger.error("revoke database error.", (Throwable)e);
                throw new RevokingStoreIllegalStateException(e);
            }
            if (this.disableOnExit) {
                this.revokingDatabase.disable();
            }
        }

        public RevokingDatabase getRevokingDatabase() {
            return this.revokingDatabase;
        }

        public boolean isApplyRevoking() {
            return this.applyRevoking;
        }

        public boolean isDisableOnExit() {
            return this.disableOnExit;
        }
    }
}

