/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalWitnesses {
    private static final Logger logger = LoggerFactory.getLogger(LocalWitnesses.class);
    private List<String> privateKeys = Lists.newArrayList();

    public LocalWitnesses() {
    }

    public LocalWitnesses(String privateKey) {
        this.addPrivateKeys(privateKey);
    }

    public LocalWitnesses(List<String> privateKeys) {
        this.setPrivateKeys(privateKeys);
    }

    public void setPrivateKeys(List<String> privateKeys) {
        if (CollectionUtils.isEmpty(privateKeys)) {
            return;
        }
        for (String privateKey : privateKeys) {
            this.validate(privateKey);
        }
        this.privateKeys = privateKeys;
    }

    private void validate(String privateKey) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)privateKey, (CharSequence)"0X")) {
            privateKey = privateKey.substring(2);
        }
        if (StringUtils.isNotBlank((CharSequence)privateKey) && privateKey.length() != 64) {
            throw new IllegalArgumentException("Private key(" + privateKey + ") must be " + 64 + "-bits hex string.");
        }
    }

    public void addPrivateKeys(String privateKey) {
        this.validate(privateKey);
        this.privateKeys.add(privateKey);
    }

    public String getPrivateKey() {
        if (CollectionUtils.isEmpty(this.privateKeys)) {
            logger.warn("privateKey is null");
            return null;
        }
        return this.privateKeys.get(0);
    }

    public List<String> getPrivateKeys() {
        return this.privateKeys;
    }
}

