/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config.args;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.tron.core.config.args.Account;
import org.tron.core.config.args.Witness;

public class GenesisBlock
implements Serializable {
    private static final long serialVersionUID = 3559533002594201715L;
    public static final String DEFAULT_NUMBER = "0";
    public static final String DEFAULT_TIMESTAMP = "0";
    public static final String DEFAULT_PARENT_HASH = "0";
    private List<Account> assets;
    private List<Witness> witnesses;
    private String timestamp;
    private String parentHash;
    private String number = "0";

    public static GenesisBlock getDefault() {
        GenesisBlock genesisBlock = new GenesisBlock();
        List<Account> assets = Collections.emptyList();
        genesisBlock.setAssets(assets);
        List<Witness> witnesses = Collections.emptyList();
        genesisBlock.setWitnesses(witnesses);
        genesisBlock.setNumber("0");
        genesisBlock.setTimestamp("0");
        genesisBlock.setParentHash("0");
        return genesisBlock;
    }

    public void setAssets(List<Account> assets) {
        this.assets = assets;
        if (assets == null) {
            this.assets = Collections.emptyList();
        }
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        if (this.timestamp == null) {
            this.timestamp = "0";
        }
        try {
            long l = Long.parseLong(this.timestamp);
            if (l < 0L) {
                throw new IllegalArgumentException("Timestamp(" + timestamp + ") must be Long type.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Timestamp(" + timestamp + ") must be Long type.");
        }
    }

    public void setParentHash(String parentHash) {
        this.parentHash = parentHash;
        if (this.parentHash == null) {
            this.parentHash = "0";
        }
    }

    public void setNumber(String number) {
        this.number = "0";
    }

    public void setWitnesses(List<Witness> witnesses) {
        this.witnesses = witnesses;
        if (witnesses == null) {
            this.witnesses = Collections.emptyList();
        }
    }

    public List<Account> getAssets() {
        return this.assets;
    }

    public List<Witness> getWitnesses() {
        return this.witnesses;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getParentHash() {
        return this.parentHash;
    }

    public String getNumber() {
        return this.number;
    }
}

