/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static Config config;

    public static Config getByFileName(String shellConfFileName, String confFileName) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{shellConfFileName})) {
            File shellConfFile = new File(shellConfFileName);
            Configuration.resolveConfigFile(shellConfFileName, shellConfFile);
            return config;
        }
        if (StringUtils.isBlank((CharSequence)confFileName)) {
            throw new IllegalArgumentException("Configuration path is required!");
        }
        File confFile = new File(confFileName);
        Configuration.resolveConfigFile(confFileName, confFile);
        return config;
    }

    private static void resolveConfigFile(String fileName, File confFile) {
        if (confFile.exists()) {
            config = ConfigFactory.parseFile((File)confFile);
        } else if (Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName) != null) {
            config = ConfigFactory.load((String)fileName);
        } else {
            throw new IllegalArgumentException("Configuration path is required! No Such file " + fileName);
        }
    }
}

