/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class TransactionUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransactionUtil.class);

    public static Protocol.Transaction newGenesisTransaction(byte[] key, long value) throws IllegalArgumentException {
        if (!Wallet.addressValid(key)) {
            throw new IllegalArgumentException("Invalid address");
        }
        Contract.TransferContract transferContract = Contract.TransferContract.newBuilder().setAmount(value).setOwnerAddress(ByteString.copyFrom((byte[])"0x000000000000000000000".getBytes())).setToAddress(ByteString.copyFrom((byte[])key)).build();
        return new TransactionCapsule((Message)transferContract, Protocol.Transaction.Contract.ContractType.TransferContract).getInstance();
    }

    private static boolean checkBalance(long totalBalance, long totalSpent) {
        return totalBalance == totalSpent;
    }

    public static boolean validAccountName(byte[] accountName) {
        if (ArrayUtils.isEmpty((byte[])accountName)) {
            return true;
        }
        return accountName.length <= 200;
    }

    public static boolean validAccountId(byte[] accountId) {
        if (ArrayUtils.isEmpty((byte[])accountId)) {
            return false;
        }
        if (accountId.length < 8) {
            return false;
        }
        if (accountId.length > 32) {
            return false;
        }
        for (byte b : accountId) {
            if (b < 33) {
                return false;
            }
            if (b <= 126) continue;
            return false;
        }
        return true;
    }

    public static boolean validAssetName(byte[] assetName) {
        if (ArrayUtils.isEmpty((byte[])assetName)) {
            return false;
        }
        if (assetName.length > 32) {
            return false;
        }
        for (byte b : assetName) {
            if (b < 33) {
                return false;
            }
            if (b <= 126) continue;
            return false;
        }
        return true;
    }

    public static boolean validTokenAbbrName(byte[] abbrName) {
        if (ArrayUtils.isEmpty((byte[])abbrName)) {
            return false;
        }
        if (abbrName.length > 5) {
            return false;
        }
        for (byte b : abbrName) {
            if (b < 33) {
                return false;
            }
            if (b <= 126) continue;
            return false;
        }
        return true;
    }

    public static boolean validAssetDescription(byte[] description) {
        if (ArrayUtils.isEmpty((byte[])description)) {
            return true;
        }
        return description.length <= 200;
    }

    public static boolean validUrl(byte[] url) {
        if (ArrayUtils.isEmpty((byte[])url)) {
            return false;
        }
        return url.length <= 256;
    }

    public static boolean isNumber(byte[] id) {
        if (ArrayUtils.isEmpty((byte[])id)) {
            return false;
        }
        for (byte b : id) {
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return id.length <= 1 || id[0] != 48;
    }
}

