/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeProcessor.class);
    private long supply;

    public ExchangeProcessor(long supply) {
        this.supply = supply;
    }

    private long exchange_to_supply(long balance, long quant) {
        logger.debug("balance: " + balance);
        long newBalance = balance + quant;
        logger.debug("balance + quant: " + newBalance);
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.debug("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchange_to_supply2(long balance, long quant) {
        logger.debug("balance: " + balance);
        long newBalance = balance - quant;
        logger.debug("balance - quant: " + (balance - quant));
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.debug("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchange_from_supply(long balance, long supplyQuant) {
        this.supply -= supplyQuant;
        double exchangeBalance = (double)balance * (Math.pow(1.0 + (double)supplyQuant / (double)this.supply, 2000.0) - 1.0);
        logger.debug("exchangeBalance: " + exchangeBalance);
        long out = (long)exchangeBalance;
        long newBalance = balance - out;
        return out;
    }

    public long exchange(long sellTokenBalance, long buyTokenBalance, long sellTokenQuant) {
        long relay = this.exchange_to_supply(sellTokenBalance, sellTokenQuant);
        return this.exchange_from_supply(buyTokenBalance, relay);
    }
}

