/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class VotesCapsule
implements ProtoCapsule<Protocol.Votes> {
    private static final Logger logger = LoggerFactory.getLogger(VotesCapsule.class);
    private Protocol.Votes votes;

    public VotesCapsule(Protocol.Votes votes) {
        this.votes = votes;
    }

    public VotesCapsule(byte[] data) {
        try {
            this.votes = Protocol.Votes.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public VotesCapsule(ByteString address, List<Protocol.Vote> oldVotes) {
        this.votes = Protocol.Votes.newBuilder().setAddress(address).addAllOldVotes(oldVotes).build();
    }

    public ByteString getAddress() {
        return this.votes.getAddress();
    }

    public void setAddress(ByteString address) {
        this.votes = this.votes.toBuilder().setAddress(address).build();
    }

    public List<Protocol.Vote> getOldVotes() {
        return this.votes.getOldVotesList();
    }

    public void setOldVotes(List<Protocol.Vote> oldVotes) {
        this.votes = this.votes.toBuilder().addAllOldVotes(oldVotes).build();
    }

    public List<Protocol.Vote> getNewVotes() {
        return this.votes.getNewVotesList();
    }

    public void clearNewVotes() {
        this.votes = this.votes.toBuilder().clearNewVotes().build();
    }

    public void addNewVotes(ByteString voteAddress, long voteCount) {
        this.votes = this.votes.toBuilder().addNewVotes(Protocol.Vote.newBuilder().setVoteAddress(voteAddress).setVoteCount(voteCount).build()).build();
    }

    public byte[] createDbKey() {
        return this.getAddress().toByteArray();
    }

    public String createReadableString() {
        return ByteArray.toHexString(this.getAddress().toByteArray());
    }

    @Override
    public byte[] getData() {
        return this.votes.toByteArray();
    }

    @Override
    public Protocol.Votes getInstance() {
        return this.votes;
    }
}

