/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.BadItemException;
import org.tron.protos.Protocol;

public class TransactionInfoCapsule
implements ProtoCapsule<Protocol.TransactionInfo> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionInfoCapsule.class);
    private Protocol.TransactionInfo transactionInfo;

    public TransactionInfoCapsule(Protocol.TransactionInfo trxRet) {
        this.transactionInfo = trxRet;
    }

    public TransactionInfoCapsule(byte[] data) throws BadItemException {
        try {
            this.transactionInfo = Protocol.TransactionInfo.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("TransactionInfoCapsule proto data parse exception");
        }
    }

    public TransactionInfoCapsule() {
        this.transactionInfo = Protocol.TransactionInfo.newBuilder().build();
    }

    public long getFee() {
        return this.transactionInfo.getFee();
    }

    public void setId(byte[] id) {
        this.transactionInfo = this.transactionInfo.toBuilder().setId(ByteString.copyFrom((byte[])id)).build();
    }

    public byte[] getId() {
        return this.transactionInfo.getId().toByteArray();
    }

    public void setUnfreezeAmount(long amount) {
        this.transactionInfo = this.transactionInfo.toBuilder().setUnfreezeAmount(amount).build();
    }

    public long getUnfreezeAmount() {
        return this.transactionInfo.getUnfreezeAmount();
    }

    public void setWithdrawAmount(long amount) {
        this.transactionInfo = this.transactionInfo.toBuilder().setWithdrawAmount(amount).build();
    }

    public long getWithdrawAmount() {
        return this.transactionInfo.getWithdrawAmount();
    }

    public void setFee(long fee) {
        this.transactionInfo = this.transactionInfo.toBuilder().setFee(fee).build();
    }

    public void setResult(Protocol.TransactionInfo.code result) {
        this.transactionInfo = this.transactionInfo.toBuilder().setResult(result).build();
    }

    public void setResMessage(String message) {
        this.transactionInfo = this.transactionInfo.toBuilder().setResMessage(ByteString.copyFromUtf8((String)message)).build();
    }

    public void addFee(long fee) {
        this.transactionInfo = this.transactionInfo.toBuilder().setFee(this.transactionInfo.getFee() + fee).build();
    }

    public long getBlockNumber() {
        return this.transactionInfo.getBlockNumber();
    }

    public void setBlockNumber(long num) {
        this.transactionInfo = this.transactionInfo.toBuilder().setBlockNumber(num).build();
    }

    public long getBlockTimeStamp() {
        return this.transactionInfo.getBlockTimeStamp();
    }

    public void setBlockTimeStamp(long time) {
        this.transactionInfo = this.transactionInfo.toBuilder().setBlockTimeStamp(time).build();
    }

    public void setContractResult(byte[] ret) {
        this.transactionInfo = this.transactionInfo.toBuilder().addContractResult(ByteString.copyFrom((byte[])ret)).build();
    }

    public void setContractAddress(byte[] contractAddress) {
        this.transactionInfo = this.transactionInfo.toBuilder().setContractAddress(ByteString.copyFrom((byte[])contractAddress)).build();
    }

    public void setReceipt(ReceiptCapsule receipt) {
        this.transactionInfo = this.transactionInfo.toBuilder().setReceipt(receipt.getReceipt()).build();
    }

    public void addAllLog(List<Protocol.TransactionInfo.Log> logs) {
        this.transactionInfo = this.transactionInfo.toBuilder().addAllLog(logs).build();
    }

    @Override
    public byte[] getData() {
        return this.transactionInfo.toByteArray();
    }

    @Override
    public Protocol.TransactionInfo getInstance() {
        return this.transactionInfo;
    }

    public static TransactionInfoCapsule buildInstance(TransactionCapsule trxCap, BlockCapsule block, TransactionTrace trace) {
        Protocol.TransactionInfo.Builder builder = Protocol.TransactionInfo.newBuilder();
        ReceiptCapsule traceReceipt = trace.getReceipt();
        builder.setResult(Protocol.TransactionInfo.code.SUCESS);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{trace.getRuntimeError()}) || Objects.nonNull(trace.getRuntimeResult().getException())) {
            builder.setResult(Protocol.TransactionInfo.code.FAILED);
            builder.setResMessage(ByteString.copyFromUtf8((String)trace.getRuntimeError()));
        }
        builder.setId(ByteString.copyFrom((byte[])trxCap.getTransactionId().getBytes()));
        ProgramResult programResult = trace.getRuntimeResult();
        long fee = programResult.getRet().getFee() + traceReceipt.getEnergyFee() + traceReceipt.getNetFee();
        ByteString contractResult2 = ByteString.copyFrom((byte[])programResult.getHReturn());
        ByteString ContractAddress = ByteString.copyFrom((byte[])programResult.getContractAddress());
        builder.setFee(fee);
        builder.addContractResult(contractResult2);
        builder.setContractAddress(ContractAddress);
        builder.setUnfreezeAmount(programResult.getRet().getUnfreezeAmount());
        builder.setAssetIssueID(programResult.getRet().getAssetIssueID());
        builder.setExchangeId(programResult.getRet().getExchangeId());
        builder.setWithdrawAmount(programResult.getRet().getWithdrawAmount());
        builder.setExchangeReceivedAmount(programResult.getRet().getExchangeReceivedAmount());
        builder.setExchangeInjectAnotherAmount(programResult.getRet().getExchangeInjectAnotherAmount());
        builder.setExchangeWithdrawAnotherAmount(programResult.getRet().getExchangeWithdrawAnotherAmount());
        ArrayList logList = new ArrayList();
        programResult.getLogInfoList().forEach(logInfo -> logList.add(LogInfo.buildLog(logInfo)));
        builder.addAllLog(logList);
        if (Objects.nonNull(block)) {
            builder.setBlockNumber(block.getInstance().getBlockHeader().getRawData().getNumber());
            builder.setBlockTimeStamp(block.getInstance().getBlockHeader().getRawData().getTimestamp());
        }
        builder.setReceipt(traceReceipt.getReceipt());
        if (null != programResult.getInternalTransactions()) {
            for (InternalTransaction internalTransaction : programResult.getInternalTransactions()) {
                Protocol.InternalTransaction.Builder internalTrxBuilder = Protocol.InternalTransaction.newBuilder();
                internalTrxBuilder.setHash(ByteString.copyFrom((byte[])internalTransaction.getHash()));
                internalTrxBuilder.setCallerAddress(ByteString.copyFrom((byte[])internalTransaction.getSender()));
                internalTrxBuilder.setTransferToAddress(ByteString.copyFrom((byte[])internalTransaction.getTransferToAddress()));
                Protocol.InternalTransaction.CallValueInfo.Builder callValueInfoBuilder = Protocol.InternalTransaction.CallValueInfo.newBuilder();
                callValueInfoBuilder.setCallValue(internalTransaction.getValue());
                internalTrxBuilder.addCallValueInfo(callValueInfoBuilder);
                internalTransaction.getTokenInfo().forEach((tokenId, amount) -> {
                    Protocol.InternalTransaction.CallValueInfo.Builder tokenInfoBuilder = Protocol.InternalTransaction.CallValueInfo.newBuilder();
                    tokenInfoBuilder.setTokenId((String)tokenId);
                    tokenInfoBuilder.setCallValue((long)amount);
                    internalTrxBuilder.addCallValueInfo(tokenInfoBuilder);
                });
                internalTrxBuilder.setNote(ByteString.copyFrom((byte[])internalTransaction.getNote().getBytes()));
                internalTrxBuilder.setRejected(internalTransaction.isRejected());
                builder.addInternalTransactions(internalTrxBuilder);
            }
        }
        return new TransactionInfoCapsule(builder.build());
    }
}

