/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tron.common.crypto.ECKey;
import org.tron.common.runtime.Runtime;
import org.tron.common.runtime.vm.program.Program;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.Wallet;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.AccountStore;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class TransactionCapsule
implements ProtoCapsule<Protocol.Transaction> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionCapsule.class);
    private Protocol.Transaction transaction;
    private boolean isVerified = false;
    private long blockNum = -1L;
    private TransactionTrace trxTrace;
    private StringBuffer toStringBuff = new StringBuffer();

    public TransactionCapsule(Protocol.Transaction trx) {
        this.transaction = trx;
    }

    public TransactionCapsule(byte[] data) throws BadItemException {
        try {
            this.transaction = Protocol.Transaction.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("Transaction proto data parse exception");
        }
    }

    public TransactionCapsule(Contract.AccountCreateContract contract, AccountStore accountStore) {
        AccountCapsule account = accountStore.get(contract.getOwnerAddress().toByteArray());
        if (account != null && account.getType() == contract.getType()) {
            return;
        }
        this.createTransaction((Message)contract, Protocol.Transaction.Contract.ContractType.AccountCreateContract);
    }

    public TransactionCapsule(Contract.TransferContract contract, AccountStore accountStore) {
        Protocol.Transaction.Contract.Builder contractBuilder = Protocol.Transaction.Contract.newBuilder();
        AccountCapsule owner = accountStore.get(contract.getOwnerAddress().toByteArray());
        if (owner == null || owner.getBalance() < contract.getAmount()) {
            return;
        }
        this.createTransaction((Message)contract, Protocol.Transaction.Contract.ContractType.TransferContract);
    }

    public TransactionCapsule(Contract.VoteWitnessContract voteWitnessContract) {
        this.createTransaction((Message)voteWitnessContract, Protocol.Transaction.Contract.ContractType.VoteWitnessContract);
    }

    public TransactionCapsule(Contract.WitnessCreateContract witnessCreateContract) {
        this.createTransaction((Message)witnessCreateContract, Protocol.Transaction.Contract.ContractType.WitnessCreateContract);
    }

    public TransactionCapsule(Contract.WitnessUpdateContract witnessUpdateContract) {
        this.createTransaction((Message)witnessUpdateContract, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract);
    }

    public TransactionCapsule(Contract.TransferAssetContract transferAssetContract) {
        this.createTransaction((Message)transferAssetContract, Protocol.Transaction.Contract.ContractType.TransferAssetContract);
    }

    public TransactionCapsule(Contract.ParticipateAssetIssueContract participateAssetIssueContract) {
        this.createTransaction((Message)participateAssetIssueContract, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract);
    }

    public TransactionCapsule(Protocol.Transaction.raw rawData, List<ByteString> signatureList) {
        this.transaction = Protocol.Transaction.newBuilder().setRawData(rawData).addAllSignature(signatureList).build();
    }

    public void resetResult() {
        if (this.getInstance().getRetCount() > 0) {
            this.transaction = this.getInstance().toBuilder().clearRet().build();
        }
    }

    public void setResult(TransactionResultCapsule transactionResultCapsule) {
        this.transaction = this.getInstance().toBuilder().addRet(transactionResultCapsule.getInstance()).build();
    }

    public void setReference(long blockNum, byte[] blockHash) {
        byte[] refBlockNum = ByteArray.fromLong(blockNum);
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setRefBlockHash(ByteString.copyFrom((byte[])ByteArray.subArray(blockHash, 8, 16))).setRefBlockBytes(ByteString.copyFrom((byte[])ByteArray.subArray(refBlockNum, 6, 8))).build();
        this.transaction = this.transaction.toBuilder().setRawData(rawData).build();
    }

    public void setExpiration(long expiration) {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setExpiration(expiration).build();
        this.transaction = this.transaction.toBuilder().setRawData(rawData).build();
    }

    public long getExpiration() {
        return this.transaction.getRawData().getExpiration();
    }

    public void setTimestamp() {
        Protocol.Transaction.raw rawData = this.transaction.getRawData().toBuilder().setTimestamp(System.currentTimeMillis()).build();
        this.transaction = this.transaction.toBuilder().setRawData(rawData).build();
    }

    public long getTimestamp() {
        return this.transaction.getRawData().getTimestamp();
    }

    @Deprecated
    public TransactionCapsule(Contract.AssetIssueContract assetIssueContract) {
        this.createTransaction((Message)assetIssueContract, Protocol.Transaction.Contract.ContractType.AssetIssueContract);
    }

    public TransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) {
        Protocol.Transaction.raw.Builder transactionBuilder = Protocol.Transaction.raw.newBuilder().addContract(Protocol.Transaction.Contract.newBuilder().setType(contractType).setParameter(Any.pack((Message)message)).build());
        this.transaction = Protocol.Transaction.newBuilder().setRawData(transactionBuilder.build()).build();
    }

    @Deprecated
    public void createTransaction(Message message, Protocol.Transaction.Contract.ContractType contractType) {
        Protocol.Transaction.raw.Builder transactionBuilder = Protocol.Transaction.raw.newBuilder().addContract(Protocol.Transaction.Contract.newBuilder().setType(contractType).setParameter(Any.pack((Message)message)).build());
        this.transaction = Protocol.Transaction.newBuilder().setRawData(transactionBuilder.build()).build();
    }

    public Sha256Hash getMerkleHash() {
        byte[] transBytes = this.transaction.toByteArray();
        return Sha256Hash.of(transBytes);
    }

    private Sha256Hash getRawHash() {
        return Sha256Hash.of(this.transaction.getRawData().toByteArray());
    }

    public boolean checkBalance(byte[] address, byte[] to, long amount, long balance) {
        if (!Wallet.addressValid(address)) {
            logger.error("address invalid");
            return false;
        }
        if (!Wallet.addressValid(to)) {
            logger.error("address invalid");
            return false;
        }
        if (amount <= 0L) {
            logger.error("amount required a positive number");
            return false;
        }
        if (amount > balance) {
            logger.error("don't have enough money");
            return false;
        }
        return true;
    }

    public void sign(byte[] privateKey) {
        ECKey ecKey = ECKey.fromPrivate(privateKey);
        ECKey.ECDSASignature signature = ecKey.sign(this.getRawHash().getBytes());
        ByteString sig = ByteString.copyFrom((byte[])signature.toByteArray());
        this.transaction = this.transaction.toBuilder().addSignature(sig).build();
    }

    public static byte[] getOwner(Protocol.Transaction.Contract contract) {
        try {
            ByteString owner;
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case AccountCreateContract: {
                    owner = ((Contract.AccountCreateContract)contractParameter.unpack(Contract.AccountCreateContract.class)).getOwnerAddress();
                    break;
                }
                case TransferContract: {
                    owner = ((Contract.TransferContract)contractParameter.unpack(Contract.TransferContract.class)).getOwnerAddress();
                    break;
                }
                case TransferAssetContract: {
                    owner = ((Contract.TransferAssetContract)contractParameter.unpack(Contract.TransferAssetContract.class)).getOwnerAddress();
                    break;
                }
                case VoteAssetContract: {
                    owner = ((Contract.VoteAssetContract)contractParameter.unpack(Contract.VoteAssetContract.class)).getOwnerAddress();
                    break;
                }
                case VoteWitnessContract: {
                    owner = ((Contract.VoteWitnessContract)contractParameter.unpack(Contract.VoteWitnessContract.class)).getOwnerAddress();
                    break;
                }
                case WitnessCreateContract: {
                    owner = ((Contract.WitnessCreateContract)contractParameter.unpack(Contract.WitnessCreateContract.class)).getOwnerAddress();
                    break;
                }
                case AssetIssueContract: {
                    owner = ((Contract.AssetIssueContract)contractParameter.unpack(Contract.AssetIssueContract.class)).getOwnerAddress();
                    break;
                }
                case WitnessUpdateContract: {
                    owner = ((Contract.WitnessUpdateContract)contractParameter.unpack(Contract.WitnessUpdateContract.class)).getOwnerAddress();
                    break;
                }
                case ParticipateAssetIssueContract: {
                    owner = ((Contract.ParticipateAssetIssueContract)contractParameter.unpack(Contract.ParticipateAssetIssueContract.class)).getOwnerAddress();
                    break;
                }
                case AccountUpdateContract: {
                    owner = ((Contract.AccountUpdateContract)contractParameter.unpack(Contract.AccountUpdateContract.class)).getOwnerAddress();
                    break;
                }
                case FreezeBalanceContract: {
                    owner = ((Contract.FreezeBalanceContract)contractParameter.unpack(Contract.FreezeBalanceContract.class)).getOwnerAddress();
                    break;
                }
                case UnfreezeBalanceContract: {
                    owner = ((Contract.UnfreezeBalanceContract)contractParameter.unpack(Contract.UnfreezeBalanceContract.class)).getOwnerAddress();
                    break;
                }
                case UnfreezeAssetContract: {
                    owner = ((Contract.UnfreezeAssetContract)contractParameter.unpack(Contract.UnfreezeAssetContract.class)).getOwnerAddress();
                    break;
                }
                case WithdrawBalanceContract: {
                    owner = ((Contract.WithdrawBalanceContract)contractParameter.unpack(Contract.WithdrawBalanceContract.class)).getOwnerAddress();
                    break;
                }
                case CreateSmartContract: {
                    owner = ((Contract.CreateSmartContract)contractParameter.unpack(Contract.CreateSmartContract.class)).getOwnerAddress();
                    break;
                }
                case TriggerSmartContract: {
                    owner = ((Contract.TriggerSmartContract)contractParameter.unpack(Contract.TriggerSmartContract.class)).getOwnerAddress();
                    break;
                }
                case UpdateAssetContract: {
                    owner = ((Contract.UpdateAssetContract)contractParameter.unpack(Contract.UpdateAssetContract.class)).getOwnerAddress();
                    break;
                }
                case ProposalCreateContract: {
                    owner = ((Contract.ProposalCreateContract)contractParameter.unpack(Contract.ProposalCreateContract.class)).getOwnerAddress();
                    break;
                }
                case ProposalApproveContract: {
                    owner = ((Contract.ProposalApproveContract)contractParameter.unpack(Contract.ProposalApproveContract.class)).getOwnerAddress();
                    break;
                }
                case ProposalDeleteContract: {
                    owner = ((Contract.ProposalDeleteContract)contractParameter.unpack(Contract.ProposalDeleteContract.class)).getOwnerAddress();
                    break;
                }
                case SetAccountIdContract: {
                    owner = ((Contract.SetAccountIdContract)contractParameter.unpack(Contract.SetAccountIdContract.class)).getOwnerAddress();
                    break;
                }
                case UpdateSettingContract: {
                    owner = ((Contract.UpdateSettingContract)contractParameter.unpack(Contract.UpdateSettingContract.class)).getOwnerAddress();
                    break;
                }
                case UpdateEnergyLimitContract: {
                    owner = ((Contract.UpdateEnergyLimitContract)contractParameter.unpack(Contract.UpdateEnergyLimitContract.class)).getOwnerAddress();
                    break;
                }
                case ExchangeCreateContract: {
                    owner = ((Contract.ExchangeCreateContract)contractParameter.unpack(Contract.ExchangeCreateContract.class)).getOwnerAddress();
                    break;
                }
                case ExchangeInjectContract: {
                    owner = ((Contract.ExchangeInjectContract)contractParameter.unpack(Contract.ExchangeInjectContract.class)).getOwnerAddress();
                    break;
                }
                case ExchangeWithdrawContract: {
                    owner = ((Contract.ExchangeWithdrawContract)contractParameter.unpack(Contract.ExchangeWithdrawContract.class)).getOwnerAddress();
                    break;
                }
                case ExchangeTransactionContract: {
                    owner = ((Contract.ExchangeTransactionContract)contractParameter.unpack(Contract.ExchangeTransactionContract.class)).getOwnerAddress();
                    break;
                }
                default: {
                    return null;
                }
            }
            return owner.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public static byte[] getToAddress(Protocol.Transaction.Contract contract) {
        try {
            ByteString to;
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TransferContract: {
                    to = ((Contract.TransferContract)contractParameter.unpack(Contract.TransferContract.class)).getToAddress();
                    break;
                }
                case TransferAssetContract: {
                    to = ((Contract.TransferAssetContract)contractParameter.unpack(Contract.TransferAssetContract.class)).getToAddress();
                    break;
                }
                case ParticipateAssetIssueContract: {
                    to = ((Contract.ParticipateAssetIssueContract)contractParameter.unpack(Contract.ParticipateAssetIssueContract.class)).getToAddress();
                    break;
                }
                default: {
                    return null;
                }
            }
            return to.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public static long getCallValue(Protocol.Transaction.Contract contract) {
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TriggerSmartContract: {
                    return ((Contract.TriggerSmartContract)contractParameter.unpack(Contract.TriggerSmartContract.class)).getCallValue();
                }
                case CreateSmartContract: {
                    return ((Contract.CreateSmartContract)contractParameter.unpack(Contract.CreateSmartContract.class)).getNewContract().getCallValue();
                }
            }
            return 0L;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0L;
        }
    }

    public static long getCallTokenValue(Protocol.Transaction.Contract contract) {
        try {
            Any contractParameter = contract.getParameter();
            switch (contract.getType()) {
                case TriggerSmartContract: {
                    return ((Contract.TriggerSmartContract)contractParameter.unpack(Contract.TriggerSmartContract.class)).getCallTokenValue();
                }
                case CreateSmartContract: {
                    return ((Contract.CreateSmartContract)contractParameter.unpack(Contract.CreateSmartContract.class)).getCallTokenValue();
                }
            }
            return 0L;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return 0L;
        }
    }

    public static String getBase64FromByteString(ByteString sign) {
        byte[] r = sign.substring(0, 32).toByteArray();
        byte[] s = sign.substring(32, 64).toByteArray();
        byte v = sign.byteAt(64);
        if (v < 27) {
            v = (byte)(v + 27);
        }
        ECKey.ECDSASignature signature = ECKey.ECDSASignature.fromComponents(r, s, v);
        return signature.toBase64();
    }

    public boolean validateSignature() throws ValidateSignatureException {
        if (this.isVerified) {
            return true;
        }
        if (this.getInstance().getSignatureCount() != this.getInstance().getRawData().getContractCount()) {
            throw new ValidateSignatureException("miss sig or contract");
        }
        List<Protocol.Transaction.Contract> listContract = this.transaction.getRawData().getContractList();
        for (int i = 0; i < this.transaction.getSignatureCount(); ++i) {
            try {
                Protocol.Transaction.Contract contract = listContract.get(i);
                byte[] owner = TransactionCapsule.getOwner(contract);
                byte[] address = ECKey.signatureToAddress(this.getRawHash().getBytes(), TransactionCapsule.getBase64FromByteString(this.transaction.getSignature(i)));
                if (Arrays.equals(owner, address)) continue;
                this.isVerified = false;
                throw new ValidateSignatureException("sig error");
            }
            catch (SignatureException e) {
                this.isVerified = false;
                throw new ValidateSignatureException(e.getMessage());
            }
        }
        this.isVerified = true;
        return true;
    }

    public Sha256Hash getTransactionId() {
        return this.getRawHash();
    }

    @Override
    public byte[] getData() {
        return this.transaction.toByteArray();
    }

    public long getSerializedSize() {
        return this.transaction.getSerializedSize();
    }

    public long getResultSerializedSize() {
        long size = 0L;
        for (Protocol.Transaction.Result result : this.transaction.getRetList()) {
            size += (long)result.getSerializedSize();
        }
        return size;
    }

    @Override
    public Protocol.Transaction getInstance() {
        return this.transaction;
    }

    public String toString() {
        this.toStringBuff.setLength(0);
        this.toStringBuff.append("TransactionCapsule \n[ ");
        this.toStringBuff.append("hash=").append(this.getTransactionId()).append("\n");
        AtomicInteger i = new AtomicInteger();
        if (!this.getInstance().getRawData().getContractList().isEmpty()) {
            this.toStringBuff.append("contract list:{ ");
            this.getInstance().getRawData().getContractList().forEach(contract -> {
                this.toStringBuff.append("[" + i + "] ").append("type: ").append((Object)contract.getType()).append("\n");
                this.toStringBuff.append("from address=").append(TransactionCapsule.getOwner(contract)).append("\n");
                this.toStringBuff.append("to address=").append(TransactionCapsule.getToAddress(contract)).append("\n");
                if (contract.getType().equals((Object)Protocol.Transaction.Contract.ContractType.TransferContract)) {
                    try {
                        Contract.TransferContract transferContract = (Contract.TransferContract)contract.getParameter().unpack(Contract.TransferContract.class);
                        this.toStringBuff.append("transfer amount=").append(transferContract.getAmount()).append("\n");
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                } else if (contract.getType().equals((Object)Protocol.Transaction.Contract.ContractType.TransferAssetContract)) {
                    try {
                        Contract.TransferAssetContract transferAssetContract = (Contract.TransferAssetContract)contract.getParameter().unpack(Contract.TransferAssetContract.class);
                        this.toStringBuff.append("transfer asset=").append(transferAssetContract.getAssetName()).append("\n");
                        this.toStringBuff.append("transfer amount=").append(transferAssetContract.getAmount()).append("\n");
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                }
                if (this.transaction.getSignatureList().size() >= i.get() + 1) {
                    this.toStringBuff.append("sign=").append(TransactionCapsule.getBase64FromByteString(this.transaction.getSignature(i.getAndIncrement()))).append("\n");
                }
            });
            this.toStringBuff.append("}\n");
        } else {
            this.toStringBuff.append("contract list is empty\n");
        }
        this.toStringBuff.append("]");
        return this.toStringBuff.toString();
    }

    public void setResult(Runtime runtime) {
        RuntimeException exception = runtime.getResult().getException();
        if (Objects.isNull(exception) && StringUtils.isEmpty((Object)runtime.getRuntimeError()) && !runtime.getResult().isRevert()) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.SUCCESS);
            return;
        }
        if (runtime.getResult().isRevert()) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.REVERT);
            return;
        }
        if (exception instanceof Program.IllegalOperationException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.ILLEGAL_OPERATION);
            return;
        }
        if (exception instanceof Program.OutOfEnergyException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_ENERGY);
            return;
        }
        if (exception instanceof Program.BadJumpDestinationException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.BAD_JUMP_DESTINATION);
            return;
        }
        if (exception instanceof Program.OutOfTimeException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_TIME);
            return;
        }
        if (exception instanceof Program.OutOfMemoryException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.OUT_OF_MEMORY);
            return;
        }
        if (exception instanceof Program.PrecompiledContractException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.PRECOMPILED_CONTRACT);
            return;
        }
        if (exception instanceof Program.StackTooSmallException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.STACK_TOO_SMALL);
            return;
        }
        if (exception instanceof Program.StackTooLargeException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.STACK_TOO_LARGE);
            return;
        }
        if (exception instanceof Program.JVMStackOverFlowException) {
            this.setResultCode(Protocol.Transaction.Result.contractResult.JVM_STACK_OVER_FLOW);
            return;
        }
        this.setResultCode(Protocol.Transaction.Result.contractResult.UNKNOWN);
    }

    public void setResultCode(Protocol.Transaction.Result.contractResult code2) {
        Protocol.Transaction.Result ret = Protocol.Transaction.Result.newBuilder().setContractRet(code2).build();
        if (this.transaction.getRetCount() > 0) {
            ret = this.transaction.getRet(0).toBuilder().setContractRet(code2).build();
            this.transaction = this.transaction.toBuilder().setRet(0, ret).build();
            return;
        }
        this.transaction = this.transaction.toBuilder().addRet(ret).build();
    }

    public Protocol.Transaction.Result.contractResult getContractRet() {
        if (this.transaction.getRetCount() <= 0) {
            return null;
        }
        return this.transaction.getRet(0).getContractRet();
    }

    public void setVerified(boolean isVerified) {
        this.isVerified = isVerified;
    }

    public void setBlockNum(long blockNum) {
        this.blockNum = blockNum;
    }

    public long getBlockNum() {
        return this.blockNum;
    }

    public TransactionTrace getTrxTrace() {
        return this.trxTrace;
    }

    public void setTrxTrace(TransactionTrace trxTrace) {
        this.trxTrace = trxTrace;
    }
}

