/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Protocol;

public class DelegatedResourceAccountIndexCapsule
implements ProtoCapsule<Protocol.DelegatedResourceAccountIndex> {
    private static final Logger logger = LoggerFactory.getLogger(DelegatedResourceAccountIndexCapsule.class);
    private Protocol.DelegatedResourceAccountIndex delegatedResourceAccountIndex;

    public DelegatedResourceAccountIndexCapsule(Protocol.DelegatedResourceAccountIndex delegatedResourceAccountIndex) {
        this.delegatedResourceAccountIndex = delegatedResourceAccountIndex;
    }

    public DelegatedResourceAccountIndexCapsule(byte[] data) {
        try {
            this.delegatedResourceAccountIndex = Protocol.DelegatedResourceAccountIndex.parseFrom(data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public DelegatedResourceAccountIndexCapsule(ByteString address) {
        this.delegatedResourceAccountIndex = Protocol.DelegatedResourceAccountIndex.newBuilder().setAccount(address).build();
    }

    public ByteString getAccount() {
        return this.delegatedResourceAccountIndex.getAccount();
    }

    public void setAccount(ByteString address) {
        this.delegatedResourceAccountIndex = this.delegatedResourceAccountIndex.toBuilder().setAccount(address).build();
    }

    public List<ByteString> getFromAccountsList() {
        return this.delegatedResourceAccountIndex.getFromAccountsList();
    }

    public void setAllFromAccounts(List<ByteString> fromAccounts) {
        this.delegatedResourceAccountIndex = this.delegatedResourceAccountIndex.toBuilder().clearFromAccounts().addAllFromAccounts(fromAccounts).build();
    }

    public void addFromAccount(ByteString fromAccount) {
        this.delegatedResourceAccountIndex = this.delegatedResourceAccountIndex.toBuilder().addFromAccounts(fromAccount).build();
    }

    public List<ByteString> getToAccountsList() {
        return this.delegatedResourceAccountIndex.getToAccountsList();
    }

    public void setAllToAccounts(List<ByteString> toAccounts) {
        this.delegatedResourceAccountIndex = this.delegatedResourceAccountIndex.toBuilder().clearToAccounts().addAllToAccounts(toAccounts).build();
    }

    public void addToAccount(ByteString toAccount) {
        this.delegatedResourceAccountIndex = this.delegatedResourceAccountIndex.toBuilder().addToAccounts(toAccount).build();
    }

    public byte[] createDbKey() {
        return this.getAccount().toByteArray();
    }

    public String createReadableString() {
        return ByteArray.toHexString(this.getAccount().toByteArray());
    }

    @Override
    public byte[] getData() {
        return this.delegatedResourceAccountIndex.toByteArray();
    }

    @Override
    public Protocol.DelegatedResourceAccountIndex getInstance() {
        return this.delegatedResourceAccountIndex;
    }
}

