/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ContractCapsule
implements ProtoCapsule<Protocol.SmartContract> {
    private static final Logger logger = LoggerFactory.getLogger(ContractCapsule.class);
    private Protocol.SmartContract smartContract;

    public ContractCapsule(Protocol.SmartContract smartContract) {
        this.smartContract = smartContract;
    }

    public ContractCapsule(byte[] data) {
        try {
            this.smartContract = Protocol.SmartContract.parseFrom(data);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    public static Contract.CreateSmartContract getSmartContractFromTransaction(Protocol.Transaction trx) {
        try {
            Any any = trx.getRawData().getContract(0).getParameter();
            Contract.CreateSmartContract createSmartContract = (Contract.CreateSmartContract)any.unpack(Contract.CreateSmartContract.class);
            return createSmartContract;
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public static Contract.TriggerSmartContract getTriggerContractFromTransaction(Protocol.Transaction trx) {
        try {
            Any any = trx.getRawData().getContract(0).getParameter();
            Contract.TriggerSmartContract contractTriggerContract = (Contract.TriggerSmartContract)any.unpack(Contract.TriggerSmartContract.class);
            return contractTriggerContract;
        }
        catch (InvalidProtocolBufferException e) {
            return null;
        }
    }

    public Sha256Hash getHash() {
        byte[] transBytes = this.smartContract.toByteArray();
        return Sha256Hash.of(transBytes);
    }

    public Sha256Hash getCodeHash() {
        byte[] bytecode = this.smartContract.getBytecode().toByteArray();
        return Sha256Hash.of(bytecode);
    }

    @Override
    public byte[] getData() {
        return this.smartContract.toByteArray();
    }

    @Override
    public Protocol.SmartContract getInstance() {
        return this.smartContract;
    }

    public String toString() {
        return this.smartContract.toString();
    }

    public byte[] getOriginAddress() {
        return this.smartContract.getOriginAddress().toByteArray();
    }

    public long getConsumeUserResourcePercent() {
        long percent = this.smartContract.getConsumeUserResourcePercent();
        return Math.max(0L, Math.min(percent, 100L));
    }

    public long getOriginEnergyLimit() {
        long originEnergyLimit = this.smartContract.getOriginEnergyLimit();
        if (originEnergyLimit == 0L) {
            originEnergyLimit = 10000000L;
        }
        return originEnergyLimit;
    }
}

