/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Time;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.utils.MerkleTree;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.protos.Protocol;

public class BlockCapsule
implements ProtoCapsule<Protocol.Block> {
    private static final Logger logger = LoggerFactory.getLogger(BlockCapsule.class);
    private BlockId blockId = new BlockId(Sha256Hash.ZERO_HASH, 0L);
    private Protocol.Block block;
    public boolean generatedByMyself = false;
    private List<TransactionCapsule> transactions = new ArrayList<TransactionCapsule>();
    private StringBuffer toStringBuff = new StringBuffer();

    public BlockCapsule(long number, Sha256Hash hash, long when, ByteString witnessAddress) {
        Protocol.BlockHeader.raw.Builder blockHeaderRawBuild = Protocol.BlockHeader.raw.newBuilder();
        Protocol.BlockHeader.raw blockHeaderRaw = blockHeaderRawBuild.setNumber(number).setParentHash(hash.getByteString()).setTimestamp(when).setVersion(5).setWitnessAddress(witnessAddress).build();
        Protocol.BlockHeader.Builder blockHeaderBuild = Protocol.BlockHeader.newBuilder();
        Protocol.BlockHeader blockHeader = blockHeaderBuild.setRawData(blockHeaderRaw).build();
        Protocol.Block.Builder blockBuild = Protocol.Block.newBuilder();
        this.block = blockBuild.setBlockHeader(blockHeader).build();
        this.initTxs();
    }

    public BlockCapsule(long timestamp, ByteString parentHash, long number, List<Protocol.Transaction> transactionList) {
        Protocol.BlockHeader.raw.Builder blockHeaderRawBuild = Protocol.BlockHeader.raw.newBuilder();
        Protocol.BlockHeader.raw blockHeaderRaw = blockHeaderRawBuild.setTimestamp(timestamp).setParentHash(parentHash).setNumber(number).build();
        Protocol.BlockHeader.Builder blockHeaderBuild = Protocol.BlockHeader.newBuilder();
        Protocol.BlockHeader blockHeader = blockHeaderBuild.setRawData(blockHeaderRaw).build();
        Protocol.Block.Builder blockBuild = Protocol.Block.newBuilder();
        transactionList.forEach(trx -> blockBuild.addTransactions((Protocol.Transaction)trx));
        this.block = blockBuild.setBlockHeader(blockHeader).build();
        this.initTxs();
    }

    public BlockCapsule(Protocol.Block block) {
        this.block = block;
        this.initTxs();
    }

    public BlockCapsule(byte[] data) throws BadItemException {
        try {
            this.block = Protocol.Block.parseFrom(data);
            this.initTxs();
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("Block proto data parse exception");
        }
    }

    public void addTransaction(TransactionCapsule pendingTrx) {
        this.block = this.block.toBuilder().addTransactions(pendingTrx.getInstance()).build();
        this.getTransactions().add(pendingTrx);
    }

    public List<TransactionCapsule> getTransactions() {
        return this.transactions;
    }

    private void initTxs() {
        this.transactions = this.block.getTransactionsList().stream().map(trx -> new TransactionCapsule((Protocol.Transaction)trx)).collect(Collectors.toList());
    }

    public void sign(byte[] privateKey) {
        ECKey ecKey = ECKey.fromPrivate(privateKey);
        ECKey.ECDSASignature signature = ecKey.sign(this.getRawHash().getBytes());
        ByteString sig = ByteString.copyFrom((byte[])signature.toByteArray());
        Protocol.BlockHeader blockHeader = this.block.getBlockHeader().toBuilder().setWitnessSignature(sig).build();
        this.block = this.block.toBuilder().setBlockHeader(blockHeader).build();
    }

    private Sha256Hash getRawHash() {
        return Sha256Hash.of(this.block.getBlockHeader().getRawData().toByteArray());
    }

    public boolean validateSignature() throws ValidateSignatureException {
        try {
            return Arrays.equals(ECKey.signatureToAddress(this.getRawHash().getBytes(), TransactionCapsule.getBase64FromByteString(this.block.getBlockHeader().getWitnessSignature())), this.block.getBlockHeader().getRawData().getWitnessAddress().toByteArray());
        }
        catch (SignatureException e) {
            throw new ValidateSignatureException(e.getMessage());
        }
    }

    public BlockId getBlockId() {
        if (this.blockId.equals(Sha256Hash.ZERO_HASH)) {
            this.blockId = new BlockId(Sha256Hash.of(this.block.getBlockHeader().getRawData().toByteArray()), this.getNum());
        }
        return this.blockId;
    }

    public Sha256Hash calcMerkleRoot() {
        List<Protocol.Transaction> transactionsList = this.block.getTransactionsList();
        if (CollectionUtils.isEmpty(transactionsList)) {
            return Sha256Hash.ZERO_HASH;
        }
        Vector ids = transactionsList.stream().map(TransactionCapsule::new).map(TransactionCapsule::getMerkleHash).collect(Collectors.toCollection(Vector::new));
        return MerkleTree.getInstance().createTree(ids).getRoot().getHash();
    }

    public void setMerkleRoot() {
        Protocol.BlockHeader.raw blockHeaderRaw = this.block.getBlockHeader().getRawData().toBuilder().setTxTrieRoot(this.calcMerkleRoot().getByteString()).build();
        this.block = this.block.toBuilder().setBlockHeader(this.block.getBlockHeader().toBuilder().setRawData(blockHeaderRaw)).build();
    }

    public void setWitness(String witness) {
        Protocol.BlockHeader.raw blockHeaderRaw = this.block.getBlockHeader().getRawData().toBuilder().setWitnessAddress(ByteString.copyFrom((byte[])witness.getBytes())).build();
        this.block = this.block.toBuilder().setBlockHeader(this.block.getBlockHeader().toBuilder().setRawData(blockHeaderRaw)).build();
    }

    public Sha256Hash getMerkleRoot() {
        return Sha256Hash.wrap(this.block.getBlockHeader().getRawData().getTxTrieRoot());
    }

    public ByteString getWitnessAddress() {
        return this.block.getBlockHeader().getRawData().getWitnessAddress();
    }

    @Override
    public byte[] getData() {
        return this.block.toByteArray();
    }

    @Override
    public Protocol.Block getInstance() {
        return this.block;
    }

    public Sha256Hash getParentHash() {
        return Sha256Hash.wrap(this.block.getBlockHeader().getRawData().getParentHash());
    }

    public BlockId getParentBlockId() {
        return new BlockId(this.getParentHash(), this.getNum() - 1L);
    }

    public ByteString getParentHashStr() {
        return this.block.getBlockHeader().getRawData().getParentHash();
    }

    public long getNum() {
        return this.block.getBlockHeader().getRawData().getNumber();
    }

    public long getTimeStamp() {
        return this.block.getBlockHeader().getRawData().getTimestamp();
    }

    public String toString() {
        this.toStringBuff.setLength(0);
        this.toStringBuff.append("BlockCapsule \n[ ");
        this.toStringBuff.append("hash=").append(this.getBlockId()).append("\n");
        this.toStringBuff.append("number=").append(this.getNum()).append("\n");
        this.toStringBuff.append("parentId=").append(this.getParentHash()).append("\n");
        this.toStringBuff.append("witness address=").append(ByteUtil.toHexString(this.getWitnessAddress().toByteArray())).append("\n");
        this.toStringBuff.append("generated by myself=").append(this.generatedByMyself).append("\n");
        this.toStringBuff.append("generate time=").append(Time.getTimeString(this.getTimeStamp())).append("\n");
        if (!this.getTransactions().isEmpty()) {
            this.toStringBuff.append("merkle root=").append(this.getMerkleRoot()).append("\n");
            this.toStringBuff.append("txs size=").append(this.getTransactions().size()).append("\n");
        } else {
            this.toStringBuff.append("txs are empty\n");
        }
        this.toStringBuff.append("]");
        return this.toStringBuff.toString();
    }

    public static class BlockId
    extends Sha256Hash {
        private long num;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass() && !(o instanceof Sha256Hash)) {
                return false;
            }
            return Arrays.equals(this.getBytes(), ((Sha256Hash)o).getBytes());
        }

        public String getString() {
            return "Num:" + this.num + ",ID:" + super.toString();
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public int compareTo(Sha256Hash other) {
            if (other.getClass().equals(BlockId.class)) {
                long otherNum = ((BlockId)other).getNum();
                return Long.compare(this.num, otherNum);
            }
            return super.compareTo(other);
        }

        public BlockId() {
            super(Sha256Hash.ZERO_HASH.getBytes());
            this.num = 0L;
        }

        public BlockId(Sha256Hash blockId) {
            super(blockId.getBytes());
            byte[] blockNum = new byte[8];
            System.arraycopy(blockId.getBytes(), 0, blockNum, 0, 8);
            this.num = Longs.fromByteArray((byte[])blockNum);
        }

        public BlockId(Sha256Hash hash, long num) {
            super(num, hash);
            this.num = num;
        }

        public BlockId(byte[] hash, long num) {
            super(num, hash);
            this.num = num;
        }

        public BlockId(ByteString hash, long num) {
            super(num, hash.toByteArray());
            this.num = num;
        }

        public long getNum() {
            return this.num;
        }
    }
}

