/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class WitnessUpdateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(WitnessUpdateActuator.class);

    WitnessUpdateActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    private void updateWitness(Contract.WitnessUpdateContract contract) {
        WitnessCapsule witnessCapsule = this.dbManager.getWitnessStore().get(contract.getOwnerAddress().toByteArray());
        witnessCapsule.setUrl(contract.getUpdateUrl().toStringUtf8());
        this.dbManager.getWitnessStore().put(witnessCapsule.createDbKey(), witnessCapsule);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.WitnessUpdateContract witnessUpdateContract = (Contract.WitnessUpdateContract)this.contract.unpack(Contract.WitnessUpdateContract.class);
            this.updateWitness(witnessUpdateContract);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.WitnessUpdateContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.WitnessUpdateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [WitnessUpdateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.WitnessUpdateContract)this.contract.unpack(Contract.WitnessUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("account does not exist");
        }
        if (!TransactionUtil.validUrl(contract.getUpdateUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!this.dbManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Witness does not exist");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.WitnessUpdateContract)this.contract.unpack(Contract.WitnessUpdateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

