/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class WitnessCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(WitnessCreateActuator.class);

    WitnessCreateActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.WitnessCreateContract witnessCreateContract = (Contract.WitnessCreateContract)this.contract.unpack(Contract.WitnessCreateContract.class);
            this.createWitness(witnessCreateContract);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.WitnessCreateContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.WitnessCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [WitnessCreateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.WitnessCreateContract)this.contract.unpack(Contract.WitnessCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!TransactionUtil.validUrl(contract.getUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        if (this.dbManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] has existed");
        }
        if (accountCapsule.getBalance() < this.dbManager.getDynamicPropertiesStore().getAccountUpgradeCost()) {
            throw new ContractValidateException("balance < AccountUpgradeCost");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.WitnessCreateContract)this.contract.unpack(Contract.WitnessCreateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return this.dbManager.getDynamicPropertiesStore().getAccountUpgradeCost();
    }

    private void createWitness(Contract.WitnessCreateContract witnessCreateContract) throws BalanceInsufficientException {
        WitnessCapsule witnessCapsule = new WitnessCapsule(witnessCreateContract.getOwnerAddress(), 0L, witnessCreateContract.getUrl().toStringUtf8());
        logger.debug("createWitness,address[{}]", (Object)witnessCapsule.createReadableString());
        this.dbManager.getWitnessStore().put(witnessCapsule.createDbKey(), witnessCapsule);
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(witnessCapsule.createDbKey());
        accountCapsule.setIsWitness(true);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        long cost = this.dbManager.getDynamicPropertiesStore().getAccountUpgradeCost();
        this.dbManager.adjustBalance(witnessCreateContract.getOwnerAddress().toByteArray(), -cost);
        this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), cost);
        this.dbManager.getDynamicPropertiesStore().addTotalCreateWitnessCost(cost);
    }
}

