/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.db.AssetIssueStore;
import org.tron.core.db.AssetIssueV2Store;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class UpdateAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(UpdateAssetActuator.class);

    UpdateAssetActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.UpdateAssetContract updateAssetContract = (Contract.UpdateAssetContract)this.contract.unpack(Contract.UpdateAssetContract.class);
            long newLimit = updateAssetContract.getNewLimit();
            long newPublicLimit = updateAssetContract.getNewPublicLimit();
            byte[] ownerAddress = updateAssetContract.getOwnerAddress().toByteArray();
            ByteString newUrl = updateAssetContract.getUrl();
            ByteString newDescription = updateAssetContract.getDescription();
            AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
            AssetIssueV2Store assetIssueStoreV2 = this.dbManager.getAssetIssueV2Store();
            AssetIssueCapsule assetIssueCapsuleV2 = assetIssueStoreV2.get(accountCapsule.getAssetIssuedID().toByteArray());
            assetIssueCapsuleV2.setFreeAssetNetLimit(newLimit);
            assetIssueCapsuleV2.setPublicFreeAssetNetLimit(newPublicLimit);
            assetIssueCapsuleV2.setUrl(newUrl);
            assetIssueCapsuleV2.setDescription(newDescription);
            if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
                AssetIssueStore assetIssueStore = this.dbManager.getAssetIssueStore();
                AssetIssueCapsule assetIssueCapsule = assetIssueStore.get(accountCapsule.getAssetIssuedName().toByteArray());
                assetIssueCapsule.setFreeAssetNetLimit(newLimit);
                assetIssueCapsule.setPublicFreeAssetNetLimit(newPublicLimit);
                assetIssueCapsule.setUrl(newUrl);
                assetIssueCapsule.setDescription(newDescription);
                this.dbManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), assetIssueCapsule);
                this.dbManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
            } else {
                this.dbManager.getAssetIssueV2Store().put(assetIssueCapsuleV2.createDbV2Key(), assetIssueCapsuleV2);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.UpdateAssetContract updateAssetContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.UpdateAssetContract.class)) {
            throw new ContractValidateException("contract type error,expected type [UpdateAssetContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            updateAssetContract = (Contract.UpdateAssetContract)this.contract.unpack(Contract.UpdateAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        long newLimit = updateAssetContract.getNewLimit();
        long newPublicLimit = updateAssetContract.getNewPublicLimit();
        byte[] ownerAddress = updateAssetContract.getOwnerAddress().toByteArray();
        ByteString newUrl = updateAssetContract.getUrl();
        ByteString newDescription = updateAssetContract.getDescription();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = this.dbManager.getAccountStore().get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account has not existed");
        }
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            if (account.getAssetIssuedName().isEmpty()) {
                throw new ContractValidateException("Account has not issue any asset");
            }
            if (this.dbManager.getAssetIssueStore().get(account.getAssetIssuedName().toByteArray()) == null) {
                throw new ContractValidateException("Asset not exists in AssetIssueStore");
            }
        } else {
            if (account.getAssetIssuedID().isEmpty()) {
                throw new ContractValidateException("Account has not issue any asset");
            }
            if (this.dbManager.getAssetIssueV2Store().get(account.getAssetIssuedID().toByteArray()) == null) {
                throw new ContractValidateException("Asset not exists  in AssetIssueV2Store");
            }
        }
        if (!TransactionUtil.validUrl(newUrl.toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!TransactionUtil.validAssetDescription(newDescription.toByteArray())) {
            throw new ContractValidateException("Invalid description");
        }
        if (newLimit < 0L || newLimit >= this.dbManager.getDynamicPropertiesStore().getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid FreeAssetNetLimit");
        }
        if (newPublicLimit < 0L || newPublicLimit >= this.dbManager.getDynamicPropertiesStore().getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid PublicFreeAssetNetLimit");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.AccountUpdateContract)this.contract.unpack(Contract.AccountUpdateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

