/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class UnfreezeBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(UnfreezeBalanceActuator.class);

    UnfreezeBalanceActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.UnfreezeBalanceContract unfreezeBalanceContract;
        long fee = this.calcFee();
        try {
            unfreezeBalanceContract = (Contract.UnfreezeBalanceContract)this.contract.unpack(Contract.UnfreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeBalanceContract.getOwnerAddress().toByteArray();
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        long oldBalance = accountCapsule.getBalance();
        long unfreezeBalance = 0L;
        byte[] receiverAddress = unfreezeBalanceContract.getReceiverAddress().toByteArray();
        if (!ArrayUtils.isEmpty((byte[])receiverAddress) && this.dbManager.getDynamicPropertiesStore().supportDR()) {
            byte[] key = DelegatedResourceCapsule.createDbKey(unfreezeBalanceContract.getOwnerAddress().toByteArray(), unfreezeBalanceContract.getReceiverAddress().toByteArray());
            DelegatedResourceCapsule delegatedResourceCapsule = this.dbManager.getDelegatedResourceStore().get(key);
            AccountCapsule receiverCapsule = this.dbManager.getAccountStore().get(receiverAddress);
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForBandwidth();
                    delegatedResourceCapsule.setFrozenBalanceForBandwidth(0L, 0L);
                    receiverCapsule.addAcquiredDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                    accountCapsule.addDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                    break;
                }
                case ENERGY: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForEnergy();
                    delegatedResourceCapsule.setFrozenBalanceForEnergy(0L, 0L);
                    receiverCapsule.addAcquiredDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                    accountCapsule.addDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                    break;
                }
            }
            accountCapsule.setBalance(oldBalance + unfreezeBalance);
            this.dbManager.getAccountStore().put(receiverCapsule.createDbKey(), receiverCapsule);
            if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() == 0L && delegatedResourceCapsule.getFrozenBalanceForEnergy() == 0L) {
                this.dbManager.getDelegatedResourceStore().delete(key);
                DelegatedResourceAccountIndexCapsule delegatedResourceAccountIndexCapsule = this.dbManager.getDelegatedResourceAccountIndexStore().get(ownerAddress);
                if (delegatedResourceAccountIndexCapsule != null) {
                    ArrayList<ByteString> toAccountsList = new ArrayList<ByteString>(delegatedResourceAccountIndexCapsule.getToAccountsList());
                    toAccountsList.remove(ByteString.copyFrom((byte[])receiverAddress));
                    delegatedResourceAccountIndexCapsule.setAllToAccounts(toAccountsList);
                    this.dbManager.getDelegatedResourceAccountIndexStore().put(ownerAddress, delegatedResourceAccountIndexCapsule);
                }
                if ((delegatedResourceAccountIndexCapsule = this.dbManager.getDelegatedResourceAccountIndexStore().get(receiverAddress)) != null) {
                    ArrayList<ByteString> fromAccountsList = new ArrayList<ByteString>(delegatedResourceAccountIndexCapsule.getFromAccountsList());
                    fromAccountsList.remove(ByteString.copyFrom((byte[])ownerAddress));
                    delegatedResourceAccountIndexCapsule.setAllFromAccounts(fromAccountsList);
                    this.dbManager.getDelegatedResourceAccountIndexStore().put(receiverAddress, delegatedResourceAccountIndexCapsule);
                }
            } else {
                this.dbManager.getDelegatedResourceStore().put(key, delegatedResourceCapsule);
            }
        } else {
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    ArrayList frozenList = Lists.newArrayList();
                    frozenList.addAll(accountCapsule.getFrozenList());
                    Iterator iterator = frozenList.iterator();
                    long now = this.dbManager.getHeadBlockTimeStamp();
                    while (iterator.hasNext()) {
                        Protocol.Account.Frozen next = (Protocol.Account.Frozen)iterator.next();
                        if (next.getExpireTime() > now) continue;
                        unfreezeBalance += next.getFrozenBalance();
                        iterator.remove();
                    }
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).clearFrozen().addAllFrozen(frozenList).build());
                    break;
                }
                case ENERGY: {
                    unfreezeBalance = accountCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
                    Protocol.Account.AccountResource newAccountResource = accountCapsule.getAccountResource().toBuilder().clearFrozenBalanceForEnergy().build();
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).setAccountResource(newAccountResource).build());
                    break;
                }
            }
        }
        switch (unfreezeBalanceContract.getResource()) {
            case BANDWIDTH: {
                this.dbManager.getDynamicPropertiesStore().addTotalNetWeight(-unfreezeBalance / 1000000L);
                break;
            }
            case ENERGY: {
                this.dbManager.getDynamicPropertiesStore().addTotalEnergyWeight(-unfreezeBalance / 1000000L);
                break;
            }
        }
        VotesCapsule votesCapsule = !this.dbManager.getVotesStore().has(ownerAddress) ? new VotesCapsule(unfreezeBalanceContract.getOwnerAddress(), accountCapsule.getVotesList()) : this.dbManager.getVotesStore().get(ownerAddress);
        accountCapsule.clearVotes();
        votesCapsule.clearNewVotes();
        this.dbManager.getAccountStore().put(ownerAddress, accountCapsule);
        this.dbManager.getVotesStore().put(ownerAddress, votesCapsule);
        ret.setUnfreezeAmount(unfreezeBalance);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        block28: {
            long now;
            AccountCapsule accountCapsule;
            Contract.UnfreezeBalanceContract unfreezeBalanceContract;
            block27: {
                if (this.contract == null) {
                    throw new ContractValidateException("No contract!");
                }
                if (this.dbManager == null) {
                    throw new ContractValidateException("No dbManager!");
                }
                if (!this.contract.is(Contract.UnfreezeBalanceContract.class)) {
                    throw new ContractValidateException("contract type error,expected type [UnfreezeBalanceContract],real type[" + this.contract.getClass() + "]");
                }
                try {
                    unfreezeBalanceContract = (Contract.UnfreezeBalanceContract)this.contract.unpack(Contract.UnfreezeBalanceContract.class);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
                byte[] ownerAddress = unfreezeBalanceContract.getOwnerAddress().toByteArray();
                if (!Wallet.addressValid(ownerAddress)) {
                    throw new ContractValidateException("Invalid address");
                }
                accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
                if (accountCapsule == null) {
                    String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
                    throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
                }
                now = this.dbManager.getHeadBlockTimeStamp();
                byte[] receiverAddress = unfreezeBalanceContract.getReceiverAddress().toByteArray();
                if (ArrayUtils.isEmpty((byte[])receiverAddress) || !this.dbManager.getDynamicPropertiesStore().supportDR()) break block27;
                if (Arrays.equals(receiverAddress, ownerAddress)) {
                    throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
                }
                if (!Wallet.addressValid(receiverAddress)) {
                    throw new ContractValidateException("Invalid receiverAddress");
                }
                AccountCapsule receiverCapsule = this.dbManager.getAccountStore().get(receiverAddress);
                if (receiverCapsule == null) {
                    String readableOwnerAddress = StringUtil.createReadableString(receiverAddress);
                    throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
                }
                byte[] key = DelegatedResourceCapsule.createDbKey(unfreezeBalanceContract.getOwnerAddress().toByteArray(), unfreezeBalanceContract.getReceiverAddress().toByteArray());
                DelegatedResourceCapsule delegatedResourceCapsule = this.dbManager.getDelegatedResourceStore().get(key);
                if (delegatedResourceCapsule == null) {
                    throw new ContractValidateException("delegated Resource not exists");
                }
                switch (unfreezeBalanceContract.getResource()) {
                    case BANDWIDTH: {
                        if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() <= 0L) {
                            throw new ContractValidateException("no delegatedFrozenBalance(BANDWIDTH)");
                        }
                        if (receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() < delegatedResourceCapsule.getFrozenBalanceForBandwidth()) {
                            throw new ContractValidateException("AcquiredDelegatedFrozenBalanceForBandwidth[" + receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() + "] < delegatedBandwidth[" + delegatedResourceCapsule.getFrozenBalanceForBandwidth() + "],this should never happen");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForBandwidth() > now) {
                            throw new ContractValidateException("It's not time to unfreeze.");
                        }
                        break block28;
                    }
                    case ENERGY: {
                        if (delegatedResourceCapsule.getFrozenBalanceForEnergy() <= 0L) {
                            throw new ContractValidateException("no delegateFrozenBalance(Energy)");
                        }
                        if (receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() < delegatedResourceCapsule.getFrozenBalanceForEnergy()) {
                            throw new ContractValidateException("AcquiredDelegatedFrozenBalanceForEnergy[" + receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() + "] < delegatedEnergy[" + delegatedResourceCapsule.getFrozenBalanceForEnergy() + "],this should never happen");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForEnergy() > now) {
                            throw new ContractValidateException("It's not time to unfreeze.");
                        }
                        break block28;
                    }
                    default: {
                        throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]");
                    }
                }
            }
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    if (accountCapsule.getFrozenCount() <= 0) {
                        throw new ContractValidateException("no frozenBalance(BANDWIDTH)");
                    }
                    long allowedUnfreezeCount = accountCapsule.getFrozenList().stream().filter(frozen -> frozen.getExpireTime() <= now).count();
                    if (allowedUnfreezeCount > 0L) break;
                    throw new ContractValidateException("It's not time to unfreeze(BANDWIDTH).");
                }
                case ENERGY: {
                    Protocol.Account.Frozen frozenBalanceForEnergy = accountCapsule.getAccountResource().getFrozenBalanceForEnergy();
                    if (frozenBalanceForEnergy.getFrozenBalance() <= 0L) {
                        throw new ContractValidateException("no frozenBalance(Energy)");
                    }
                    if (frozenBalanceForEnergy.getExpireTime() <= now) break;
                    throw new ContractValidateException("It's not time to unfreeze(Energy).");
                }
                default: {
                    throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]");
                }
            }
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.UnfreezeBalanceContract)this.contract.unpack(Contract.UnfreezeBalanceContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

