/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.storage.Deposit;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.AccountStore;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class TransferAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(TransferAssetActuator.class);

    TransferAssetActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.TransferAssetContract transferAssetContract = (Contract.TransferAssetContract)this.contract.unpack(Contract.TransferAssetContract.class);
            AccountStore accountStore = this.dbManager.getAccountStore();
            byte[] ownerAddress = transferAssetContract.getOwnerAddress().toByteArray();
            byte[] toAddress = transferAssetContract.getToAddress().toByteArray();
            AccountCapsule toAccountCapsule = accountStore.get(toAddress);
            if (toAccountCapsule == null) {
                toAccountCapsule = new AccountCapsule(ByteString.copyFrom((byte[])toAddress), Protocol.AccountType.Normal, this.dbManager.getHeadBlockTimeStamp());
                this.dbManager.getAccountStore().put(toAddress, toAccountCapsule);
                fee += this.dbManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract();
            }
            ByteString assetName = transferAssetContract.getAssetName();
            long amount = transferAssetContract.getAmount();
            this.dbManager.adjustBalance(ownerAddress, -fee);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), fee);
            AccountCapsule ownerAccountCapsule = accountStore.get(ownerAddress);
            if (!ownerAccountCapsule.reduceAssetAmountV2(assetName.toByteArray(), amount, this.dbManager)) {
                throw new ContractExeException("reduceAssetAmount failed !");
            }
            accountStore.put(ownerAddress, ownerAccountCapsule);
            toAccountCapsule.addAssetAmountV2(assetName.toByteArray(), amount, this.dbManager);
            accountStore.put(toAddress, toAccountCapsule);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ArithmeticException e) {
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.TransferAssetContract transferAssetContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.TransferAssetContract.class)) {
            throw new ContractValidateException("contract type error,expected type [TransferAssetContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            transferAssetContract = (Contract.TransferAssetContract)this.contract.unpack(Contract.TransferAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        long fee = this.calcFee();
        byte[] ownerAddress = transferAssetContract.getOwnerAddress().toByteArray();
        byte[] toAddress = transferAssetContract.getToAddress().toByteArray();
        byte[] assetName = transferAssetContract.getAssetName().toByteArray();
        long amount = transferAssetContract.getAmount();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!Wallet.addressValid(toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0.");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot transfer asset to yourself.");
        }
        AccountCapsule ownerAccount = this.dbManager.getAccountStore().get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("No owner account!");
        }
        if (!this.dbManager.getAssetIssueStoreFinal().has(assetName)) {
            throw new ContractValidateException("No asset !");
        }
        Map<String, Long> asset = this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L ? ownerAccount.getAssetMap() : ownerAccount.getAssetMapV2();
        if (asset.isEmpty()) {
            throw new ContractValidateException("Owner no asset!");
        }
        Long assetBalance = asset.get(ByteArray.toStr(assetName));
        if (null == assetBalance || assetBalance <= 0L) {
            throw new ContractValidateException("assetBalance must greater than 0.");
        }
        if (amount > assetBalance) {
            throw new ContractValidateException("assetBalance is not sufficient.");
        }
        AccountCapsule toAccount = this.dbManager.getAccountStore().get(toAddress);
        if (toAccount != null) {
            assetBalance = this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L ? toAccount.getAssetMap().get(ByteArray.toStr(assetName)) : toAccount.getAssetMapV2().get(ByteArray.toStr(assetName));
            if (assetBalance != null) {
                try {
                    assetBalance = Math.addExact(assetBalance, amount);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
            }
        } else if (ownerAccount.getBalance() < (fee += this.dbManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract())) {
            throw new ContractValidateException("Validate TransferAssetActuator error, insufficient fee.");
        }
        return true;
    }

    public static boolean validateForSmartContract(Deposit deposit, byte[] ownerAddress, byte[] toAddress, byte[] tokenId, long amount) throws ContractValidateException {
        if (deposit == null) {
            throw new ContractValidateException("No deposit!");
        }
        long fee = 0L;
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes(tokenId);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!Wallet.addressValid(toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0.");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot transfer asset to yourself.");
        }
        AccountCapsule ownerAccount = deposit.getAccount(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("No owner account!");
        }
        if (deposit.getAssetIssue(tokenIdWithoutLeadingZero) == null) {
            throw new ContractValidateException("No asset !");
        }
        if (!deposit.getDbManager().getAssetIssueStoreFinal().has(tokenIdWithoutLeadingZero)) {
            throw new ContractValidateException("No asset !");
        }
        Map<String, Long> asset = deposit.getDbManager().getDynamicPropertiesStore().getAllowSameTokenName() == 0L ? ownerAccount.getAssetMap() : ownerAccount.getAssetMapV2();
        if (asset.isEmpty()) {
            throw new ContractValidateException("Owner no asset!");
        }
        Long assetBalance = asset.get(ByteArray.toStr(tokenIdWithoutLeadingZero));
        if (null == assetBalance || assetBalance <= 0L) {
            throw new ContractValidateException("assetBalance must greater than 0.");
        }
        if (amount > assetBalance) {
            throw new ContractValidateException("assetBalance is not sufficient.");
        }
        AccountCapsule toAccount = deposit.getAccount(toAddress);
        if (toAccount != null) {
            assetBalance = deposit.getDbManager().getDynamicPropertiesStore().getAllowSameTokenName() == 0L ? toAccount.getAssetMap().get(ByteArray.toStr(tokenIdWithoutLeadingZero)) : toAccount.getAssetMapV2().get(ByteArray.toStr(tokenIdWithoutLeadingZero));
            if (assetBalance != null) {
                try {
                    assetBalance = Math.addExact(assetBalance, amount);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
            }
        } else {
            throw new ContractValidateException("Validate InternalTransfer error, no ToAccount. And not allowed to create account in smart contract.");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.TransferAssetContract)this.contract.unpack(Contract.TransferAssetContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

