/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.storage.Deposit;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class TransferActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(TransferActuator.class);

    TransferActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.TransferContract transferContract = (Contract.TransferContract)this.contract.unpack(Contract.TransferContract.class);
            long amount = transferContract.getAmount();
            byte[] toAddress = transferContract.getToAddress().toByteArray();
            byte[] ownerAddress = transferContract.getOwnerAddress().toByteArray();
            AccountCapsule toAccount = this.dbManager.getAccountStore().get(toAddress);
            if (toAccount == null) {
                toAccount = new AccountCapsule(ByteString.copyFrom((byte[])toAddress), Protocol.AccountType.Normal, this.dbManager.getHeadBlockTimeStamp());
                this.dbManager.getAccountStore().put(toAddress, toAccount);
                fee += this.dbManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract();
            }
            this.dbManager.adjustBalance(ownerAddress, -fee);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), fee);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
            this.dbManager.adjustBalance(ownerAddress, -amount);
            this.dbManager.adjustBalance(toAddress, amount);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.TransferContract transferContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.TransferContract.class)) {
            throw new ContractValidateException("contract type error,expected type [TransferContract],real type[" + this.contract.getClass() + "]");
        }
        long fee = this.calcFee();
        try {
            transferContract = (Contract.TransferContract)this.contract.unpack(Contract.TransferContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] toAddress = transferContract.getToAddress().toByteArray();
        byte[] ownerAddress = transferContract.getOwnerAddress().toByteArray();
        long amount = transferContract.getAmount();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!Wallet.addressValid(toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (Arrays.equals(toAddress, ownerAddress)) {
            throw new ContractValidateException("Cannot transfer trx to yourself.");
        }
        AccountCapsule ownerAccount = this.dbManager.getAccountStore().get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Validate TransferContract error, no OwnerAccount.");
        }
        long balance = ownerAccount.getBalance();
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0.");
        }
        try {
            AccountCapsule toAccount = this.dbManager.getAccountStore().get(toAddress);
            if (toAccount == null) {
                fee += this.dbManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract();
            }
            if (balance < Math.addExact(amount, fee)) {
                throw new ContractValidateException("Validate TransferContract error, balance is not sufficient.");
            }
            if (toAccount != null) {
                long l = Math.addExact(toAccount.getBalance(), amount);
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public static boolean validateForSmartContract(Deposit deposit, byte[] ownerAddress, byte[] toAddress, long amount) throws ContractValidateException {
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!Wallet.addressValid(toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (Arrays.equals(toAddress, ownerAddress)) {
            throw new ContractValidateException("Cannot transfer trx to yourself.");
        }
        AccountCapsule ownerAccount = deposit.getAccount(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Validate InternalTransfer error, no OwnerAccount.");
        }
        AccountCapsule toAccount = deposit.getAccount(toAddress);
        if (toAccount == null) {
            throw new ContractValidateException("Validate InternalTransfer error, no ToAccount. And not allowed to create account in smart contract.");
        }
        long balance = ownerAccount.getBalance();
        if (amount < 0L) {
            throw new ContractValidateException("Amount must greater than or equals 0.");
        }
        try {
            if (balance < amount) {
                throw new ContractValidateException("Validate InternalTransfer error, balance is not sufficient.");
            }
            if (toAccount != null) {
                long l = Math.addExact(toAccount.getBalance(), amount);
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.TransferContract)this.contract.unpack(Contract.TransferContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

