/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ProposalCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ProposalCreateActuator.class);

    ProposalCreateActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ProposalCreateContract proposalCreateContract = (Contract.ProposalCreateContract)this.contract.unpack(Contract.ProposalCreateContract.class);
            long id = Objects.isNull(this.getDeposit()) ? this.dbManager.getDynamicPropertiesStore().getLatestProposalNum() + 1L : this.getDeposit().getLatestProposalNum() + 1L;
            ProposalCapsule proposalCapsule = new ProposalCapsule(proposalCreateContract.getOwnerAddress(), id);
            proposalCapsule.setParameters(proposalCreateContract.getParametersMap());
            long now = this.dbManager.getHeadBlockTimeStamp();
            long maintenanceTimeInterval = Objects.isNull(this.getDeposit()) ? this.dbManager.getDynamicPropertiesStore().getMaintenanceTimeInterval() : this.getDeposit().getMaintenanceTimeInterval();
            proposalCapsule.setCreateTime(now);
            long currentMaintenanceTime = Objects.isNull(this.getDeposit()) ? this.dbManager.getDynamicPropertiesStore().getNextMaintenanceTime() : this.getDeposit().getNextMaintenanceTime();
            long now3 = now + Args.getInstance().getProposalExpireTime();
            long round = (now3 - currentMaintenanceTime) / maintenanceTimeInterval;
            long expirationTime = currentMaintenanceTime + (round + 1L) * maintenanceTimeInterval;
            proposalCapsule.setExpirationTime(expirationTime);
            if (Objects.isNull(this.deposit)) {
                this.dbManager.getProposalStore().put(proposalCapsule.createDbKey(), proposalCapsule);
                this.dbManager.getDynamicPropertiesStore().saveLatestProposalNum(id);
            } else {
                this.deposit.putProposalValue(proposalCapsule.createDbKey(), proposalCapsule);
                this.deposit.putDynamicPropertiesWithLatestProposalNum(id);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.ProposalCreateContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null && (this.deposit == null || this.deposit.getDbManager() == null)) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ProposalCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalCreateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ProposalCreateContract)this.contract.unpack(Contract.ProposalCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!Objects.isNull(this.deposit) ? Objects.isNull(this.deposit.getAccount(ownerAddress)) : !this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (!Objects.isNull(this.getDeposit()) ? Objects.isNull(this.getDeposit().getWitness(ownerAddress)) : !this.dbManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] not exists");
        }
        if (contract.getParametersMap().size() == 0) {
            throw new ContractValidateException("This proposal has no parameter.");
        }
        for (Map.Entry<Long, Long> entry : contract.getParametersMap().entrySet()) {
            if (!this.validKey(entry.getKey())) {
                throw new ContractValidateException("Bad chain parameter id");
            }
            this.validateValue(entry);
        }
        return true;
    }

    private void validateValue(Map.Entry<Long, Long> entry) throws ContractValidateException {
        switch (entry.getKey().intValue()) {
            case 0: {
                if (entry.getValue() < 81000L || entry.getValue() > 86400000L) {
                    throw new ContractValidateException("Bad chain parameter value,valid range is [3 * 27 * 1000,24 * 3600 * 1000]");
                }
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (entry.getValue() >= 0L && entry.getValue() <= 100000000000000000L) break;
                throw new ContractValidateException("Bad chain parameter value,valid range is [0,100_000_000_000_000_000L]");
            }
            case 9: {
                if (entry.getValue() == 1L) break;
                throw new ContractValidateException("This value[ALLOW_CREATION_OF_CONTRACTS] is only allowed to be 1");
            }
            case 10: {
                if (this.dbManager.getDynamicPropertiesStore().getRemoveThePowerOfTheGr() == -1L) {
                    throw new ContractValidateException("This proposal has been executed before and is only allowed to be executed once");
                }
                if (entry.getValue() == 1L) break;
                throw new ContractValidateException("This value[REMOVE_THE_POWER_OF_THE_GR] is only allowed to be 1");
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                if (entry.getValue() >= 10L && entry.getValue() <= 100L) break;
                throw new ContractValidateException("Bad chain parameter value,valid range is [10,100]");
            }
            case 14: {
                if (entry.getValue() == 1L) break;
                throw new ContractValidateException("This value[ALLOW_UPDATE_ACCOUNT_NAME] is only allowed to be 1");
            }
            case 15: {
                if (entry.getValue() == 1L) break;
                throw new ContractValidateException("This value[ALLOW_SAME_TOKEN_NAME] is only allowed to be 1");
            }
            case 16: {
                if (!this.dbManager.getForkController().pass(5)) {
                    throw new ContractValidateException("Bad chain parameter id");
                }
                if (entry.getValue() == 1L) break;
                throw new ContractValidateException("This value[ALLOW_DELEGATE_RESOURCE] is only allowed to be 1");
            }
            case 17: {
                if (!this.dbManager.getForkController().pass(5)) {
                    throw new ContractValidateException("Bad chain parameter id");
                }
                if (entry.getValue() >= 0L && entry.getValue() <= 100000000000000000L) break;
                throw new ContractValidateException("Bad chain parameter value,valid range is [0,100_000_000_000_000_000L]");
            }
            case 18: {
                if (!this.dbManager.getForkController().pass(5)) {
                    throw new ContractValidateException("Bad chain parameter id");
                }
                if (entry.getValue() != 1L) {
                    throw new ContractValidateException("This value[ALLOW_TVM_TRANSFER_TRC10] is only allowed to be 1");
                }
                if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() != 0L) break;
                throw new ContractValidateException("[ALLOW_SAME_TOKEN_NAME] proposal must be approved before [ALLOW_TVM_TRANSFER_TRC10] can be proposed");
            }
        }
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ProposalCreateContract)this.contract.unpack(Contract.ProposalCreateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }

    private boolean validKey(long idx) {
        return idx >= 0L && idx < (long)Parameter.ChainParameters.values().length;
    }
}

