/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class ProposalApproveActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(ProposalApproveActuator.class);

    ProposalApproveActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.ProposalApproveContract proposalApproveContract = (Contract.ProposalApproveContract)this.contract.unpack(Contract.ProposalApproveContract.class);
            ProposalCapsule proposalCapsule = Objects.isNull(this.getDeposit()) ? this.dbManager.getProposalStore().get(ByteArray.fromLong(proposalApproveContract.getProposalId())) : this.getDeposit().getProposalCapsule(ByteArray.fromLong(proposalApproveContract.getProposalId()));
            ByteString committeeAddress = proposalApproveContract.getOwnerAddress();
            if (proposalApproveContract.getIsAddApproval()) {
                proposalCapsule.addApproval(committeeAddress);
            } else {
                proposalCapsule.removeApproval(committeeAddress);
            }
            if (Objects.isNull(this.deposit)) {
                this.dbManager.getProposalStore().put(proposalCapsule.createDbKey(), proposalCapsule);
            } else {
                this.deposit.putProposalValue(proposalCapsule.createDbKey(), proposalCapsule);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        ProposalCapsule proposalCapsule;
        long latestProposalNum;
        Contract.ProposalApproveContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null && (this.getDeposit() == null || this.getDeposit().getDbManager() == null)) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.ProposalApproveContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalApproveContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.ProposalApproveContract)this.contract.unpack(Contract.ProposalApproveContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!Objects.isNull(this.getDeposit()) ? Objects.isNull(this.getDeposit().getAccount(ownerAddress)) : !this.dbManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (!Objects.isNull(this.getDeposit()) ? Objects.isNull(this.getDeposit().getWitness(ownerAddress)) : !this.dbManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] not exists");
        }
        long l = latestProposalNum = Objects.isNull(this.getDeposit()) ? this.dbManager.getDynamicPropertiesStore().getLatestProposalNum() : this.getDeposit().getLatestProposalNum();
        if (contract.getProposalId() > latestProposalNum) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        long now = this.dbManager.getHeadBlockTimeStamp();
        try {
            proposalCapsule = Objects.isNull(this.getDeposit()) ? this.dbManager.getProposalStore().get(ByteArray.fromLong(contract.getProposalId())) : this.getDeposit().getProposalCapsule(ByteArray.fromLong(contract.getProposalId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        if (now >= proposalCapsule.getExpirationTime()) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] expired");
        }
        if (proposalCapsule.getState() == Protocol.Proposal.State.CANCELED) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] canceled");
        }
        if (!contract.getIsAddApproval()) {
            if (!proposalCapsule.getApprovals().contains(contract.getOwnerAddress())) {
                throw new ContractValidateException("Witness[" + readableOwnerAddress + "]has not approved proposal[" + contract.getProposalId() + "] before");
            }
        } else if (proposalCapsule.getApprovals().contains(contract.getOwnerAddress())) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "]has approved proposal[" + contract.getProposalId() + "] before");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.ProposalApproveContract)this.contract.unpack(Contract.ProposalApproveContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

