/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class CreateAccountActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(CreateAccountActuator.class);

    CreateAccountActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        long fee = this.calcFee();
        try {
            Contract.AccountCreateContract accountCreateContract = (Contract.AccountCreateContract)this.contract.unpack(Contract.AccountCreateContract.class);
            AccountCapsule accountCapsule = new AccountCapsule(accountCreateContract, this.dbManager.getHeadBlockTimeStamp());
            this.dbManager.getAccountStore().put(accountCreateContract.getAccountAddress().toByteArray(), accountCapsule);
            this.dbManager.adjustBalance(accountCreateContract.getOwnerAddress().toByteArray(), -fee);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), fee);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.AccountCreateContract contract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.AccountCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AccountCreateContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            contract = (Contract.AccountCreateContract)this.contract.unpack(Contract.AccountCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long fee = this.calcFee();
        if (accountCapsule.getBalance() < fee) {
            throw new ContractValidateException("Validate CreateAccountActuator error, insufficient fee.");
        }
        byte[] accountAddress = contract.getAccountAddress().toByteArray();
        if (!Wallet.addressValid(accountAddress)) {
            throw new ContractValidateException("Invalid account address");
        }
        if (this.dbManager.getAccountStore().has(accountAddress)) {
            throw new ContractValidateException("Account has existed");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.AccountCreateContract)this.contract.unpack(Contract.AccountCreateContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return this.dbManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract();
    }
}

