/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.Wallet;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.StorageMarket;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class BuyStorageActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger(BuyStorageActuator.class);
    private StorageMarket storageMarket;

    BuyStorageActuator(Any contract, Manager dbManager) {
        super(contract, dbManager);
        this.storageMarket = new StorageMarket(dbManager);
    }

    @Override
    public boolean execute(TransactionResultCapsule ret) throws ContractExeException {
        Contract.BuyStorageContract buyStorageContract;
        long fee = this.calcFee();
        try {
            buyStorageContract = (Contract.BuyStorageContract)this.contract.unpack(Contract.BuyStorageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(buyStorageContract.getOwnerAddress().toByteArray());
        long quant = buyStorageContract.getQuant();
        this.storageMarket.buyStorage(accountCapsule, quant);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    @Override
    public boolean validate() throws ContractValidateException {
        Contract.BuyStorageContract buyStorageContract;
        if (this.contract == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.dbManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.contract.is(Contract.BuyStorageContract.class)) {
            throw new ContractValidateException("contract type error,expected type [BuyStorageContract],real type[" + this.contract.getClass() + "]");
        }
        try {
            buyStorageContract = (Contract.BuyStorageContract)this.contract.unpack(Contract.BuyStorageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = buyStorageContract.getOwnerAddress().toByteArray();
        if (!Wallet.addressValid(ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString(ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long quant = buyStorageContract.getQuant();
        if (quant <= 0L) {
            throw new ContractValidateException("quantity must be positive");
        }
        if (quant < 1000000L) {
            throw new ContractValidateException("quantity must be larger than 1TRX");
        }
        if (quant > accountCapsule.getBalance()) {
            throw new ContractValidateException("quantity must be less than accountBalance");
        }
        long storage_bytes = this.storageMarket.tryBuyStorage(quant);
        if (storage_bytes < 1L) {
            throw new ContractValidateException("storage_bytes must be larger than 1,current storage_bytes[" + storage_bytes + "]");
        }
        return true;
    }

    @Override
    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((Contract.BuyStorageContract)this.contract.unpack(Contract.BuyStorageContract.class)).getOwnerAddress();
    }

    @Override
    public long calcFee() {
        return 0L;
    }
}

