/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.Hash;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeHandler;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.runtime.RuntimeImpl;
import org.tron.common.runtime.config.VMConfig;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactoryImpl;
import org.tron.common.storage.DepositImpl;
import org.tron.common.utils.Base58;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Utils;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.ActuatorFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.TransactionInfoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.Parameter;
import org.tron.core.config.args.Args;
import org.tron.core.db.AccountIdIndexStore;
import org.tron.core.db.AccountStore;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.ContractStore;
import org.tron.core.db.DynamicPropertiesStore;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.Manager;
import org.tron.core.db.PendingManager;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.NonUniqueObjectException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.net.message.TransactionMessage;
import org.tron.core.net.node.NodeImpl;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component
public class Wallet {
    private static final Logger logger = LoggerFactory.getLogger(Wallet.class);
    private final ECKey ecKey;
    @Autowired
    private NodeImpl p2pNode;
    @Autowired
    private Manager dbManager;
    @Autowired
    private NodeManager nodeManager;
    private static String addressPreFixString = "a0";
    private static byte addressPreFixByte = (byte)-96;

    public Wallet() {
        this.ecKey = new ECKey(Utils.getRandom());
    }

    public Wallet(ECKey ecKey) {
        this.ecKey = ecKey;
        logger.info("wallet address: {}", (Object)ByteArray.toHexString(this.ecKey.getAddress()));
    }

    public static boolean isConstant(Protocol.SmartContract.ABI abi, Contract.TriggerSmartContract triggerSmartContract) throws ContractValidateException {
        try {
            boolean constant = Wallet.isConstant(abi, Wallet.getSelector(triggerSmartContract.getData().toByteArray()));
            if (constant && !Args.getInstance().isSupportConstant()) {
                throw new ContractValidateException("this node don't support constant");
            }
            return constant;
        }
        catch (ContractValidateException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] getAddress() {
        return this.ecKey.getAddress();
    }

    public static String getAddressPreFixString() {
        return addressPreFixString;
    }

    public static void setAddressPreFixString(String addressPreFixString) {
        Wallet.addressPreFixString = addressPreFixString;
    }

    public static byte getAddressPreFixByte() {
        return addressPreFixByte;
    }

    public static void setAddressPreFixByte(byte addressPreFixByte) {
        Wallet.addressPreFixByte = addressPreFixByte;
    }

    public static boolean addressValid(byte[] address) {
        if (ArrayUtils.isEmpty((byte[])address)) {
            logger.warn("Warning: Address is empty !!");
            return false;
        }
        if (address.length != 21) {
            logger.warn("Warning: Address length need 42 but " + address.length + " !!");
            return false;
        }
        if (address[0] != addressPreFixByte) {
            logger.warn("Warning: Address need prefix with " + addressPreFixByte + " but " + address[0] + " !!");
            return false;
        }
        return true;
    }

    public static String encode58Check(byte[] input) {
        byte[] hash0 = Sha256Hash.hash(input);
        byte[] hash1 = Sha256Hash.hash(hash0);
        byte[] inputCheck = new byte[input.length + 4];
        System.arraycopy(input, 0, inputCheck, 0, input.length);
        System.arraycopy(hash1, 0, inputCheck, input.length, 4);
        return Base58.encode(inputCheck);
    }

    private static byte[] decode58Check(String input) {
        byte[] decodeCheck = Base58.decode(input);
        if (decodeCheck.length <= 4) {
            return null;
        }
        byte[] decodeData = new byte[decodeCheck.length - 4];
        System.arraycopy(decodeCheck, 0, decodeData, 0, decodeData.length);
        byte[] hash0 = Sha256Hash.hash(decodeData);
        byte[] hash1 = Sha256Hash.hash(hash0);
        if (hash1[0] == decodeCheck[decodeData.length] && hash1[1] == decodeCheck[decodeData.length + 1] && hash1[2] == decodeCheck[decodeData.length + 2] && hash1[3] == decodeCheck[decodeData.length + 3]) {
            return decodeData;
        }
        return null;
    }

    public static byte[] generateContractAddress(Protocol.Transaction trx) {
        Contract.CreateSmartContract contract = ContractCapsule.getSmartContractFromTransaction(trx);
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        TransactionCapsule trxCap = new TransactionCapsule(trx);
        byte[] txRawDataHash = trxCap.getTransactionId().getBytes();
        byte[] combined = new byte[txRawDataHash.length + ownerAddress.length];
        System.arraycopy(txRawDataHash, 0, combined, 0, txRawDataHash.length);
        System.arraycopy(ownerAddress, 0, combined, txRawDataHash.length, ownerAddress.length);
        return Hash.sha3omit12(combined);
    }

    public static byte[] generateContractAddress(byte[] ownerAddress, byte[] txRawDataHash) {
        byte[] combined = new byte[txRawDataHash.length + ownerAddress.length];
        System.arraycopy(txRawDataHash, 0, combined, 0, txRawDataHash.length);
        System.arraycopy(ownerAddress, 0, combined, txRawDataHash.length, ownerAddress.length);
        return Hash.sha3omit12(combined);
    }

    public static byte[] generateContractAddress(byte[] transactionRootId, long nonce) {
        byte[] nonceBytes = Longs.toByteArray((long)nonce);
        byte[] combined = new byte[transactionRootId.length + nonceBytes.length];
        System.arraycopy(transactionRootId, 0, combined, 0, transactionRootId.length);
        System.arraycopy(nonceBytes, 0, combined, transactionRootId.length, nonceBytes.length);
        return Hash.sha3omit12(combined);
    }

    public static byte[] decodeFromBase58Check(String addressBase58) {
        if (StringUtils.isEmpty((CharSequence)addressBase58)) {
            logger.warn("Warning: Address is empty !!");
            return null;
        }
        byte[] address = Wallet.decode58Check(addressBase58);
        if (address == null) {
            return null;
        }
        if (!Wallet.addressValid(address)) {
            return null;
        }
        return address;
    }

    public Protocol.Account getAccount(Protocol.Account account) {
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountCapsule accountCapsule = accountStore.get(account.getAddress().toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.dbManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.dbManager);
        energyProcessor.updateUsage(accountCapsule);
        long genesisTimeStamp = this.dbManager.getGenesisBlock().getTimeStamp();
        accountCapsule.setLatestConsumeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTime());
        accountCapsule.setLatestConsumeFreeTime(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeFreeTime());
        accountCapsule.setLatestConsumeTimeForEnergy(genesisTimeStamp + 3000L * accountCapsule.getLatestConsumeTimeForEnergy());
        return accountCapsule.getInstance();
    }

    public Protocol.Account getAccountById(Protocol.Account account) {
        AccountStore accountStore = this.dbManager.getAccountStore();
        AccountIdIndexStore accountIdIndexStore = this.dbManager.getAccountIdIndexStore();
        byte[] address = accountIdIndexStore.get(account.getAccountId());
        if (address == null) {
            return null;
        }
        AccountCapsule accountCapsule = accountStore.get(address);
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.dbManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.dbManager);
        energyProcessor.updateUsage(accountCapsule);
        return accountCapsule.getInstance();
    }

    @Deprecated
    public Protocol.Transaction createTransaction(Contract.TransferContract contract) {
        AccountStore accountStore = this.dbManager.getAccountStore();
        return new TransactionCapsule(contract, accountStore).getInstance();
    }

    public TransactionCapsule createTransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) throws ContractValidateException {
        Contract.CreateSmartContract contract;
        long percent;
        TransactionCapsule trx = new TransactionCapsule(message, contractType);
        if (contractType != Protocol.Transaction.Contract.ContractType.CreateSmartContract && contractType != Protocol.Transaction.Contract.ContractType.TriggerSmartContract) {
            List<Actuator> actList = ActuatorFactory.createActuator(trx, this.dbManager);
            for (Actuator act : actList) {
                act.validate();
            }
        }
        if (contractType == Protocol.Transaction.Contract.ContractType.CreateSmartContract && ((percent = (contract = ContractCapsule.getSmartContractFromTransaction(trx.getInstance())).getNewContract().getConsumeUserResourcePercent()) < 0L || percent > 100L)) {
            throw new ContractValidateException("percent must be >= 0 and <= 100");
        }
        try {
            BlockCapsule.BlockId blockId = this.dbManager.getHeadBlockId();
            if (Args.getInstance().getTrxReferenceBlock().equals("solid")) {
                blockId = this.dbManager.getSolidBlockId();
            }
            trx.setReference(blockId.getNum(), blockId.getBytes());
            long expiration = this.dbManager.getHeadBlockTimeStamp() + 60000L;
            trx.setExpiration(expiration);
            trx.setTimestamp();
        }
        catch (Exception e) {
            logger.error("Create transaction capsule failed.", (Throwable)e);
        }
        return trx;
    }

    public GrpcAPI.Return broadcastTransaction(Protocol.Transaction signaturedTransaction) {
        GrpcAPI.Return.Builder builder = GrpcAPI.Return.newBuilder();
        try {
            if (this.p2pNode.getActivePeer().isEmpty()) {
                logger.info("Broadcast transaction failed, no connection.");
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)"no connection")).build();
            }
            if (!this.p2pNode.getActivePeer().stream().filter(p -> !p.isNeedSyncFromUs() && !p.isNeedSyncFromPeer()).findFirst().isPresent()) {
                logger.info("Broadcast transaction failed, no effective connection.");
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)"no effective connection")).build();
            }
            TransactionCapsule trx = new TransactionCapsule(signaturedTransaction);
            TransactionMessage message = new TransactionMessage(signaturedTransaction);
            if (this.dbManager.isTooManyPending()) {
                logger.debug("Manager is busy, pending transaction count:{}, discard the new coming transaction", (Object)(this.dbManager.getPendingTransactions().size() + PendingManager.getTmpTransactions().size()));
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.SERVER_BUSY).build();
            }
            if (this.dbManager.isGeneratingBlock()) {
                logger.debug("Manager is generating block, discard the new coming transaction");
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.SERVER_BUSY).build();
            }
            if (this.dbManager.getTransactionIdCache().getIfPresent((Object)trx.getTransactionId()) != null) {
                logger.debug("This transaction has been processed, discard the transaction");
                return builder.setResult(false).setCode(GrpcAPI.Return.response_code.DUP_TRANSACTION_ERROR).build();
            }
            this.dbManager.getTransactionIdCache().put((Object)trx.getTransactionId(), (Object)true);
            if (this.dbManager.getDynamicPropertiesStore().supportVM()) {
                trx.resetResult();
            }
            this.dbManager.pushTransaction(trx);
            this.p2pNode.broadcast(message);
            return builder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS).build();
        }
        catch (ValidateSignatureException e) {
            logger.info(e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.SIGERROR).setMessage(ByteString.copyFromUtf8((String)"validate signature error")).build();
        }
        catch (ContractValidateException e) {
            logger.info(e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("contract validate error : " + e.getMessage()))).build();
        }
        catch (ContractExeException e) {
            logger.info(e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)("contract execute error : " + e.getMessage()))).build();
        }
        catch (AccountResourceInsufficientException e) {
            logger.info(e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.BANDWITH_ERROR).setMessage(ByteString.copyFromUtf8((String)"AccountResourceInsufficient error")).build();
        }
        catch (DupTransactionException e) {
            logger.info("dup trans" + e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.DUP_TRANSACTION_ERROR).setMessage(ByteString.copyFromUtf8((String)"dup transaction")).build();
        }
        catch (TaposException e) {
            logger.info("tapos error" + e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TAPOS_ERROR).setMessage(ByteString.copyFromUtf8((String)"Tapos check error")).build();
        }
        catch (TooBigTransactionException e) {
            logger.info("transaction error" + e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TOO_BIG_TRANSACTION_ERROR).setMessage(ByteString.copyFromUtf8((String)"transaction size is too big")).build();
        }
        catch (TransactionExpirationException e) {
            logger.info("transaction expired" + e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.TRANSACTION_EXPIRATION_ERROR).setMessage(ByteString.copyFromUtf8((String)"transaction expired")).build();
        }
        catch (Exception e) {
            logger.info("exception caught" + e.getMessage());
            return builder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)("other error : " + e.getMessage()))).build();
        }
    }

    public TransactionCapsule getTransactionSign(Protocol.TransactionSign transactionSign) {
        byte[] privateKey = transactionSign.getPrivateKey().toByteArray();
        TransactionCapsule trx = new TransactionCapsule(transactionSign.getTransaction());
        trx.sign(privateKey);
        return trx;
    }

    public byte[] pass2Key(byte[] passPhrase) {
        return Sha256Hash.hash(passPhrase);
    }

    public byte[] createAdresss(byte[] passPhrase) {
        byte[] privateKey = this.pass2Key(passPhrase);
        ECKey ecKey = ECKey.fromPrivate(privateKey);
        return ecKey.getAddress();
    }

    public Protocol.Block getNowBlock() {
        List<BlockCapsule> blockList = this.dbManager.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isEmpty(blockList)) {
            return null;
        }
        return blockList.get(0).getInstance();
    }

    public Protocol.Block getBlockByNum(long blockNum) {
        try {
            return this.dbManager.getBlockByNum(blockNum).getInstance();
        }
        catch (StoreException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public long getTransactionCountByBlockNum(long blockNum) {
        long count = 0L;
        try {
            Protocol.Block block = this.dbManager.getBlockByNum(blockNum).getInstance();
            count = block.getTransactionsCount();
        }
        catch (StoreException e) {
            logger.error(e.getMessage());
        }
        return count;
    }

    public GrpcAPI.WitnessList getWitnessList() {
        GrpcAPI.WitnessList.Builder builder = GrpcAPI.WitnessList.newBuilder();
        List<WitnessCapsule> witnessCapsuleList = this.dbManager.getWitnessStore().getAllWitnesses();
        witnessCapsuleList.forEach(witnessCapsule -> builder.addWitnesses(witnessCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.ProposalList getProposalList() {
        GrpcAPI.ProposalList.Builder builder = GrpcAPI.ProposalList.newBuilder();
        List<ProposalCapsule> proposalCapsuleList = this.dbManager.getProposalStore().getAllProposals();
        proposalCapsuleList.forEach(proposalCapsule -> builder.addProposals(proposalCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.DelegatedResourceList getDelegatedResource(ByteString fromAddress, ByteString toAddress) {
        GrpcAPI.DelegatedResourceList.Builder builder = GrpcAPI.DelegatedResourceList.newBuilder();
        byte[] dbKey = DelegatedResourceCapsule.createDbKey(fromAddress.toByteArray(), toAddress.toByteArray());
        DelegatedResourceCapsule delegatedResourceCapsule = this.dbManager.getDelegatedResourceStore().get(dbKey);
        if (delegatedResourceCapsule != null) {
            builder.addDelegatedResource(delegatedResourceCapsule.getInstance());
        }
        return builder.build();
    }

    public Protocol.DelegatedResourceAccountIndex getDelegatedResourceAccountIndex(ByteString address) {
        DelegatedResourceAccountIndexCapsule accountIndexCapsule = this.dbManager.getDelegatedResourceAccountIndexStore().get(address.toByteArray());
        if (accountIndexCapsule != null) {
            return accountIndexCapsule.getInstance();
        }
        return null;
    }

    public GrpcAPI.ExchangeList getExchangeList() {
        GrpcAPI.ExchangeList.Builder builder = GrpcAPI.ExchangeList.newBuilder();
        List<ExchangeCapsule> exchangeCapsuleList = this.dbManager.getExchangeStoreFinal().getAllExchanges();
        exchangeCapsuleList.forEach(exchangeCapsule -> builder.addExchanges(exchangeCapsule.getInstance()));
        return builder.build();
    }

    public Protocol.ChainParameters getChainParameters() {
        Protocol.ChainParameters.Builder builder = Protocol.ChainParameters.newBuilder();
        Arrays.stream(Parameter.ChainParameters.values()).forEach(parameters -> {
            try {
                String methodName = Wallet.makeUpperCamelMethod(parameters.name());
                builder.addChainParameter(Protocol.ChainParameters.ChainParameter.newBuilder().setKey(methodName).setValue((Long)DynamicPropertiesStore.class.getDeclaredMethod(methodName, new Class[0]).invoke((Object)this.dbManager.getDynamicPropertiesStore(), new Object[0])).build());
            }
            catch (Exception ex) {
                logger.error("get chainParameter error,", (Throwable)ex);
            }
        });
        return builder.build();
    }

    public static String makeUpperCamelMethod(String originName) {
        return "get" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, originName).replace("_", "");
    }

    public GrpcAPI.AssetIssueList getAssetIssueList() {
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        this.dbManager.getAssetIssueStoreFinal().getAllAssetIssues().forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueList(long offset, long limit) {
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        List<AssetIssueCapsule> assetIssueList = this.dbManager.getAssetIssueStoreFinal().getAssetIssuesPaginated(offset, limit);
        if (CollectionUtils.isEmpty(assetIssueList)) {
            return null;
        }
        assetIssueList.forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.AssetIssueList getAssetIssueByAccount(ByteString accountAddress) {
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        List<AssetIssueCapsule> assetIssueCapsuleList = this.dbManager.getAssetIssueStoreFinal().getAllAssetIssues();
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getOwnerAddress().equals((Object)accountAddress)).forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.AccountNetMessage getAccountNet(ByteString accountAddress) {
        Map<String, Long> allFreeAssetNetUsage;
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        GrpcAPI.AccountNetMessage.Builder builder = GrpcAPI.AccountNetMessage.newBuilder();
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(accountAddress.toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.dbManager);
        processor.updateUsage(accountCapsule);
        long netLimit = processor.calculateGlobalNetLimit(accountCapsule);
        long freeNetLimit = this.dbManager.getDynamicPropertiesStore().getFreeNetLimit();
        long totalNetLimit = this.dbManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.dbManager.getDynamicPropertiesStore().getTotalNetWeight();
        HashMap<String, Long> assetNetLimitMap = new HashMap<String, Long>();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsage();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString(asset);
                assetNetLimitMap.put((String)asset, this.dbManager.getAssetIssueStore().get(key).getFreeAssetNetLimit());
            });
        } else {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsageV2();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString(asset);
                assetNetLimitMap.put((String)asset, this.dbManager.getAssetIssueV2Store().get(key).getFreeAssetNetLimit());
            });
        }
        builder.setFreeNetUsed(accountCapsule.getFreeNetUsage()).setFreeNetLimit(freeNetLimit).setNetUsed(accountCapsule.getNetUsage()).setNetLimit(netLimit).setTotalNetLimit(totalNetLimit).setTotalNetWeight(totalNetWeight).putAllAssetNetUsed(allFreeAssetNetUsage).putAllAssetNetLimit(assetNetLimitMap);
        return builder.build();
    }

    public GrpcAPI.AccountResourceMessage getAccountResource(ByteString accountAddress) {
        Map<String, Long> allFreeAssetNetUsage;
        if (accountAddress == null || accountAddress.isEmpty()) {
            return null;
        }
        GrpcAPI.AccountResourceMessage.Builder builder = GrpcAPI.AccountResourceMessage.newBuilder();
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(accountAddress.toByteArray());
        if (accountCapsule == null) {
            return null;
        }
        BandwidthProcessor processor = new BandwidthProcessor(this.dbManager);
        processor.updateUsage(accountCapsule);
        EnergyProcessor energyProcessor = new EnergyProcessor(this.dbManager);
        energyProcessor.updateUsage(accountCapsule);
        long netLimit = processor.calculateGlobalNetLimit(accountCapsule);
        long freeNetLimit = this.dbManager.getDynamicPropertiesStore().getFreeNetLimit();
        long totalNetLimit = this.dbManager.getDynamicPropertiesStore().getTotalNetLimit();
        long totalNetWeight = this.dbManager.getDynamicPropertiesStore().getTotalNetWeight();
        long energyLimit = energyProcessor.calculateGlobalEnergyLimit(accountCapsule);
        long totalEnergyLimit = this.dbManager.getDynamicPropertiesStore().getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.dbManager.getDynamicPropertiesStore().getTotalEnergyWeight();
        long storageLimit = accountCapsule.getAccountResource().getStorageLimit();
        long storageUsage = accountCapsule.getAccountResource().getStorageUsage();
        HashMap<String, Long> assetNetLimitMap = new HashMap<String, Long>();
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsage();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString(asset);
                assetNetLimitMap.put((String)asset, this.dbManager.getAssetIssueStore().get(key).getFreeAssetNetLimit());
            });
        } else {
            allFreeAssetNetUsage = accountCapsule.getAllFreeAssetNetUsageV2();
            allFreeAssetNetUsage.keySet().forEach(asset -> {
                byte[] key = ByteArray.fromString(asset);
                assetNetLimitMap.put((String)asset, this.dbManager.getAssetIssueV2Store().get(key).getFreeAssetNetLimit());
            });
        }
        builder.setFreeNetUsed(accountCapsule.getFreeNetUsage()).setFreeNetLimit(freeNetLimit).setNetUsed(accountCapsule.getNetUsage()).setNetLimit(netLimit).setTotalNetLimit(totalNetLimit).setTotalNetWeight(totalNetWeight).setEnergyLimit(energyLimit).setEnergyUsed(accountCapsule.getAccountResource().getEnergyUsage()).setTotalEnergyLimit(totalEnergyLimit).setTotalEnergyWeight(totalEnergyWeight).setStorageLimit(storageLimit).setStorageUsed(storageUsage).putAllAssetNetUsed(allFreeAssetNetUsage).putAllAssetNetLimit(assetNetLimitMap);
        return builder.build();
    }

    public Contract.AssetIssueContract getAssetIssueByName(ByteString assetName) throws NonUniqueObjectException {
        if (assetName == null || assetName.isEmpty()) {
            return null;
        }
        if (this.dbManager.getDynamicPropertiesStore().getAllowSameTokenName() == 0L) {
            AssetIssueCapsule assetIssueCapsule2 = this.dbManager.getAssetIssueStore().get(assetName.toByteArray());
            return assetIssueCapsule2 != null ? assetIssueCapsule2.getInstance() : null;
        }
        List<AssetIssueCapsule> assetIssueCapsuleList = this.dbManager.getAssetIssueV2Store().getAllAssetIssues();
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getName().equals((Object)assetName)).forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        if (builder.getAssetIssueCount() > 1) {
            throw new NonUniqueObjectException("get more than one asset, please use getassetissuebyid");
        }
        AssetIssueCapsule assetIssueCapsule3 = this.dbManager.getAssetIssueV2Store().get(assetName.toByteArray());
        if (assetIssueCapsule3 != null) {
            if (builder.getAssetIssueCount() > 0 && builder.getAssetIssue(0).getId().equals(assetIssueCapsule3.getInstance().getId())) {
                return assetIssueCapsule3.getInstance();
            }
            builder.addAssetIssue(assetIssueCapsule3.getInstance());
            if (builder.getAssetIssueCount() > 1) {
                throw new NonUniqueObjectException("get more than one asset, please use getassetissuebyid");
            }
        }
        if (builder.getAssetIssueCount() > 0) {
            return builder.getAssetIssue(0);
        }
        return null;
    }

    public GrpcAPI.AssetIssueList getAssetIssueListByName(ByteString assetName) {
        if (assetName == null || assetName.isEmpty()) {
            return null;
        }
        List<AssetIssueCapsule> assetIssueCapsuleList = this.dbManager.getAssetIssueStoreFinal().getAllAssetIssues();
        GrpcAPI.AssetIssueList.Builder builder = GrpcAPI.AssetIssueList.newBuilder();
        assetIssueCapsuleList.stream().filter(assetIssueCapsule -> assetIssueCapsule.getName().equals((Object)assetName)).forEach(issueCapsule -> builder.addAssetIssue(issueCapsule.getInstance()));
        return builder.build();
    }

    public Contract.AssetIssueContract getAssetIssueById(String assetId) {
        if (assetId == null || assetId.isEmpty()) {
            return null;
        }
        AssetIssueCapsule assetIssueCapsule = this.dbManager.getAssetIssueV2Store().get(ByteArray.fromString(assetId));
        return assetIssueCapsule != null ? assetIssueCapsule.getInstance() : null;
    }

    public GrpcAPI.NumberMessage totalTransaction() {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder().setNum(this.dbManager.getTransactionStore().getTotalTransactions());
        return builder.build();
    }

    public GrpcAPI.NumberMessage getNextMaintenanceTime() {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder().setNum(this.dbManager.getDynamicPropertiesStore().getNextMaintenanceTime());
        return builder.build();
    }

    public Protocol.Block getBlockById(ByteString BlockId2) {
        if (Objects.isNull(BlockId2)) {
            return null;
        }
        Protocol.Block block = null;
        try {
            block = ((BlockCapsule)this.dbManager.getBlockStore().get(BlockId2.toByteArray())).getInstance();
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        return block;
    }

    public GrpcAPI.BlockList getBlocksByLimitNext(long number, long limit) {
        if (limit <= 0L) {
            return null;
        }
        GrpcAPI.BlockList.Builder blockListBuilder = GrpcAPI.BlockList.newBuilder();
        this.dbManager.getBlockStore().getLimitNumber(number, limit).forEach(blockCapsule -> blockListBuilder.addBlock(blockCapsule.getInstance()));
        return blockListBuilder.build();
    }

    public GrpcAPI.BlockList getBlockByLatestNum(long getNum) {
        GrpcAPI.BlockList.Builder blockListBuilder = GrpcAPI.BlockList.newBuilder();
        this.dbManager.getBlockStore().getBlockByLatestNum(getNum).forEach(blockCapsule -> blockListBuilder.addBlock(blockCapsule.getInstance()));
        return blockListBuilder.build();
    }

    public Protocol.Transaction getTransactionById(ByteString transactionId) {
        if (Objects.isNull(transactionId)) {
            return null;
        }
        TransactionCapsule transactionCapsule = null;
        try {
            transactionCapsule = this.dbManager.getTransactionStore().get(transactionId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (transactionCapsule != null) {
            return transactionCapsule.getInstance();
        }
        return null;
    }

    public Protocol.TransactionInfo getTransactionInfoById(ByteString transactionId) {
        if (Objects.isNull(transactionId)) {
            return null;
        }
        TransactionInfoCapsule transactionInfoCapsule = null;
        try {
            transactionInfoCapsule = this.dbManager.getTransactionHistoryStore().get(transactionId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (transactionInfoCapsule != null) {
            return transactionInfoCapsule.getInstance();
        }
        return null;
    }

    public Protocol.Proposal getProposalById(ByteString proposalId) {
        if (Objects.isNull(proposalId)) {
            return null;
        }
        ProposalCapsule proposalCapsule = null;
        try {
            proposalCapsule = this.dbManager.getProposalStore().get(proposalId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (proposalCapsule != null) {
            return proposalCapsule.getInstance();
        }
        return null;
    }

    public Protocol.Exchange getExchangeById(ByteString exchangeId) {
        if (Objects.isNull(exchangeId)) {
            return null;
        }
        ExchangeCapsule exchangeCapsule = null;
        try {
            exchangeCapsule = this.dbManager.getExchangeStoreFinal().get(exchangeId.toByteArray());
        }
        catch (StoreException storeException) {
            // empty catch block
        }
        if (exchangeCapsule != null) {
            return exchangeCapsule.getInstance();
        }
        return null;
    }

    public GrpcAPI.NodeList listNodes() {
        List<NodeHandler> handlerList = this.nodeManager.dumpActiveNodes();
        HashMap<String, NodeHandler> nodeHandlerMap = new HashMap<String, NodeHandler>();
        for (NodeHandler handler : handlerList) {
            String key = handler.getNode().getHexId() + handler.getNode().getHost();
            nodeHandlerMap.put(key, handler);
        }
        GrpcAPI.NodeList.Builder nodeListBuilder = GrpcAPI.NodeList.newBuilder();
        nodeHandlerMap.entrySet().stream().forEach(v -> {
            Node node = ((NodeHandler)v.getValue()).getNode();
            nodeListBuilder.addNodes(GrpcAPI.Node.newBuilder().setAddress(GrpcAPI.Address.newBuilder().setHost(ByteString.copyFrom((byte[])ByteArray.fromString(node.getHost()))).setPort(node.getPort())));
        });
        return nodeListBuilder.build();
    }

    public Protocol.Transaction deployContract(Contract.CreateSmartContract createSmartContract, TransactionCapsule trxCap) {
        return trxCap.getInstance();
    }

    public Protocol.Transaction triggerContract(Contract.TriggerSmartContract triggerSmartContract, TransactionCapsule trxCap, GrpcAPI.TransactionExtention.Builder builder, GrpcAPI.Return.Builder retBuilder) throws ContractValidateException, ContractExeException, HeaderNotFound, VMIllegalException {
        byte[] contractAddress;
        ContractStore contractStore = this.dbManager.getContractStore();
        Protocol.SmartContract.ABI abi = contractStore.getABI(contractAddress = triggerSmartContract.getContractAddress().toByteArray());
        if (abi == null) {
            throw new ContractValidateException("No contract or not a smart contract");
        }
        byte[] selector = Wallet.getSelector(triggerSmartContract.getData().toByteArray());
        if (!Wallet.isConstant(abi, selector)) {
            return trxCap.getInstance();
        }
        if (!Args.getInstance().isSupportConstant()) {
            throw new ContractValidateException("this node don't support constant");
        }
        DepositImpl deposit = DepositImpl.createRoot(this.dbManager);
        List<BlockCapsule> blockCapsuleList = this.dbManager.getBlockStore().getBlockByLatestNum(1L);
        if (CollectionUtils.isEmpty(blockCapsuleList)) {
            throw new HeaderNotFound("latest block not found");
        }
        Protocol.Block headBlock = blockCapsuleList.get(0).getInstance();
        RuntimeImpl runtime = new RuntimeImpl(trxCap.getInstance(), new BlockCapsule(headBlock), deposit, new ProgramInvokeFactoryImpl(), true);
        VMConfig.initVmHardFork();
        runtime.execute();
        runtime.go();
        runtime.finalization();
        if (runtime.getResult().getException() != null) {
            RuntimeException e = runtime.getResult().getException();
            logger.warn("Constant call has error {}", (Object)e.getMessage());
            throw e;
        }
        ProgramResult result = runtime.getResult();
        TransactionResultCapsule ret = new TransactionResultCapsule();
        builder.addConstantResult(ByteString.copyFrom((byte[])result.getHReturn()));
        ret.setStatus(0L, Protocol.Transaction.Result.code.SUCESS);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{runtime.getRuntimeError()})) {
            ret.setStatus(0L, Protocol.Transaction.Result.code.FAILED);
            retBuilder.setMessage(ByteString.copyFromUtf8((String)runtime.getRuntimeError())).build();
        }
        trxCap.setResult(ret);
        return trxCap.getInstance();
    }

    public Protocol.SmartContract getContract(GrpcAPI.BytesMessage bytesMessage) {
        byte[] address = bytesMessage.getValue().toByteArray();
        AccountCapsule accountCapsule = this.dbManager.getAccountStore().get(address);
        if (accountCapsule == null) {
            logger.error("Get contract failed, the account is not exist or the account does not have code hash!");
            return null;
        }
        ContractCapsule contractCapsule = this.dbManager.getContractStore().get(bytesMessage.getValue().toByteArray());
        if (Objects.nonNull(contractCapsule)) {
            return contractCapsule.getInstance();
        }
        return null;
    }

    private static byte[] getSelector(byte[] data) {
        if (data == null || data.length < 4) {
            return null;
        }
        byte[] ret = new byte[4];
        System.arraycopy(data, 0, ret, 0, 4);
        return ret;
    }

    private static boolean isConstant(Protocol.SmartContract.ABI abi, byte[] selector) {
        if (selector == null || selector.length != 4 || abi.getEntrysList().size() == 0) {
            return false;
        }
        for (int i = 0; i < abi.getEntrysCount(); ++i) {
            Protocol.SmartContract.ABI.Entry entry = abi.getEntrys(i);
            if (entry.getType() != Protocol.SmartContract.ABI.Entry.EntryType.Function) continue;
            int inputCount = entry.getInputsCount();
            StringBuffer sb = new StringBuffer();
            sb.append(entry.getName());
            sb.append("(");
            for (int k = 0; k < inputCount; ++k) {
                Protocol.SmartContract.ABI.Entry.Param param = entry.getInputs(k);
                sb.append(param.getType());
                if (k + 1 >= inputCount) continue;
                sb.append(",");
            }
            sb.append(")");
            byte[] funcSelector = new byte[4];
            System.arraycopy(Hash.sha3(sb.toString().getBytes()), 0, funcSelector, 0, 4);
            if (!Arrays.equals(funcSelector, selector)) continue;
            return entry.getConstant() || entry.getStateMutability().equals((Object)Protocol.SmartContract.ABI.Entry.StateMutabilityType.View);
        }
        return false;
    }

    public GrpcAPI.ProposalList getPaginatedProposalList(long offset, long limit) {
        if (limit < 0L || offset < 0L) {
            return null;
        }
        long latestProposalNum = this.dbManager.getDynamicPropertiesStore().getLatestProposalNum();
        if (latestProposalNum <= offset) {
            return null;
        }
        limit = limit > 1000L ? 1000L : limit;
        long end = offset + limit;
        end = end > latestProposalNum ? latestProposalNum : end;
        GrpcAPI.ProposalList.Builder builder = GrpcAPI.ProposalList.newBuilder();
        ImmutableList rangeList = ContiguousSet.create((Range)Range.openClosed((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(end)), (DiscreteDomain)DiscreteDomain.longs()).asList();
        rangeList.stream().map(ProposalCapsule::calculateDbKey).map(key -> {
            try {
                return this.dbManager.getProposalStore().get((byte[])key);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(proposalCapsule -> builder.addProposals(proposalCapsule.getInstance()));
        return builder.build();
    }

    public GrpcAPI.ExchangeList getPaginatedExchangeList(long offset, long limit) {
        if (limit < 0L || offset < 0L) {
            return null;
        }
        long latestExchangeNum = this.dbManager.getDynamicPropertiesStore().getLatestExchangeNum();
        if (latestExchangeNum <= offset) {
            return null;
        }
        limit = limit > 1000L ? 1000L : limit;
        long end = offset + limit;
        end = end > latestExchangeNum ? latestExchangeNum : end;
        GrpcAPI.ExchangeList.Builder builder = GrpcAPI.ExchangeList.newBuilder();
        ImmutableList rangeList = ContiguousSet.create((Range)Range.openClosed((Comparable)Long.valueOf(offset), (Comparable)Long.valueOf(end)), (DiscreteDomain)DiscreteDomain.longs()).asList();
        rangeList.stream().map(ExchangeCapsule::calculateDbKey).map(key -> {
            try {
                return this.dbManager.getExchangeStoreFinal().get((byte[])key);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(exchangeCapsule -> builder.addExchanges(exchangeCapsule.getInstance()));
        return builder.build();
    }

    public ECKey getEcKey() {
        return this.ecKey;
    }
}

