/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.primitives.Longs;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConversion {
    private static final Logger logger = LoggerFactory.getLogger(TypeConversion.class);

    public static byte[] longToBytes(long x) {
        return Longs.toByteArray((long)x);
    }

    public static long bytesToLong(byte[] bytes) {
        return Longs.fromByteArray((byte[])bytes);
    }

    public static String bytesToHexString(byte[] src) {
        return Hex.encodeHexString((byte[])src);
    }

    public static byte[] hexStringToBytes(String hexString) {
        try {
            return Hex.decodeHex((String)hexString);
        }
        catch (DecoderException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean increment(byte[] bytes) {
        int i;
        boolean startIndex = false;
        for (i = bytes.length - 1; i >= 0; --i) {
            int n = i;
            bytes[n] = (byte)(bytes[n] + 1);
            if (bytes[i] != 0) break;
        }
        return i >= 0 || bytes[0] != 0;
    }
}

