/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static List<String> recursiveList(String path) throws IOException {
        final ArrayList<String> files = new ArrayList<String>();
        Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                files.add(file.toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public static boolean recursiveDelete(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                Arrays.stream((Object[])Objects.requireNonNull(file.list())).map(s -> fileName + System.getProperty("file.separator") + s).forEachOrdered(FileUtil::recursiveDelete);
            }
            file.setWritable(true);
            return file.delete();
        }
        return false;
    }

    public static void saveData(String filePath, String data, boolean append) {
        File priFile = new File(filePath);
        try {
            priFile.createNewFile();
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(priFile, append));){
                bw.write(data);
                bw.flush();
            }
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static int readData(String filePath, char[] buf) {
        int len;
        File file = new File(filePath);
        try (BufferedReader bufRead = new BufferedReader(new FileReader(file));){
            len = bufRead.read(buf, 0, buf.length);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return 0;
        }
        return len;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                logger.warn("can't delete dir:" + dir);
                return false;
            }
        }
        return dir.delete();
    }
}

