/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.utils;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;

public class ByteArray {
    private static final Logger logger = LoggerFactory.getLogger(ByteArray.class);
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static String toHexString(byte[] data) {
        return data == null ? "" : Hex.toHexString((byte[])data);
    }

    public static byte[] fromHexString(String data) {
        if (data == null) {
            return EMPTY_BYTE_ARRAY;
        }
        if (data.startsWith("0x")) {
            data = data.substring(2);
        }
        if (data.length() % 2 != 0) {
            data = "0" + data;
        }
        return Hex.decode((String)data);
    }

    public static long toLong(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? 0L : new BigInteger(1, b).longValue();
    }

    public static int toInt(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? 0 : new BigInteger(1, b).intValue();
    }

    public static byte[] fromString(String s) {
        return StringUtils.isBlank((CharSequence)s) ? null : s.getBytes();
    }

    public static String toStr(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : new String(b);
    }

    public static byte[] fromLong(long val) {
        return Longs.toByteArray((long)val);
    }

    public static byte[] fromInt(int val) {
        return Ints.toByteArray((int)val);
    }

    public static byte[] fromObject(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("objectToByteArray failed: " + e.getMessage(), (Throwable)e);
        }
        return bytes;
    }

    public static byte[] subArray(byte[] input, int start, int end) {
        byte[] result = new byte[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }
}

