/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.tron.common.storage.Type;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.CodeCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.exception.BadItemException;

public class Value {
    private Type type;
    private byte[] any = null;

    public Value(byte[] any, Type type) {
        if (any != null && any.length > 0) {
            this.any = new byte[any.length];
            System.arraycopy(any, 0, this.any, 0, any.length);
            this.type = type.clone();
        }
    }

    public Value(byte[] any, int type) {
        if (any != null && any.length > 0) {
            this.any = new byte[any.length];
            System.arraycopy(any, 0, this.any, 0, any.length);
            this.type = new Type(type);
        }
    }

    private Value(Value value) {
        if (value.getAny() != null && value.getAny().length > 0) {
            this.any = new byte[value.any.length];
            System.arraycopy(value.getAny(), 0, this.any, 0, value.getAny().length);
            this.type = value.getType().clone();
        }
    }

    public Value clone() {
        return new Value(this);
    }

    public byte[] getAny() {
        return this.any;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void addType(Type type) {
        this.type.addType(type);
    }

    public void addType(int type) {
        this.type.addType(type);
    }

    public AccountCapsule getAccount() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new AccountCapsule(this.any);
    }

    public BytesCapsule getBytes() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new BytesCapsule(this.any);
    }

    public TransactionCapsule getTransaction() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        try {
            return new TransactionCapsule(this.any);
        }
        catch (BadItemException e) {
            return null;
        }
    }

    public BlockCapsule getBlock() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        try {
            return new BlockCapsule(this.any);
        }
        catch (Exception e) {
            return null;
        }
    }

    public WitnessCapsule getWitness() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new WitnessCapsule(this.any);
    }

    public VotesCapsule getVotes() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new VotesCapsule(this.any);
    }

    public BytesCapsule getBlockIndex() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new BytesCapsule(this.any);
    }

    public CodeCapsule getCode() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new CodeCapsule(this.any);
    }

    public ContractCapsule getContract() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new ContractCapsule(this.any);
    }

    public AssetIssueCapsule getAssetIssue() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new AssetIssueCapsule(this.any);
    }

    public ProposalCapsule getProposal() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new ProposalCapsule(this.any);
    }

    public BytesCapsule getDynamicProperties() {
        if (ArrayUtils.isEmpty((byte[])this.any)) {
            return null;
        }
        return new BytesCapsule(this.any);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Value V = (Value)obj;
        return Arrays.equals(this.any, V.getAny());
    }

    public int hashCode() {
        return new Integer(this.type.hashCode() + Arrays.hashCode(this.any)).hashCode();
    }

    public static Value create(byte[] any, int type) {
        return new Value(any, type);
    }

    public static Value create(byte[] any, Type type) {
        return new Value(any, type);
    }

    public static Value create(byte[] any) {
        return new Value(any, Type.VALUE_TYPE_NORMAL);
    }
}

