/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.Strings;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.runtime.config.VMConfig;
import org.tron.common.runtime.utils.MUtil;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.Storage;
import org.tron.common.storage.Deposit;
import org.tron.common.storage.Key;
import org.tron.common.storage.Type;
import org.tron.common.storage.Value;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.AccountStore;
import org.tron.core.db.BlockStore;
import org.tron.core.db.CodeStore;
import org.tron.core.db.ContractStore;
import org.tron.core.db.DelegatedResourceStore;
import org.tron.core.db.DynamicPropertiesStore;
import org.tron.core.db.Manager;
import org.tron.core.db.ProposalStore;
import org.tron.core.db.TransactionStore;
import org.tron.core.db.VotesStore;
import org.tron.core.db.WitnessStore;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Protocol;

public class DepositImpl
implements Deposit {
    private static final Logger logger = LoggerFactory.getLogger((String)"deposit");
    private static final byte[] LATEST_PROPOSAL_NUM = "LATEST_PROPOSAL_NUM".getBytes();
    private static final byte[] WITNESS_ALLOWANCE_FROZEN_TIME = "WITNESS_ALLOWANCE_FROZEN_TIME".getBytes();
    private static final byte[] MAINTENANCE_TIME_INTERVAL = "MAINTENANCE_TIME_INTERVAL".getBytes();
    private static final byte[] NEXT_MAINTENANCE_TIME = "NEXT_MAINTENANCE_TIME".getBytes();
    private Manager dbManager;
    private Deposit parent = null;
    private HashMap<Key, Value> accountCache = new HashMap();
    private HashMap<Key, Value> transactionCache = new HashMap();
    private HashMap<Key, Value> blockCache = new HashMap();
    private HashMap<Key, Value> witnessCache = new HashMap();
    private HashMap<Key, Value> codeCache = new HashMap();
    private HashMap<Key, Value> contractCache = new HashMap();
    private HashMap<Key, Value> votesCache = new HashMap();
    private HashMap<Key, Value> proposalCache = new HashMap();
    private HashMap<Key, Value> dynamicPropertiesCache = new HashMap();
    private HashMap<Key, Storage> storageCache = new HashMap();
    private HashMap<Key, Value> assetIssueCache = new HashMap();

    private DepositImpl(Manager dbManager, DepositImpl parent) {
        this.init(dbManager, parent);
    }

    protected void init(Manager dbManager, DepositImpl parent) {
        this.dbManager = dbManager;
        this.parent = parent;
    }

    @Override
    public Manager getDbManager() {
        return this.dbManager;
    }

    private BlockStore getBlockStore() {
        return this.dbManager.getBlockStore();
    }

    private TransactionStore getTransactionStore() {
        return this.dbManager.getTransactionStore();
    }

    private ContractStore getContractStore() {
        return this.dbManager.getContractStore();
    }

    private WitnessStore getWitnessStore() {
        return this.dbManager.getWitnessStore();
    }

    private VotesStore getVotesStore() {
        return this.dbManager.getVotesStore();
    }

    private ProposalStore getProposalStore() {
        return this.dbManager.getProposalStore();
    }

    private DynamicPropertiesStore getDynamicPropertiesStore() {
        return this.dbManager.getDynamicPropertiesStore();
    }

    private AccountStore getAccountStore() {
        return this.dbManager.getAccountStore();
    }

    private CodeStore getCodeStore() {
        return this.dbManager.getCodeStore();
    }

    private DelegatedResourceStore getDelegatedResourceStore() {
        return this.dbManager.getDelegatedResourceStore();
    }

    @Override
    public Deposit newDepositChild() {
        return new DepositImpl(this.dbManager, this);
    }

    @Override
    public synchronized AccountCapsule createAccount(byte[] address, Protocol.AccountType type) {
        Key key = new Key(address);
        AccountCapsule account = new AccountCapsule(ByteString.copyFrom((byte[])address), type);
        this.accountCache.put(key, new Value(account.getData(), Type.VALUE_TYPE_CREATE));
        return account;
    }

    @Override
    public AccountCapsule createAccount(byte[] address, String accountName, Protocol.AccountType type) {
        Key key = new Key(address);
        AccountCapsule account = new AccountCapsule(ByteString.copyFrom((byte[])address), ByteString.copyFromUtf8((String)accountName), type);
        this.accountCache.put(key, new Value(account.getData(), Type.VALUE_TYPE_CREATE));
        return account;
    }

    @Override
    public synchronized AccountCapsule getAccount(byte[] address) {
        Key key = new Key(address);
        if (this.accountCache.containsKey(key)) {
            return this.accountCache.get(key).getAccount();
        }
        AccountCapsule accountCapsule = this.parent != null ? this.parent.getAccount(address) : this.getAccountStore().get(address);
        if (accountCapsule != null) {
            this.accountCache.put(key, Value.create(accountCapsule.getData()));
        }
        return accountCapsule;
    }

    @Override
    public byte[] getBlackHoleAddress() {
        return this.getAccountStore().getBlackhole().getAddress().toByteArray();
    }

    @Override
    public WitnessCapsule getWitness(byte[] address) {
        Key key = new Key(address);
        if (this.witnessCache.containsKey(key)) {
            return this.witnessCache.get(key).getWitness();
        }
        WitnessCapsule witnessCapsule = this.parent != null ? this.parent.getWitness(address) : this.getWitnessStore().get(address);
        if (witnessCapsule != null) {
            this.witnessCache.put(key, Value.create(witnessCapsule.getData()));
        }
        return witnessCapsule;
    }

    @Override
    public synchronized VotesCapsule getVotesCapsule(byte[] address) {
        Key key = new Key(address);
        if (this.votesCache.containsKey(key)) {
            return this.votesCache.get(key).getVotes();
        }
        VotesCapsule votesCapsule = this.parent != null ? this.parent.getVotesCapsule(address) : this.getVotesStore().get(address);
        if (votesCapsule != null) {
            this.votesCache.put(key, Value.create(votesCapsule.getData()));
        }
        return votesCapsule;
    }

    @Override
    public synchronized ProposalCapsule getProposalCapsule(byte[] id) {
        ProposalCapsule proposalCapsule;
        Key key = new Key(id);
        if (this.proposalCache.containsKey(key)) {
            return this.proposalCache.get(key).getProposal();
        }
        if (this.parent != null) {
            proposalCapsule = this.parent.getProposalCapsule(id);
        } else {
            try {
                proposalCapsule = this.getProposalStore().get(id);
            }
            catch (ItemNotFoundException e) {
                logger.warn("Not found proposal, id:" + Hex.toHexString((byte[])id));
                proposalCapsule = null;
            }
        }
        if (proposalCapsule != null) {
            this.proposalCache.put(key, Value.create(proposalCapsule.getData()));
        }
        return proposalCapsule;
    }

    @Override
    public void deleteContract(byte[] address) {
        this.getCodeStore().delete(address);
        this.getAccountStore().delete(address);
        this.getContractStore().delete(address);
    }

    @Override
    public synchronized void createContract(byte[] address, ContractCapsule contractCapsule) {
        Key key = Key.create(address);
        Value value = Value.create(contractCapsule.getData(), Type.VALUE_TYPE_CREATE);
        this.contractCache.put(key, value);
    }

    @Override
    public synchronized ContractCapsule getContract(byte[] address) {
        Key key = Key.create(address);
        if (this.contractCache.containsKey(key)) {
            return this.contractCache.get(key).getContract();
        }
        ContractCapsule contractCapsule = this.parent != null ? this.parent.getContract(address) : this.getContractStore().get(address);
        if (contractCapsule != null) {
            this.contractCache.put(key, Value.create(contractCapsule.getData()));
        }
        return contractCapsule;
    }

    @Override
    public synchronized void saveCode(byte[] codeHash, byte[] code2) {
        Key key = Key.create(codeHash);
        Value value = Value.create(code2, Type.VALUE_TYPE_CREATE);
        this.codeCache.put(key, value);
    }

    @Override
    public synchronized byte[] getCode(byte[] addr) {
        Key key = Key.create(addr);
        if (this.codeCache.containsKey(key)) {
            return this.codeCache.get(key).getCode().getData();
        }
        Object code2 = this.parent != null ? this.parent.getCode(addr) : (Object)(null == this.getCodeStore().get(addr) ? null : this.getCodeStore().get(addr).getData());
        if (code2 != null) {
            this.codeCache.put(key, Value.create(code2));
        }
        return code2;
    }

    @Override
    public synchronized Storage getStorage(byte[] address) {
        Storage storage;
        Key key = Key.create(address);
        if (this.storageCache.containsKey(key)) {
            return this.storageCache.get(key);
        }
        if (this.parent != null) {
            Storage parentStorage = this.parent.getStorage(address);
            storage = VMConfig.getEnergyLimitHardFork() ? new Storage(parentStorage) : parentStorage;
        } else {
            storage = new Storage(address, this.dbManager.getStorageRowStore());
        }
        return storage;
    }

    @Override
    public synchronized AssetIssueCapsule getAssetIssue(byte[] tokenId) {
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes(tokenId);
        Key key = Key.create(tokenIdWithoutLeadingZero);
        if (this.assetIssueCache.containsKey(key)) {
            return this.assetIssueCache.get(key).getAssetIssue();
        }
        AssetIssueCapsule assetIssueCapsule = this.parent != null ? this.parent.getAssetIssue(tokenIdWithoutLeadingZero) : this.dbManager.getAssetIssueStoreFinal().get(tokenIdWithoutLeadingZero);
        if (assetIssueCapsule != null) {
            this.assetIssueCache.put(key, Value.create(assetIssueCapsule.getData()));
        }
        return assetIssueCapsule;
    }

    @Override
    public synchronized void putStorageValue(byte[] address, DataWord key, DataWord value) {
        Storage storage;
        if (this.getAccount(address = MUtil.convertToTronAddress(address)) == null) {
            return;
        }
        Key addressKey = Key.create(address);
        if (this.storageCache.containsKey(addressKey)) {
            storage = this.storageCache.get(addressKey);
        } else {
            storage = this.getStorage(address);
            this.storageCache.put(addressKey, storage);
        }
        storage.put(key, value);
    }

    @Override
    public synchronized DataWord getStorageValue(byte[] address, DataWord key) {
        Storage storage;
        if (this.getAccount(address = MUtil.convertToTronAddress(address)) == null) {
            return null;
        }
        Key addressKey = Key.create(address);
        if (this.storageCache.containsKey(addressKey)) {
            storage = this.storageCache.get(addressKey);
        } else {
            storage = this.getStorage(address);
            this.storageCache.put(addressKey, storage);
        }
        return storage.getValue(key);
    }

    @Override
    public synchronized long getBalance(byte[] address) {
        AccountCapsule accountCapsule = this.getAccount(address);
        return accountCapsule == null ? 0L : accountCapsule.getBalance();
    }

    @Override
    public synchronized long addTokenBalance(byte[] address, byte[] tokenId, long value) {
        byte[] tokenIdWithoutLeadingZero = ByteUtil.stripLeadingZeroes(tokenId);
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            accountCapsule = this.createAccount(address, Protocol.AccountType.Normal);
        }
        long balance = accountCapsule.getAssetMapV2().getOrDefault(new String(tokenIdWithoutLeadingZero), new Long(0L));
        if (value == 0L) {
            return balance;
        }
        if (value < 0L && balance < -value) {
            throw new RuntimeException(StringUtil.createReadableString(accountCapsule.createDbKey()) + " insufficient balance");
        }
        if (value >= 0L) {
            accountCapsule.addAssetAmountV2(tokenIdWithoutLeadingZero, value, this.dbManager);
        } else {
            accountCapsule.reduceAssetAmountV2(tokenIdWithoutLeadingZero, -value, this.dbManager);
        }
        Key key = Key.create(address);
        Value V = Value.create(accountCapsule.getData(), Type.VALUE_TYPE_DIRTY | this.accountCache.get(key).getType().getType());
        this.accountCache.put(key, V);
        return accountCapsule.getAssetMapV2().get(new String(tokenIdWithoutLeadingZero));
    }

    @Override
    public synchronized long addBalance(byte[] address, long value) {
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            accountCapsule = this.createAccount(address, Protocol.AccountType.Normal);
        }
        long balance = accountCapsule.getBalance();
        if (value == 0L) {
            return balance;
        }
        if (value < 0L && balance < -value) {
            throw new RuntimeException(StringUtil.createReadableString(accountCapsule.createDbKey()) + " insufficient balance");
        }
        accountCapsule.setBalance(Math.addExact(balance, value));
        Key key = Key.create(address);
        Value val = Value.create(accountCapsule.getData(), Type.VALUE_TYPE_DIRTY | this.accountCache.get(key).getType().getType());
        this.accountCache.put(key, val);
        return accountCapsule.getBalance();
    }

    @Override
    public synchronized long getTokenBalance(byte[] address, byte[] tokenId) {
        AccountCapsule accountCapsule = this.getAccount(address);
        if (accountCapsule == null) {
            return 0L;
        }
        String tokenStr = new String(ByteUtil.stripLeadingZeroes(tokenId));
        return accountCapsule.getAssetMapV2().getOrDefault(tokenStr, 0L);
    }

    @Override
    public TransactionCapsule getTransaction(byte[] trxHash) {
        TransactionCapsule transactionCapsule;
        Key key = Key.create(trxHash);
        if (this.transactionCache.containsKey(key)) {
            return this.transactionCache.get(key).getTransaction();
        }
        if (this.parent != null) {
            transactionCapsule = this.parent.getTransaction(trxHash);
        } else {
            try {
                transactionCapsule = this.getTransactionStore().get(trxHash);
            }
            catch (BadItemException e) {
                transactionCapsule = null;
            }
        }
        if (transactionCapsule != null) {
            this.transactionCache.put(key, Value.create(transactionCapsule.getData()));
        }
        return transactionCapsule;
    }

    @Override
    public BlockCapsule getBlock(byte[] blockHash) {
        BlockCapsule ret;
        Key key = Key.create(blockHash);
        if (this.blockCache.containsKey(key)) {
            return this.blockCache.get(key).getBlock();
        }
        try {
            ret = this.parent != null ? this.parent.getBlock(blockHash) : (BlockCapsule)this.getBlockStore().get(blockHash);
        }
        catch (Exception e) {
            ret = null;
        }
        if (ret != null) {
            this.blockCache.put(key, Value.create(ret.getData()));
        }
        return ret;
    }

    @Override
    public void putAccount(Key key, Value value) {
        this.accountCache.put(key, value);
    }

    @Override
    public void putTransaction(Key key, Value value) {
        this.transactionCache.put(key, value);
    }

    @Override
    public void putBlock(Key key, Value value) {
        this.blockCache.put(key, value);
    }

    @Override
    public void putWitness(Key key, Value value) {
        this.witnessCache.put(key, value);
    }

    @Override
    public void putCode(Key key, Value value) {
        this.codeCache.put(key, value);
    }

    @Override
    public void putContract(Key key, Value value) {
        this.contractCache.put(key, value);
    }

    @Override
    public void putStorage(Key key, Storage cache) {
        this.storageCache.put(key, cache);
    }

    @Override
    public void putVotes(Key key, Value value) {
        this.votesCache.put(key, value);
    }

    @Override
    public void putProposal(Key key, Value value) {
        this.proposalCache.put(key, value);
    }

    @Override
    public void putDynamicProperties(Key key, Value value) {
        this.dynamicPropertiesCache.put(key, value);
    }

    @Override
    public long getLatestProposalNum() {
        return Longs.fromByteArray((byte[])this.getDynamic(LATEST_PROPOSAL_NUM).getData());
    }

    @Override
    public long getWitnessAllowanceFrozenTime() {
        byte[] frozenTime = this.getDynamic(WITNESS_ALLOWANCE_FROZEN_TIME).getData();
        if (frozenTime.length >= 8) {
            return Longs.fromByteArray((byte[])this.getDynamic(WITNESS_ALLOWANCE_FROZEN_TIME).getData());
        }
        byte[] result = new byte[8];
        System.arraycopy(frozenTime, 0, result, 8 - frozenTime.length, frozenTime.length);
        return Longs.fromByteArray((byte[])result);
    }

    @Override
    public long getMaintenanceTimeInterval() {
        return Longs.fromByteArray((byte[])this.getDynamic(MAINTENANCE_TIME_INTERVAL).getData());
    }

    @Override
    public long getNextMaintenanceTime() {
        return Longs.fromByteArray((byte[])this.getDynamic(NEXT_MAINTENANCE_TIME).getData());
    }

    @Override
    public BytesCapsule getDynamic(byte[] word) {
        BytesCapsule bytesCapsule;
        Key key = Key.create(word);
        if (this.dynamicPropertiesCache.containsKey(key)) {
            return this.dynamicPropertiesCache.get(key).getDynamicProperties();
        }
        if (this.parent != null) {
            bytesCapsule = this.parent.getDynamic(word);
        } else {
            try {
                bytesCapsule = (BytesCapsule)this.getDynamicPropertiesStore().get(word);
            }
            catch (BadItemException | ItemNotFoundException e) {
                logger.warn("Not found dynamic property:" + Strings.fromUTF8ByteArray((byte[])word));
                bytesCapsule = null;
            }
        }
        if (bytesCapsule != null) {
            this.dynamicPropertiesCache.put(key, Value.create(bytesCapsule.getData()));
        }
        return bytesCapsule;
    }

    private void commitAccountCache(Deposit deposit) {
        this.accountCache.forEach((key, value) -> {
            if (value.getType().isCreate() || value.getType().isDirty()) {
                if (deposit != null) {
                    deposit.putAccount((Key)key, (Value)value);
                } else {
                    this.getAccountStore().put(key.getData(), value.getAccount());
                }
            }
        });
    }

    private void commitTransactionCache(Deposit deposit) {
        this.transactionCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putTransaction((Key)key, (Value)value);
                } else {
                    this.getTransactionStore().put(key.getData(), value.getTransaction());
                }
            }
        });
    }

    private void commitBlockCache(Deposit deposit) {
        this.blockCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putBlock((Key)key, (Value)value);
                } else {
                    this.getBlockStore().put(key.getData(), value.getBlock());
                }
            }
        });
    }

    private void commitWitnessCache(Deposit deposit) {
        this.witnessCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putWitness((Key)key, (Value)value);
                } else {
                    this.getWitnessStore().put(key.getData(), value.getWitness());
                }
            }
        });
    }

    private void commitCodeCache(Deposit deposit) {
        this.codeCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putCode((Key)key, (Value)value);
                } else {
                    this.getCodeStore().put(key.getData(), value.getCode());
                }
            }
        });
    }

    private void commitContractCache(Deposit deposit) {
        this.contractCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putContract((Key)key, (Value)value);
                } else {
                    this.getContractStore().put(key.getData(), value.getContract());
                }
            }
        });
    }

    private void commitStorageCache(Deposit deposit) {
        this.storageCache.forEach((address, storage) -> {
            if (deposit != null) {
                deposit.putStorage((Key)address, (Storage)storage);
            } else {
                storage.commit();
            }
        });
    }

    private void commitVoteCache(Deposit deposit) {
        this.votesCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putVotes((Key)key, (Value)value);
                } else {
                    this.getVotesStore().put(key.getData(), value.getVotes());
                }
            }
        });
    }

    private void commitProposalCache(Deposit deposit) {
        this.proposalCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putProposal((Key)key, (Value)value);
                } else {
                    this.getProposalStore().put(key.getData(), value.getProposal());
                }
            }
        });
    }

    private void commitDynamicPropertiesCache(Deposit deposit) {
        this.dynamicPropertiesCache.forEach((key, value) -> {
            if (value.getType().isDirty() || value.getType().isCreate()) {
                if (deposit != null) {
                    deposit.putDynamicProperties((Key)key, (Value)value);
                } else {
                    this.getDynamicPropertiesStore().put(key.getData(), value.getDynamicProperties());
                }
            }
        });
    }

    @Override
    public void putAccountValue(byte[] address, AccountCapsule accountCapsule) {
        Key key = new Key(address);
        this.accountCache.put(key, new Value(accountCapsule.getData(), Type.VALUE_TYPE_CREATE));
    }

    @Override
    public void putVoteValue(byte[] address, VotesCapsule votesCapsule) {
        Key key = new Key(address);
        this.votesCache.put(key, new Value(votesCapsule.getData(), Type.VALUE_TYPE_CREATE));
    }

    @Override
    public void putProposalValue(byte[] address, ProposalCapsule proposalCapsule) {
        Key key = new Key(address);
        this.proposalCache.put(key, new Value(proposalCapsule.getData(), Type.VALUE_TYPE_CREATE));
    }

    @Override
    public void putDynamicPropertiesWithLatestProposalNum(long num) {
        Key key = new Key(LATEST_PROPOSAL_NUM);
        this.dynamicPropertiesCache.put(key, new Value(new BytesCapsule(ByteArray.fromLong(num)).getData(), Type.VALUE_TYPE_CREATE));
    }

    @Override
    public synchronized void commit() {
        Deposit deposit = null;
        if (this.parent != null) {
            deposit = this.parent;
        }
        this.commitAccountCache(deposit);
        this.commitTransactionCache(deposit);
        this.commitBlockCache(deposit);
        this.commitWitnessCache(deposit);
        this.commitCodeCache(deposit);
        this.commitContractCache(deposit);
        this.commitStorageCache(deposit);
        this.commitVoteCache(deposit);
        this.commitProposalCache(deposit);
        this.commitDynamicPropertiesCache(deposit);
    }

    @Override
    public void setParent(Deposit deposit) {
        this.parent = deposit;
    }

    public static DepositImpl createRoot(Manager dbManager) {
        return new DepositImpl(dbManager, null);
    }
}

