/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program.invoke;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.runtime.vm.program.Program;
import org.tron.common.runtime.vm.program.invoke.ProgramInvoke;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactory;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeImpl;
import org.tron.common.storage.Deposit;
import org.tron.common.utils.ByteUtil;
import org.tron.core.Wallet;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component(value="ProgramInvokeFactory")
public class ProgramInvokeFactoryImpl
implements ProgramInvokeFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"vm");

    @Override
    public ProgramInvoke createProgramInvoke(InternalTransaction.TrxType trxType, InternalTransaction.ExecutorType executorType, Protocol.Transaction tx, long tokenValue, long tokenId, Protocol.Block block, Deposit deposit, long vmStartInUs, long vmShouldEndInUs, long energyLimit) throws ContractValidateException {
        byte[] lastHash = null;
        byte[] coinbase = null;
        long timestamp = 0L;
        long number = -1L;
        if (trxType == InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE) {
            Contract.CreateSmartContract contract = ContractCapsule.getSmartContractFromTransaction(tx);
            byte[] contractAddress = Wallet.generateContractAddress(tx);
            byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
            long balance = deposit.getBalance(ownerAddress);
            byte[] data = ByteUtil.EMPTY_BYTE_ARRAY;
            long callValue = contract.getNewContract().getCallValue();
            switch (executorType) {
                case ET_NORMAL_TYPE: 
                case ET_PRE_TYPE: {
                    if (null == block) break;
                    lastHash = block.getBlockHeader().getRawDataOrBuilder().getParentHash().toByteArray();
                    coinbase = block.getBlockHeader().getRawDataOrBuilder().getWitnessAddress().toByteArray();
                    timestamp = block.getBlockHeader().getRawDataOrBuilder().getTimestamp() / 1000L;
                    number = block.getBlockHeader().getRawDataOrBuilder().getNumber();
                    break;
                }
            }
            return new ProgramInvokeImpl(contractAddress, ownerAddress, ownerAddress, balance, callValue, tokenValue, tokenId, data, lastHash, coinbase, timestamp, number, deposit, vmStartInUs, vmShouldEndInUs, energyLimit);
        }
        if (trxType == InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE) {
            Contract.TriggerSmartContract contract = ContractCapsule.getTriggerContractFromTransaction(tx);
            byte[] address = contract.getContractAddress().toByteArray();
            byte[] origin = contract.getOwnerAddress().toByteArray();
            byte[] caller = contract.getOwnerAddress().toByteArray();
            long balance = deposit.getBalance(caller);
            long callValue = contract.getCallValue();
            byte[] data = contract.getData().toByteArray();
            switch (executorType) {
                case ET_CONSTANT_TYPE: {
                    break;
                }
                case ET_NORMAL_TYPE: 
                case ET_PRE_TYPE: {
                    if (null == block) break;
                    lastHash = block.getBlockHeader().getRawDataOrBuilder().getParentHash().toByteArray();
                    coinbase = block.getBlockHeader().getRawDataOrBuilder().getWitnessAddress().toByteArray();
                    timestamp = block.getBlockHeader().getRawDataOrBuilder().getTimestamp() / 1000L;
                    number = block.getBlockHeader().getRawDataOrBuilder().getNumber();
                    break;
                }
            }
            return new ProgramInvokeImpl(address, origin, caller, balance, callValue, tokenValue, tokenId, data, lastHash, coinbase, timestamp, number, deposit, vmStartInUs, vmShouldEndInUs, energyLimit);
        }
        throw new ContractValidateException("Unknown contract type");
    }

    @Override
    public ProgramInvoke createProgramInvoke(Program program, DataWord toAddress, DataWord callerAddress, DataWord inValue, DataWord tokenValue, DataWord tokenId, long balanceInt, byte[] dataIn, Deposit deposit, boolean isStaticCall, boolean byTestingSuite, long vmStartInUs, long vmShouldEndInUs, long energyLimit) {
        DataWord address = toAddress;
        DataWord origin = program.getOriginAddress();
        DataWord caller = callerAddress;
        DataWord balance = new DataWord(balanceInt);
        DataWord callValue = inValue;
        byte[] data = dataIn;
        DataWord lastHash = program.getPrevHash();
        DataWord coinbase = program.getCoinbase();
        DataWord timestamp = program.getTimestamp();
        DataWord number = program.getNumber();
        DataWord difficulty = program.getDifficulty();
        return new ProgramInvokeImpl(address, origin, caller, balance, callValue, tokenValue, tokenId, data, lastHash, coinbase, timestamp, number, difficulty, deposit, program.getCallDeep() + 1, isStaticCall, byTestingSuite, vmStartInUs, vmShouldEndInUs, energyLimit);
    }
}

