/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.tron.common.runtime.vm.CallCreate;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.utils.ByteArraySet;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.TransactionResultCapsule;

public class ProgramResult {
    private long energyUsed = 0L;
    private long futureRefund = 0L;
    private byte[] hReturn = ByteUtil.EMPTY_BYTE_ARRAY;
    private byte[] contractAddress = ByteUtil.EMPTY_BYTE_ARRAY;
    private RuntimeException exception;
    private boolean revert;
    private Set<DataWord> deleteAccounts;
    private ByteArraySet touchedAccounts = new ByteArraySet();
    private List<InternalTransaction> internalTransactions;
    private List<LogInfo> logInfoList;
    private TransactionResultCapsule ret = new TransactionResultCapsule();
    private List<CallCreate> callCreateList;

    public void spendEnergy(long energy) {
        this.energyUsed += energy;
    }

    public void setRevert() {
        this.revert = true;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public void refundEnergy(long energy) {
        this.energyUsed -= energy;
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = Arrays.copyOf(contractAddress, contractAddress.length);
    }

    public byte[] getContractAddress() {
        return Arrays.copyOf(this.contractAddress, this.contractAddress.length);
    }

    public void setHReturn(byte[] hReturn) {
        this.hReturn = hReturn;
    }

    public byte[] getHReturn() {
        return this.hReturn;
    }

    public TransactionResultCapsule getRet() {
        return this.ret;
    }

    public void setRet(TransactionResultCapsule ret) {
        this.ret = ret;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public long getEnergyUsed() {
        return this.energyUsed;
    }

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    public Set<DataWord> getDeleteAccounts() {
        if (this.deleteAccounts == null) {
            this.deleteAccounts = new HashSet<DataWord>();
        }
        return this.deleteAccounts;
    }

    public void addDeleteAccount(DataWord address) {
        this.getDeleteAccounts().add(address);
    }

    public void addDeleteAccounts(Set<DataWord> accounts) {
        if (!CollectionUtils.isEmpty(accounts)) {
            this.getDeleteAccounts().addAll(accounts);
        }
    }

    public void addTouchAccount(byte[] addr) {
        this.touchedAccounts.add(addr);
    }

    public Set<byte[]> getTouchedAccounts() {
        return this.touchedAccounts;
    }

    public void addTouchAccounts(Set<byte[]> accounts) {
        if (!CollectionUtils.isEmpty(accounts)) {
            this.getTouchedAccounts().addAll(accounts);
        }
    }

    public List<LogInfo> getLogInfoList() {
        if (this.logInfoList == null) {
            this.logInfoList = new ArrayList<LogInfo>();
        }
        return this.logInfoList;
    }

    public void addLogInfo(LogInfo logInfo) {
        this.getLogInfoList().add(logInfo);
    }

    public void addLogInfos(List<LogInfo> logInfos) {
        if (!CollectionUtils.isEmpty(logInfos)) {
            this.getLogInfoList().addAll(logInfos);
        }
    }

    public List<CallCreate> getCallCreateList() {
        if (this.callCreateList == null) {
            this.callCreateList = new ArrayList<CallCreate>();
        }
        return this.callCreateList;
    }

    public void addCallCreate(byte[] data, byte[] destination, byte[] energyLimit, byte[] value) {
        this.getCallCreateList().add(new CallCreate(data, destination, energyLimit, value));
    }

    public List<InternalTransaction> getInternalTransactions() {
        if (this.internalTransactions == null) {
            this.internalTransactions = new ArrayList<InternalTransaction>();
        }
        return this.internalTransactions;
    }

    public InternalTransaction addInternalTransaction(byte[] parentHash, int deep, byte[] senderAddress, byte[] transferAddress, long value, byte[] data, String note, long nonce, Map<String, Long> token) {
        InternalTransaction transaction = new InternalTransaction(parentHash, deep, CollectionUtils.size(this.internalTransactions), senderAddress, transferAddress, value, data, note, nonce, token);
        this.getInternalTransactions().add(transaction);
        return transaction;
    }

    public void addInternalTransaction(InternalTransaction internalTransaction) {
        this.getInternalTransactions().add(internalTransaction);
    }

    public void addInternalTransactions(List<InternalTransaction> internalTransactions) {
        this.getInternalTransactions().addAll(internalTransactions);
    }

    public void rejectInternalTransactions() {
        for (InternalTransaction internalTx : this.getInternalTransactions()) {
            internalTx.reject();
        }
    }

    public void addFutureRefund(long energyValue) {
        this.futureRefund += energyValue;
    }

    public long getFutureRefund() {
        return this.futureRefund;
    }

    public void resetFutureRefund() {
        this.futureRefund = 0L;
    }

    public void reset() {
        this.getDeleteAccounts().clear();
        this.getLogInfoList().clear();
        this.resetFutureRefund();
    }

    public void merge(ProgramResult another) {
        this.addInternalTransactions(another.getInternalTransactions());
        if (another.getException() == null && !another.isRevert()) {
            this.addDeleteAccounts(another.getDeleteAccounts());
            this.addLogInfos(another.getLogInfoList());
            this.addFutureRefund(another.getFutureRefund());
            this.addTouchAccounts(another.getTouchedAccounts());
        }
    }

    public static ProgramResult createEmpty() {
        ProgramResult result = new ProgramResult();
        result.setHReturn(ByteUtil.EMPTY_BYTE_ARRAY);
        return result;
    }
}

