/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.runtime.config.VMConfig;
import org.tron.common.runtime.utils.MUtil;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.EnergyCost;
import org.tron.common.runtime.vm.MessageCall;
import org.tron.common.runtime.vm.OpCode;
import org.tron.common.runtime.vm.PrecompiledContracts;
import org.tron.common.runtime.vm.VM;
import org.tron.common.runtime.vm.program.ContractState;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.runtime.vm.program.Memory;
import org.tron.common.runtime.vm.program.ProgramPrecompile;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.common.runtime.vm.program.Stack;
import org.tron.common.runtime.vm.program.invoke.ProgramInvoke;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactory;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactoryImpl;
import org.tron.common.runtime.vm.program.listener.CompositeProgramListener;
import org.tron.common.runtime.vm.program.listener.ProgramListenerAware;
import org.tron.common.runtime.vm.program.listener.ProgramStorageChangeListener;
import org.tron.common.runtime.vm.trace.ProgramTrace;
import org.tron.common.runtime.vm.trace.ProgramTraceListener;
import org.tron.common.storage.Deposit;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.FastByteComparisons;
import org.tron.common.utils.Utils;
import org.tron.core.Wallet;
import org.tron.core.actuator.TransferActuator;
import org.tron.core.actuator.TransferAssetActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TronException;
import org.tron.protos.Protocol;

public class Program {
    private static final Logger logger = LoggerFactory.getLogger((String)"Program");
    private static final int MAX_DEPTH = 64;
    private static final int MAX_STACK_SIZE = 1024;
    private BlockCapsule blockCap;
    private long nonce;
    private byte[] rootTransactionId;
    private Boolean isRootCallConstant;
    private InternalTransaction internalTransaction;
    private ProgramInvoke invoke;
    private ProgramInvokeFactory programInvokeFactory = new ProgramInvokeFactoryImpl();
    private ProgramOutListener listener;
    private ProgramTraceListener traceListener;
    private ProgramStorageChangeListener storageDiffListener = new ProgramStorageChangeListener();
    private CompositeProgramListener programListener = new CompositeProgramListener();
    private Stack stack;
    private Memory memory;
    private ContractState contractState;
    private byte[] returnDataBuffer;
    private ProgramResult result = new ProgramResult();
    private ProgramTrace trace = new ProgramTrace();
    private byte[] ops;
    private int pc;
    private byte lastOp;
    private byte previouslyExecutedOp;
    private boolean stopped;
    private ProgramPrecompile programPrecompile;
    private final VMConfig config;

    public Program(byte[] ops, ProgramInvoke programInvoke) {
        this(ops, programInvoke, null);
    }

    public Program(byte[] ops, ProgramInvoke programInvoke, InternalTransaction internalTransaction) {
        this(ops, programInvoke, internalTransaction, VMConfig.getInstance(), null);
    }

    public Program(byte[] ops, ProgramInvoke programInvoke, InternalTransaction internalTransaction, VMConfig config, BlockCapsule blockCap) {
        this.config = config;
        this.invoke = programInvoke;
        this.internalTransaction = internalTransaction;
        this.blockCap = blockCap;
        this.ops = ArrayUtils.nullToEmpty((byte[])ops);
        this.traceListener = new ProgramTraceListener(config.vmTrace());
        this.memory = this.setupProgramListener(new Memory());
        this.stack = this.setupProgramListener(new Stack());
        this.contractState = this.setupProgramListener(new ContractState(programInvoke));
        this.trace = new ProgramTrace(config, programInvoke);
        this.nonce = internalTransaction.getNonce();
    }

    public byte[] getRootTransactionId() {
        return (byte[])this.rootTransactionId.clone();
    }

    public void setRootTransactionId(byte[] rootTransactionId) {
        this.rootTransactionId = (byte[])rootTransactionId.clone();
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long nonceValue) {
        this.nonce = nonceValue;
    }

    public Boolean getRootCallConstant() {
        return this.isRootCallConstant;
    }

    public void setRootCallConstant(Boolean rootCallConstant) {
        this.isRootCallConstant = rootCallConstant;
    }

    public ProgramPrecompile getProgramPrecompile() {
        if (this.programPrecompile == null) {
            this.programPrecompile = ProgramPrecompile.compile(this.ops);
        }
        return this.programPrecompile;
    }

    public int getCallDeep() {
        return this.invoke.getCallDeep();
    }

    private InternalTransaction addInternalTx(DataWord energyLimit, byte[] senderAddress, byte[] transferAddress, long value, byte[] data, String note, long nonce, Map<String, Long> tokenInfo) {
        InternalTransaction addedInternalTx = null;
        if (this.internalTransaction != null) {
            addedInternalTx = this.getResult().addInternalTransaction(this.internalTransaction.getHash(), this.getCallDeep(), senderAddress, transferAddress, value, data, note, nonce, tokenInfo);
        }
        return addedInternalTx;
    }

    private <T extends ProgramListenerAware> T setupProgramListener(T programListenerAware) {
        if (this.programListener.isEmpty()) {
            this.programListener.addListener(this.traceListener);
            this.programListener.addListener(this.storageDiffListener);
        }
        programListenerAware.setProgramListener(this.programListener);
        return programListenerAware;
    }

    public Map<DataWord, DataWord> getStorageDiff() {
        return this.storageDiffListener.getDiff();
    }

    public byte getOp(int pc) {
        return ArrayUtils.getLength((Object)this.ops) <= pc ? (byte)0 : this.ops[pc];
    }

    public byte getCurrentOp() {
        return ArrayUtils.isEmpty((byte[])this.ops) ? (byte)0 : this.ops[this.pc];
    }

    public void setLastOp(byte op) {
        this.lastOp = op;
    }

    public void setPreviouslyExecutedOp(byte op) {
        this.previouslyExecutedOp = op;
    }

    public byte getPreviouslyExecutedOp() {
        return this.previouslyExecutedOp;
    }

    public void stackPush(byte[] data) {
        this.stackPush(new DataWord(data));
    }

    public void stackPushZero() {
        this.stackPush(new DataWord(0));
    }

    public void stackPushOne() {
        DataWord stackWord = new DataWord(1);
        this.stackPush(stackWord);
    }

    public void stackPush(DataWord stackWord) {
        this.verifyStackOverflow(0, 1);
        this.stack.push(stackWord);
    }

    public Stack getStack() {
        return this.stack;
    }

    public int getPC() {
        return this.pc;
    }

    public void setPC(DataWord pc) {
        this.setPC(pc.intValue());
    }

    public void setPC(int pc) {
        this.pc = pc;
        if (this.pc >= this.ops.length) {
            this.stop();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public void setHReturn(byte[] buff) {
        this.getResult().setHReturn(buff);
    }

    public void step() {
        this.setPC(this.pc + 1);
    }

    public byte[] sweep(int n) {
        if (this.pc + n > this.ops.length) {
            this.stop();
        }
        byte[] data = Arrays.copyOfRange(this.ops, this.pc, this.pc + n);
        this.pc += n;
        if (this.pc >= this.ops.length) {
            this.stop();
        }
        return data;
    }

    public DataWord stackPop() {
        return this.stack.pop();
    }

    public void verifyStackSize(int stackSize) {
        if (this.stack.size() < stackSize) {
            throw Exception.tooSmallStack(stackSize, this.stack.size());
        }
    }

    public void verifyStackOverflow(int argsReqs, int returnReqs) {
        if (this.stack.size() - argsReqs + returnReqs > 1024) {
            throw new StackTooLargeException("Expected: overflow 1024 elements stack limit");
        }
    }

    public int getMemSize() {
        return this.memory.size();
    }

    public void memorySave(DataWord addrB, DataWord value) {
        this.memory.write(addrB.intValue(), value.getData(), value.getData().length, false);
    }

    public void memorySaveLimited(int addr, byte[] data, int dataSize) {
        this.memory.write(addr, data, dataSize, true);
    }

    public void memorySave(int addr, byte[] value) {
        this.memory.write(addr, value, value.length, false);
    }

    public void memoryExpand(DataWord outDataOffs, DataWord outDataSize) {
        if (!outDataSize.isZero()) {
            this.memory.extend(outDataOffs.intValue(), outDataSize.intValue());
        }
    }

    public void memorySave(int addr, int allocSize, byte[] value) {
        this.memory.extendAndWrite(addr, allocSize, value);
    }

    public DataWord memoryLoad(DataWord addr) {
        return this.memory.readWord(addr.intValue());
    }

    public DataWord memoryLoad(int address) {
        return this.memory.readWord(address);
    }

    public byte[] memoryChunk(int offset, int size) {
        return this.memory.read(offset, size);
    }

    public void allocateMemory(int offset, int size) {
        this.memory.extend(offset, size);
    }

    public void suicide(DataWord obtainerAddress) {
        byte[] owner = MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes());
        byte[] obtainer = MUtil.convertToTronAddress(obtainerAddress.getLast20Bytes());
        long balance = this.getContractState().getBalance(owner);
        if (logger.isDebugEnabled()) {
            logger.debug("Transfer to: [{}] heritage: [{}]", (Object)Hex.toHexString((byte[])obtainer), (Object)balance);
        }
        this.increaseNonce();
        this.addInternalTx(null, owner, obtainer, balance, null, "suicide", this.nonce, this.getContractState().getAccount(owner).getAssetMapV2());
        if (FastByteComparisons.compareTo(owner, 0, 20, obtainer, 0, 20) == 0) {
            this.getContractState().addBalance(owner, -balance);
            byte[] blackHoleAddress = this.getContractState().getBlackHoleAddress();
            if (VMConfig.allowTvmTransferTrc10()) {
                this.getContractState().addBalance(blackHoleAddress, balance);
                MUtil.transferAllToken(this.getContractState(), owner, blackHoleAddress);
            }
        } else {
            try {
                MUtil.transfer(this.getContractState(), owner, obtainer, balance);
                if (VMConfig.allowTvmTransferTrc10()) {
                    MUtil.transferAllToken(this.getContractState(), owner, obtainer);
                }
            }
            catch (ContractValidateException e) {
                throw new BytecodeExecutionException("transfer failure");
            }
        }
        this.getResult().addDeleteAccount(this.getContractAddress());
    }

    public Deposit getContractState() {
        return this.contractState;
    }

    public void createContract(DataWord value, DataWord memStart, DataWord memSize) {
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            return;
        }
        byte[] senderAddress = MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes());
        long endowment = value.value().longValueExact();
        if (this.getContractState().getBalance(senderAddress) < endowment) {
            this.stackPushZero();
            return;
        }
        byte[] programCode = this.memoryChunk(memStart.intValue(), memSize.intValue());
        if (logger.isDebugEnabled()) {
            logger.debug("creating a new contract inside contract run: [{}]", (Object)Hex.toHexString((byte[])senderAddress));
        }
        byte[] newAddress = Wallet.generateContractAddress(this.rootTransactionId, this.nonce);
        AccountCapsule existingAddr = this.getContractState().getAccount(newAddress);
        boolean contractAlreadyExists = existingAddr != null;
        Deposit deposit = this.getContractState().newDepositChild();
        long oldBalance = deposit.getBalance(newAddress);
        Protocol.SmartContract newSmartContract = Protocol.SmartContract.newBuilder().setContractAddress(ByteString.copyFrom((byte[])newAddress)).setConsumeUserResourcePercent(100L).setOriginAddress(ByteString.copyFrom((byte[])senderAddress)).build();
        deposit.createContract(newAddress, new ContractCapsule(newSmartContract));
        deposit.createAccount(newAddress, "CreatedByContract", Protocol.AccountType.Contract);
        deposit.addBalance(newAddress, oldBalance);
        long newBalance = 0L;
        if (!this.byTestingSuite() && endowment > 0L) {
            try {
                TransferActuator.validateForSmartContract(deposit, senderAddress, newAddress, endowment);
            }
            catch (ContractValidateException e) {
                throw new BytecodeExecutionException("validateForSmartContract failure");
            }
            deposit.addBalance(senderAddress, -endowment);
            newBalance = deposit.addBalance(newAddress, endowment);
        }
        DataWord energyLimit = this.getCreateEnergy(this.getEnergyLimitLeft());
        this.spendEnergy(energyLimit.longValue(), "internal call");
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, senderAddress, newAddress, endowment, programCode, "create", this.nonce, null);
        long vmStartInUs = System.nanoTime() / 1000L;
        ProgramInvoke programInvoke = this.programInvokeFactory.createProgramInvoke(this, new DataWord(newAddress), this.getContractAddress(), value, new DataWord(0), new DataWord(0), newBalance, null, deposit, false, this.byTestingSuite(), vmStartInUs, this.getVmShouldEndInUs(), energyLimit.longValueSafe());
        ProgramResult createResult = ProgramResult.createEmpty();
        if (contractAlreadyExists) {
            createResult.setException(new BytecodeExecutionException("Trying to create a contract with existing contract address: 0x" + Hex.toHexString((byte[])newAddress)));
        } else if (ArrayUtils.isNotEmpty((byte[])programCode)) {
            VM vm = new VM(this.config);
            Program program = new Program(programCode, programInvoke, internalTx, this.config, this.blockCap);
            program.setRootTransactionId(this.rootTransactionId);
            program.setRootCallConstant(this.isRootCallConstant);
            vm.play(program);
            createResult = program.getResult();
            this.getTrace().merge(program.getTrace());
            this.nonce = program.nonce;
        }
        byte[] code2 = createResult.getHReturn();
        long saveCodeEnergy = (long)ArrayUtils.getLength((Object)code2) * (long)EnergyCost.getInstance().getCREATE_DATA();
        long afterSpend = programInvoke.getEnergyLimit() - createResult.getEnergyUsed() - saveCodeEnergy;
        if (!createResult.isRevert()) {
            if (afterSpend < 0L) {
                createResult.setException(Exception.notEnoughSpendEnergy("No energy to save just created contract code", saveCodeEnergy, programInvoke.getEnergyLimit() - createResult.getEnergyUsed()));
            } else {
                createResult.spendEnergy(saveCodeEnergy);
                deposit.saveCode(newAddress, code2);
            }
        }
        this.getResult().merge(createResult);
        if (createResult.getException() != null || createResult.isRevert()) {
            logger.debug("contract run halted by Exception: contract: [{}], exception: [{}]", (Object)Hex.toHexString((byte[])newAddress), (Object)createResult.getException());
            internalTx.reject();
            createResult.rejectInternalTransactions();
            this.stackPushZero();
            if (createResult.getException() != null) {
                return;
            }
            this.returnDataBuffer = createResult.getHReturn();
        } else {
            if (!this.byTestingSuite()) {
                deposit.commit();
            }
            this.stackPush(new DataWord(newAddress));
        }
        this.refundEnergyAfterVM(energyLimit, createResult);
    }

    public void refundEnergyAfterVM(DataWord energyLimit, ProgramResult result) {
        long refundEnergy = energyLimit.longValueSafe() - result.getEnergyUsed();
        if (refundEnergy > 0L) {
            this.refundEnergy(refundEnergy, "remain energy from the internal call");
            if (logger.isDebugEnabled()) {
                logger.debug("The remaining energy is refunded, account: [{}], energy: [{}] ", (Object)Hex.toHexString((byte[])MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes())), (Object)refundEnergy);
            }
        }
    }

    public void callToAddress(MessageCall msg) {
        AccountCapsule accountCapsule;
        long senderBalance;
        byte[] contextAddress;
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), " call deep limit reach");
            return;
        }
        byte[] data = this.memoryChunk(msg.getInDataOffs().intValue(), msg.getInDataSize().intValue());
        byte[] codeAddress = MUtil.convertToTronAddress(msg.getCodeAddress().getLast20Bytes());
        byte[] senderAddress = MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes());
        byte[] byArray = contextAddress = msg.getType().callIsStateless() ? senderAddress : codeAddress;
        if (logger.isDebugEnabled()) {
            logger.debug(msg.getType().name() + " for existing contract: address: [{}], outDataOffs: [{}], outDataSize: [{}]  ", new Object[]{Hex.toHexString((byte[])contextAddress), msg.getOutDataOffs().longValue(), msg.getOutDataSize().longValue()});
        }
        Deposit deposit = this.getContractState().newDepositChild();
        long endowment = msg.getEndowment().value().longValueExact();
        byte[] tokenId = null;
        if (msg.getTokenId().longValue() == 0L) {
            senderBalance = deposit.getBalance(senderAddress);
            if (senderBalance < endowment) {
                this.stackPushZero();
                this.refundEnergy(msg.getEnergy().longValue(), "refund energy from message call");
                return;
            }
        } else {
            tokenId = String.valueOf(msg.getTokenId().longValue()).getBytes();
            senderBalance = deposit.getTokenBalance(senderAddress, tokenId);
            if (senderBalance < endowment) {
                this.stackPushZero();
                this.refundEnergy(msg.getEnergy().longValue(), "refund energy from message call");
                return;
            }
        }
        byte[] programCode = (accountCapsule = this.getContractState().getAccount(codeAddress)) != null ? this.getContractState().getCode(codeAddress) : ArrayUtils.EMPTY_BYTE_ARRAY;
        long contextBalance = 0L;
        if (this.byTestingSuite()) {
            this.getResult().addCallCreate(data, contextAddress, msg.getEnergy().getNoLeadZeroesData(), msg.getEndowment().getNoLeadZeroesData());
        } else if (!ArrayUtils.isEmpty((byte[])senderAddress) && !ArrayUtils.isEmpty((byte[])contextAddress) && senderAddress != contextAddress && endowment > 0L) {
            if (msg.getTokenId().longValue() == 0L) {
                try {
                    TransferActuator.validateForSmartContract(deposit, senderAddress, contextAddress, endowment);
                }
                catch (ContractValidateException e) {
                    throw new BytecodeExecutionException("validateForSmartContract failure");
                }
                deposit.addBalance(senderAddress, -endowment);
                contextBalance = deposit.addBalance(contextAddress, endowment);
            } else {
                try {
                    TransferAssetActuator.validateForSmartContract(deposit, senderAddress, contextAddress, tokenId, endowment);
                }
                catch (ContractValidateException e) {
                    throw new BytecodeExecutionException("validateForSmartContract failure");
                }
                deposit.addTokenBalance(senderAddress, tokenId, -endowment);
                deposit.addTokenBalance(contextAddress, tokenId, endowment);
            }
        }
        this.increaseNonce();
        HashMap<String, Long> tokenInfo = new HashMap<String, Long>();
        if (msg.getTokenId().longValue() != 0L) {
            tokenInfo.put(new String(ByteUtil.stripLeadingZeroes(tokenId)), endowment);
        }
        InternalTransaction internalTx = this.addInternalTx(null, senderAddress, contextAddress, msg.getTokenId().longValue() == 0L ? endowment : 0L, data, "call", this.nonce, msg.getTokenId().longValue() == 0L ? null : tokenInfo);
        ProgramResult callResult = null;
        if (ArrayUtils.isNotEmpty((byte[])programCode)) {
            long vmStartInUs = System.nanoTime() / 1000L;
            DataWord callValue = msg.getType().callIsDelegate() ? this.getCallValue() : msg.getEndowment();
            ProgramInvoke programInvoke = this.programInvokeFactory.createProgramInvoke(this, new DataWord(contextAddress), msg.getType().callIsDelegate() ? this.getCallerAddress() : this.getContractAddress(), msg.getTokenId().longValue() == 0L ? callValue : new DataWord(0), msg.getTokenId().longValue() == 0L ? new DataWord(0) : callValue, msg.getTokenId().longValue() == 0L ? new DataWord(0) : msg.getTokenId(), contextBalance, data, deposit, msg.getType().callIsStatic() || this.isStaticCall(), this.byTestingSuite(), vmStartInUs, this.getVmShouldEndInUs(), msg.getEnergy().longValueSafe());
            VM vm = new VM(this.config);
            Program program = new Program(programCode, programInvoke, internalTx, this.config, this.blockCap);
            program.setRootTransactionId(this.rootTransactionId);
            program.setRootCallConstant(this.isRootCallConstant);
            vm.play(program);
            callResult = program.getResult();
            this.getTrace().merge(program.getTrace());
            this.getResult().merge(callResult);
            this.nonce = program.nonce;
            if (callResult.getException() != null || callResult.isRevert()) {
                logger.debug("contract run halted by Exception: contract: [{}], exception: [{}]", (Object)Hex.toHexString((byte[])contextAddress), (Object)callResult.getException());
                internalTx.reject();
                callResult.rejectInternalTransactions();
                this.stackPushZero();
                if (callResult.getException() != null) {
                    return;
                }
            } else {
                deposit.commit();
                this.stackPushOne();
            }
            if (this.byTestingSuite()) {
                logger.debug("Testing run, skipping storage diff listener");
            }
        } else {
            deposit.commit();
            this.stackPushOne();
        }
        if (callResult != null) {
            byte[] buffer = callResult.getHReturn();
            int offset = msg.getOutDataOffs().intValue();
            int size = msg.getOutDataSize().intValue();
            this.memorySaveLimited(offset, buffer, size);
            this.returnDataBuffer = buffer;
        }
        if (callResult != null) {
            BigInteger refundEnergy = msg.getEnergy().value().subtract(BIUtil.toBI(callResult.getEnergyUsed()));
            if (BIUtil.isPositive(refundEnergy)) {
                this.refundEnergy(refundEnergy.longValueExact(), "remaining energy from the internal call");
                if (logger.isDebugEnabled()) {
                    logger.debug("The remaining energy refunded, account: [{}], energy: [{}] ", (Object)Hex.toHexString((byte[])senderAddress), (Object)refundEnergy.toString());
                }
            }
        } else {
            this.refundEnergy(msg.getEnergy().longValue(), "remaining esnergy from the internal call");
        }
    }

    public void increaseNonce() {
        ++this.nonce;
    }

    public void resetNonce() {
        this.nonce = 0L;
    }

    public void spendEnergy(long energyValue, String opName) {
        if (this.getEnergylimitLeftLong() < energyValue) {
            throw new OutOfEnergyException("Not enough energy for '%s' operation executing: curInvokeEnergyLimit[%d], curOpEnergy[%d], usedEnergy[%d]", opName, this.invoke.getEnergyLimit(), energyValue, this.getResult().getEnergyUsed());
        }
        this.getResult().spendEnergy(energyValue);
    }

    public void checkCPUTimeLimit(String opName) {
        if (Args.getInstance().isDebug()) {
            return;
        }
        if (Args.getInstance().isSolidityNode()) {
            return;
        }
        long vmNowInUs = System.nanoTime() / 1000L;
        if (vmNowInUs > this.getVmShouldEndInUs()) {
            logger.info("minTimeRatio: {}, maxTimeRatio: {}, vm should end time in us: {}, vm now time in us: {}, vm start time in us: {}", new Object[]{Args.getInstance().getMinTimeRatio(), Args.getInstance().getMaxTimeRatio(), this.getVmShouldEndInUs(), vmNowInUs, this.getVmStartInUs()});
            throw Exception.notEnoughTime(opName);
        }
    }

    public void spendAllEnergy() {
        this.spendEnergy(this.getEnergyLimitLeft().longValue(), "Spending all remaining");
    }

    public void refundEnergy(long energyValue, String cause) {
        logger.debug("[{}] Refund for cause: [{}], energy: [{}]", new Object[]{this.invoke.hashCode(), cause, energyValue});
        this.getResult().refundEnergy(energyValue);
    }

    public void futureRefundEnergy(long energyValue) {
        logger.debug("Future refund added: [{}]", (Object)energyValue);
        this.getResult().addFutureRefund(energyValue);
    }

    public void resetFutureRefund() {
        this.getResult().resetFutureRefund();
    }

    public void storageSave(DataWord word1, DataWord word2) {
        DataWord keyWord = word1.clone();
        DataWord valWord = word2.clone();
        this.getContractState().putStorageValue(MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes()), keyWord, valWord);
    }

    public byte[] getCode() {
        return (byte[])this.ops.clone();
    }

    public byte[] getCodeAt(DataWord address) {
        byte[] code2 = this.invoke.getDeposit().getCode(MUtil.convertToTronAddress(address.getLast20Bytes()));
        return ArrayUtils.nullToEmpty((byte[])code2);
    }

    public DataWord getContractAddress() {
        return this.invoke.getContractAddress().clone();
    }

    public DataWord getBlockHash(int index) {
        if ((long)index < this.getNumber().longValue() && (long)index >= Math.max(256L, this.getNumber().longValue()) - 256L) {
            BlockCapsule blockCapsule = this.invoke.getBlockByNum(index);
            if (Objects.nonNull(blockCapsule)) {
                return new DataWord(blockCapsule.getBlockId().getBytes());
            }
            return DataWord.ZERO.clone();
        }
        return DataWord.ZERO.clone();
    }

    public DataWord getBalance(DataWord address) {
        long balance = this.getContractState().getBalance(MUtil.convertToTronAddress(address.getLast20Bytes()));
        return new DataWord(balance);
    }

    public DataWord getOriginAddress() {
        return this.invoke.getOriginAddress().clone();
    }

    public DataWord getCallerAddress() {
        return this.invoke.getCallerAddress().clone();
    }

    public DataWord getDropPrice() {
        return new DataWord(1);
    }

    public long getEnergylimitLeftLong() {
        return this.invoke.getEnergyLimit() - this.getResult().getEnergyUsed();
    }

    public DataWord getEnergyLimitLeft() {
        return new DataWord(this.invoke.getEnergyLimit() - this.getResult().getEnergyUsed());
    }

    public long getVmShouldEndInUs() {
        return this.invoke.getVmShouldEndInUs();
    }

    public DataWord getCallValue() {
        return this.invoke.getCallValue().clone();
    }

    public DataWord getDataSize() {
        return this.invoke.getDataSize().clone();
    }

    public DataWord getDataValue(DataWord index) {
        return this.invoke.getDataValue(index);
    }

    public byte[] getDataCopy(DataWord offset, DataWord length) {
        return this.invoke.getDataCopy(offset, length);
    }

    public DataWord getReturnDataBufferSize() {
        return new DataWord(this.getReturnDataBufferSizeI());
    }

    private int getReturnDataBufferSizeI() {
        return this.returnDataBuffer == null ? 0 : this.returnDataBuffer.length;
    }

    public byte[] getReturnDataBufferData(DataWord off, DataWord size) {
        if ((long)off.intValueSafe() + (long)size.intValueSafe() > (long)this.getReturnDataBufferSizeI()) {
            return null;
        }
        return this.returnDataBuffer == null ? new byte[]{} : Arrays.copyOfRange(this.returnDataBuffer, off.intValueSafe(), off.intValueSafe() + size.intValueSafe());
    }

    public DataWord storageLoad(DataWord key) {
        DataWord ret = this.getContractState().getStorageValue(MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes()), key.clone());
        return ret == null ? null : ret.clone();
    }

    public DataWord getTokenBalance(DataWord address, DataWord tokenId) {
        long ret = this.getContractState().getTokenBalance(MUtil.convertToTronAddress(address.getLast20Bytes()), String.valueOf(tokenId.longValue()).getBytes());
        return ret == 0L ? new DataWord(0) : new DataWord(ret);
    }

    public DataWord getTokenValue() {
        return this.invoke.getTokenValue().clone();
    }

    public DataWord getTokenId() {
        return this.invoke.getTokenId().clone();
    }

    public DataWord getPrevHash() {
        return this.invoke.getPrevHash().clone();
    }

    public DataWord getCoinbase() {
        return this.invoke.getCoinbase().clone();
    }

    public DataWord getTimestamp() {
        return this.invoke.getTimestamp().clone();
    }

    public DataWord getNumber() {
        return this.invoke.getNumber().clone();
    }

    public DataWord getDifficulty() {
        return this.invoke.getDifficulty().clone();
    }

    public boolean isStaticCall() {
        return this.invoke.isStaticCall();
    }

    public ProgramResult getResult() {
        return this.result;
    }

    public void setRuntimeFailure(RuntimeException e) {
        this.getResult().setException(e);
    }

    public String memoryToString() {
        return this.memory.toString();
    }

    public void fullTrace() {
        if (logger.isTraceEnabled() || this.listener != null) {
            byte[] txData;
            StringBuilder stackData = new StringBuilder();
            for (int i = 0; i < this.stack.size(); ++i) {
                stackData.append(" ").append(this.stack.get(i));
                if (i >= this.stack.size() - 1) continue;
                stackData.append("\n");
            }
            if (stackData.length() > 0) {
                stackData.insert(0, "\n");
            }
            StringBuilder memoryData = new StringBuilder();
            StringBuilder oneLine = new StringBuilder();
            if (this.memory.size() > 320) {
                memoryData.append("... Memory Folded.... ").append("(").append(this.memory.size()).append(") bytes");
            } else {
                for (int i = 0; i < this.memory.size(); ++i) {
                    byte value = this.memory.readByte(i);
                    oneLine.append(ByteUtil.oneByteToHexString(value)).append(" ");
                    if ((i + 1) % 16 != 0) continue;
                    String tmp = String.format("[%4s]-[%4s]", Integer.toString(i - 15, 16), Integer.toString(i, 16)).replace(" ", "0");
                    memoryData.append("").append(tmp).append(" ");
                    memoryData.append((CharSequence)oneLine);
                    if (i < this.memory.size()) {
                        memoryData.append("\n");
                    }
                    oneLine.setLength(0);
                }
            }
            if (memoryData.length() > 0) {
                memoryData.insert(0, "\n");
            }
            StringBuilder opsString = new StringBuilder();
            for (int i = 0; i < this.ops.length; ++i) {
                String tmpString = Integer.toString(this.ops[i] & 0xFF, 16);
                String string = tmpString = tmpString.length() == 1 ? "0" + tmpString : tmpString;
                if (i != this.pc) {
                    opsString.append(tmpString);
                    continue;
                }
                opsString.append(" >>").append(tmpString).append("");
            }
            if (this.pc >= this.ops.length) {
                opsString.append(" >>");
            }
            if (opsString.length() > 0) {
                opsString.insert(0, "\n ");
            }
            logger.trace(" -- OPS --     {}", (Object)opsString);
            logger.trace(" -- STACK --   {}", (Object)stackData);
            logger.trace(" -- MEMORY --  {}", (Object)memoryData);
            logger.trace("\n  Spent Drop: [{}]/[{}]\n  Left Energy:  [{}]\n", new Object[]{this.getResult().getEnergyUsed(), this.invoke.getEnergyLimit(), this.getEnergyLimitLeft().longValue()});
            StringBuilder globalOutput = new StringBuilder("\n");
            if (stackData.length() > 0) {
                stackData.append("\n");
            }
            if (this.pc != 0) {
                globalOutput.append("[Op: ").append(OpCode.code(this.lastOp).name()).append("]\n");
            }
            globalOutput.append(" -- OPS --     ").append((CharSequence)opsString).append("\n");
            globalOutput.append(" -- STACK --   ").append((CharSequence)stackData).append("\n");
            globalOutput.append(" -- MEMORY --  ").append((CharSequence)memoryData).append("\n");
            if (this.getResult().getHReturn() != null) {
                globalOutput.append("\n  HReturn: ").append(Hex.toHexString((byte[])this.getResult().getHReturn()));
            }
            if (!Arrays.equals(txData = this.invoke.getDataCopy(DataWord.ZERO, this.getDataSize()), this.ops)) {
                globalOutput.append("\n  msg.data: ").append(Hex.toHexString((byte[])txData));
            }
            globalOutput.append("\n\n  Spent Energy: ").append(this.getResult().getEnergyUsed());
            if (this.listener != null) {
                this.listener.output(globalOutput.toString());
            }
        }
    }

    public void saveOpTrace() {
        if (this.pc < this.ops.length) {
            this.trace.addOp(this.ops[this.pc], this.pc, this.getCallDeep(), this.getEnergyLimitLeft(), this.traceListener.resetActions());
        }
    }

    public ProgramTrace getTrace() {
        return this.trace;
    }

    static String formatBinData(byte[] binData, int startPC) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < binData.length; i += 16) {
            ret.append(Utils.align("" + Integer.toHexString(startPC + i) + ":", ' ', 8, false));
            ret.append(Hex.toHexString((byte[])binData, (int)i, (int)StrictMath.min(16, binData.length - i))).append('\n');
        }
        return ret.toString();
    }

    public static String stringifyMultiline(byte[] code2) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        BitSet mask = Program.buildReachableBytecodesMask(code2);
        ByteArrayOutputStream binData = new ByteArrayOutputStream();
        int binDataStartPC = -1;
        while (index < code2.length) {
            byte opCode = code2[index];
            OpCode op = OpCode.code(opCode);
            if (!mask.get(index)) {
                if (binDataStartPC == -1) {
                    binDataStartPC = index;
                }
                binData.write(code2[index]);
                if (++index < code2.length) continue;
            }
            if (binDataStartPC != -1) {
                sb.append(Program.formatBinData(binData.toByteArray(), binDataStartPC));
                binDataStartPC = -1;
                binData = new ByteArrayOutputStream();
                if (index == code2.length) continue;
            }
            sb.append(Utils.align("" + Integer.toHexString(index) + ":", ' ', 8, false));
            if (op == null) {
                sb.append("<UNKNOWN>: ").append(0xFF & opCode).append("\n");
                ++index;
                continue;
            }
            if (op.name().startsWith("PUSH")) {
                sb.append(' ').append(op.name()).append(' ');
                int nPush = op.val() - OpCode.PUSH1.val() + 1;
                byte[] data = Arrays.copyOfRange(code2, index + 1, index + nPush + 1);
                BigInteger bi = new BigInteger(1, data);
                sb.append("0x").append(bi.toString(16));
                if (bi.bitLength() <= 32) {
                    sb.append(" (").append(new BigInteger(1, data).toString()).append(") ");
                }
                index += nPush + 1;
            } else {
                sb.append(' ').append(op.name());
                ++index;
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    static BitSet buildReachableBytecodesMask(byte[] code2) {
        TreeSet<Integer> gotos = new TreeSet<Integer>();
        ByteCodeIterator it = new ByteCodeIterator(code2);
        BitSet ret = new BitSet(code2.length);
        int lastPush = 0;
        int lastPushPC = 0;
        do {
            ret.set(it.getPC());
            if (it.isPush()) {
                lastPush = new BigInteger(1, it.getCurOpcodeArg()).intValue();
                lastPushPC = it.getPC();
            }
            if (it.getCurOpcode() == OpCode.JUMP || it.getCurOpcode() == OpCode.JUMPI) {
                if (it.getPC() != lastPushPC + 1) {
                    ret.set(0, code2.length);
                    return ret;
                }
                int jumpPC = lastPush;
                if (!ret.get(jumpPC)) {
                    gotos.add(jumpPC);
                }
            }
            if (it.getCurOpcode() != OpCode.JUMP && it.getCurOpcode() != OpCode.RETURN && it.getCurOpcode() != OpCode.STOP) continue;
            if (gotos.isEmpty()) break;
            it.setPC((Integer)gotos.pollFirst());
        } while (it.next());
        return ret;
    }

    public static String stringify(byte[] code2) {
        int index = 0;
        StringBuilder sb = new StringBuilder();
        while (index < code2.length) {
            byte opCode = code2[index];
            OpCode op = OpCode.code(opCode);
            if (op == null) {
                sb.append(" <UNKNOWN>: ").append(0xFF & opCode).append(" ");
                ++index;
                continue;
            }
            if (op.name().startsWith("PUSH")) {
                sb.append(' ').append(op.name()).append(' ');
                int nPush = op.val() - OpCode.PUSH1.val() + 1;
                byte[] data = Arrays.copyOfRange(code2, index + 1, index + nPush + 1);
                BigInteger bi = new BigInteger(1, data);
                sb.append("0x").append(bi.toString(16)).append(" ");
                index += nPush + 1;
                continue;
            }
            sb.append(' ').append(op.name());
            ++index;
        }
        return sb.toString();
    }

    public void addListener(ProgramOutListener listener) {
        this.listener = listener;
    }

    public int verifyJumpDest(DataWord nextPC) {
        if (nextPC.bytesOccupied() > 4) {
            throw Exception.badJumpDestination(-1);
        }
        int ret = nextPC.intValue();
        if (!this.getProgramPrecompile().hasJumpDest(ret)) {
            throw Exception.badJumpDestination(ret);
        }
        return ret;
    }

    public void callToPrecompiledAddress(MessageCall msg, PrecompiledContracts.PrecompiledContract contract) {
        long requiredEnergy;
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), " call deep limit reach");
            return;
        }
        Deposit deposit = this.getContractState().newDepositChild();
        byte[] senderAddress = MUtil.convertToTronAddress(this.getContractAddress().getLast20Bytes());
        byte[] codeAddress = MUtil.convertToTronAddress(msg.getCodeAddress().getLast20Bytes());
        byte[] contextAddress = msg.getType().callIsStateless() ? senderAddress : codeAddress;
        long endowment = msg.getEndowment().value().longValueExact();
        long senderBalance = 0L;
        byte[] tokenId = null;
        if (msg.getTokenId().longValue() == 0L) {
            senderBalance = deposit.getBalance(senderAddress);
        } else {
            tokenId = String.valueOf(msg.getTokenId().longValue()).getBytes();
            senderBalance = deposit.getTokenBalance(senderAddress, tokenId);
        }
        if (senderBalance < endowment) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), "refund energy from message call");
            return;
        }
        byte[] data = this.memoryChunk(msg.getInDataOffs().intValue(), msg.getInDataSize().intValue());
        if (!ArrayUtils.isEmpty((byte[])senderAddress) && !ArrayUtils.isEmpty((byte[])contextAddress) && senderAddress != contextAddress && msg.getEndowment().value().longValueExact() > 0L) {
            if (msg.getTokenId().longValue() == 0L) {
                try {
                    MUtil.transfer(deposit, senderAddress, contextAddress, msg.getEndowment().value().longValueExact());
                }
                catch (ContractValidateException e) {
                    throw new BytecodeExecutionException("transfer failure");
                }
            }
            try {
                TransferAssetActuator.validateForSmartContract(deposit, senderAddress, contextAddress, tokenId, endowment);
            }
            catch (ContractValidateException e) {
                throw new BytecodeExecutionException("validateForSmartContract failure");
            }
            deposit.addTokenBalance(senderAddress, tokenId, -endowment);
            deposit.addTokenBalance(contextAddress, tokenId, endowment);
        }
        if ((requiredEnergy = contract.getEnergyForData(data)) > msg.getEnergy().longValue()) {
            this.refundEnergy(0L, "call pre-compiled");
            this.stackPushZero();
        } else {
            contract.setCallerAddress(MUtil.convertToTronAddress(msg.getType().callIsDelegate() ? this.getCallerAddress().getLast20Bytes() : this.getContractAddress().getLast20Bytes()));
            contract.setDeposit(deposit);
            contract.setResult(this.result);
            contract.setRootCallConstant(this.getRootCallConstant());
            Pair<Boolean, byte[]> out = contract.execute(data);
            if (((Boolean)out.getLeft()).booleanValue()) {
                this.refundEnergy(msg.getEnergy().longValue() - requiredEnergy, "call pre-compiled");
                this.stackPushOne();
                this.returnDataBuffer = (byte[])out.getRight();
                deposit.commit();
            } else {
                this.refundEnergy(0L, "call pre-compiled");
                this.stackPushZero();
                if (Objects.nonNull(this.result.getException())) {
                    throw this.result.getException();
                }
            }
            this.memorySave(msg.getOutDataOffs().intValue(), (byte[])out.getRight());
        }
    }

    public boolean byTestingSuite() {
        return this.invoke.byTestingSuite();
    }

    public DataWord getCallEnergy(OpCode op, DataWord requestedEnergy, DataWord availableEnergy) {
        return requestedEnergy.compareTo(availableEnergy) > 0 ? availableEnergy : requestedEnergy;
    }

    public DataWord getCreateEnergy(DataWord availableEnergy) {
        return availableEnergy;
    }

    public byte[] getMemory() {
        return this.memory.read(0, this.memory.size());
    }

    public void initMem(byte[] data) {
        this.memory.write(0, data, data.length, false);
    }

    public long getVmStartInUs() {
        return this.invoke.getVmStartInUs();
    }

    public class StackTooLargeException
    extends BytecodeExecutionException {
        public StackTooLargeException(String message) {
            super(message);
        }
    }

    public static class Exception {
        private Exception() {
        }

        public static OutOfEnergyException notEnoughOpEnergy(OpCode op, long opEnergy, long programEnergy) {
            return new OutOfEnergyException("Not enough energy for '%s' operation executing: opEnergy[%d], programEnergy[%d];", new Object[]{op, opEnergy, programEnergy});
        }

        public static OutOfEnergyException notEnoughSpendEnergy(String hint, long needEnergy, long leftEnergy) {
            return new OutOfEnergyException("Not enough energy for '%s' executing: needEnergy[%d], leftEnergy[%d];", hint, needEnergy, leftEnergy);
        }

        public static OutOfEnergyException notEnoughOpEnergy(OpCode op, DataWord opEnergy, DataWord programEnergy) {
            return Exception.notEnoughOpEnergy(op, opEnergy.longValue(), programEnergy.longValue());
        }

        public static OutOfTimeException notEnoughTime(String op) {
            return new OutOfTimeException("CPU timeout for '%s' operation executing", op);
        }

        public static OutOfTimeException alreadyTimeOut() {
            return new OutOfTimeException("Already Time Out", new Object[0]);
        }

        public static OutOfMemoryException memoryOverflow(OpCode op) {
            return new OutOfMemoryException("Out of Memory when '%s' operation executing", op.name());
        }

        public static OutOfStorageException notEnoughStorage() {
            return new OutOfStorageException("Not enough ContractState resource", new Object[0]);
        }

        public static PrecompiledContractException contractValidateException(TronException e) {
            return new PrecompiledContractException(e.getMessage(), new Object[0]);
        }

        public static PrecompiledContractException contractExecuteException(TronException e) {
            return new PrecompiledContractException(e.getMessage(), new Object[0]);
        }

        public static OutOfEnergyException energyOverflow(BigInteger actualEnergy, BigInteger energyLimit) {
            return new OutOfEnergyException("Energy value overflow: actualEnergy[%d], energyLimit[%d];", actualEnergy.longValueExact(), energyLimit.longValueExact());
        }

        public static IllegalOperationException invalidOpCode(byte ... opCode) {
            return new IllegalOperationException("Invalid operation code: opCode[%s];", Hex.toHexString((byte[])opCode, (int)0, (int)1));
        }

        public static BadJumpDestinationException badJumpDestination(int pc) {
            return new BadJumpDestinationException("Operation with pc isn't 'JUMPDEST': PC[%d];", pc);
        }

        public static StackTooSmallException tooSmallStack(int expectedSize, int actualSize) {
            return new StackTooSmallException("Expected stack size %d but actual %d;", expectedSize, actualSize);
        }
    }

    public static class StaticCallModificationException
    extends BytecodeExecutionException {
        public StaticCallModificationException() {
            super("Attempt to call a state modifying opcode inside STATICCALL");
        }
    }

    public static class JVMStackOverFlowException
    extends BytecodeExecutionException {
        public JVMStackOverFlowException() {
            super("StackOverflowError:  exceed default JVM stack size!");
        }
    }

    public static class ReturnDataCopyIllegalBoundsException
    extends BytecodeExecutionException {
        public ReturnDataCopyIllegalBoundsException(DataWord off, DataWord size, long returnDataSize) {
            super(String.format("Illegal RETURNDATACOPY arguments: offset (%s) + size (%s) > RETURNDATASIZE (%d)", off, size, returnDataSize));
        }
    }

    public static class StackTooSmallException
    extends BytecodeExecutionException {
        public StackTooSmallException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class BadJumpDestinationException
    extends BytecodeExecutionException {
        public BadJumpDestinationException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class IllegalOperationException
    extends BytecodeExecutionException {
        public IllegalOperationException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class PrecompiledContractException
    extends BytecodeExecutionException {
        public PrecompiledContractException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfStorageException
    extends BytecodeExecutionException {
        public OutOfStorageException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfMemoryException
    extends BytecodeExecutionException {
        public OutOfMemoryException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfTimeException
    extends BytecodeExecutionException {
        public OutOfTimeException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfEnergyException
    extends BytecodeExecutionException {
        public OutOfEnergyException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class BytecodeExecutionException
    extends RuntimeException {
        public BytecodeExecutionException(String message) {
            super(message);
        }
    }

    public static interface ProgramOutListener {
        public void output(String var1);
    }

    static class ByteCodeIterator {
        byte[] code;
        int pc;

        public ByteCodeIterator(byte[] code2) {
            this.code = code2;
        }

        public void setPC(int pc) {
            this.pc = pc;
        }

        public int getPC() {
            return this.pc;
        }

        public OpCode getCurOpcode() {
            return this.pc < this.code.length ? OpCode.code(this.code[this.pc]) : null;
        }

        public boolean isPush() {
            return this.getCurOpcode() != null && this.getCurOpcode().name().startsWith("PUSH");
        }

        public byte[] getCurOpcodeArg() {
            if (this.isPush()) {
                int nPush = this.getCurOpcode().val() - OpCode.PUSH1.val() + 1;
                byte[] data = Arrays.copyOfRange(this.code, this.pc + 1, this.pc + nPush + 1);
                return data;
            }
            return new byte[0];
        }

        public boolean next() {
            this.pc += 1 + this.getCurOpcodeArg().length;
            return this.pc < this.code.length;
        }
    }
}

