/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import java.util.LinkedList;
import java.util.List;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.listener.ProgramListener;
import org.tron.common.runtime.vm.program.listener.ProgramListenerAware;
import org.tron.common.utils.ByteUtil;

public class Memory
implements ProgramListenerAware {
    private static final int CHUNK_SIZE = 1024;
    private static final int WORD_SIZE = 32;
    private List<byte[]> chunks = new LinkedList<byte[]>();
    private int softSize;
    private ProgramListener programListener;

    @Override
    public void setProgramListener(ProgramListener traceListener) {
        this.programListener = traceListener;
    }

    public byte[] read(int address, int size) {
        if (size <= 0) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        this.extend(address, size);
        byte[] data = new byte[size];
        int chunkIndex = address / 1024;
        int chunkOffset = address % 1024;
        int toGrab = data.length;
        int start = 0;
        while (toGrab > 0) {
            int copied = this.grabMax(chunkIndex, chunkOffset, toGrab, data, start);
            ++chunkIndex;
            chunkOffset = 0;
            toGrab -= copied;
            start += copied;
        }
        return data;
    }

    public void write(int address, byte[] data, int dataSize, boolean limited) {
        if (data.length < dataSize) {
            dataSize = data.length;
        }
        if (!limited) {
            this.extend(address, dataSize);
        }
        int chunkIndex = address / 1024;
        int chunkOffset = address % 1024;
        int toCapture = 0;
        toCapture = limited ? (address + dataSize > this.softSize ? this.softSize - address : dataSize) : dataSize;
        int start = 0;
        while (toCapture > 0) {
            int captured = this.captureMax(chunkIndex, chunkOffset, toCapture, data, start);
            ++chunkIndex;
            chunkOffset = 0;
            toCapture -= captured;
            start += captured;
        }
        if (this.programListener != null) {
            this.programListener.onMemoryWrite(address, data, dataSize);
        }
    }

    public void extendAndWrite(int address, int allocSize, byte[] data) {
        this.extend(address, allocSize);
        this.write(address, data, data.length, false);
    }

    public void extend(int address, int size) {
        if (size <= 0) {
            return;
        }
        int newSize = Math.addExact(address, size);
        int toAllocate = newSize - this.internalSize();
        if (toAllocate > 0) {
            this.addChunks((int)Math.ceil((double)toAllocate / 1024.0));
        }
        if ((toAllocate = newSize - this.softSize) > 0) {
            toAllocate = (int)Math.ceil((double)toAllocate / 32.0) * 32;
            this.softSize = Math.addExact(this.softSize, toAllocate);
            if (this.programListener != null) {
                this.programListener.onMemoryExtend(toAllocate);
            }
        }
    }

    public DataWord readWord(int address) {
        return new DataWord(this.read(address, 32));
    }

    public byte readByte(int address) {
        int chunkIndex = address / 1024;
        int chunkOffset = address % 1024;
        byte[] chunk = this.chunks.get(chunkIndex);
        return chunk[chunkOffset];
    }

    public String toString() {
        StringBuilder memoryData = new StringBuilder();
        StringBuilder firstLine = new StringBuilder();
        StringBuilder secondLine = new StringBuilder();
        for (int i = 0; i < this.softSize; ++i) {
            byte value = this.readByte(i);
            String character = 32 <= value && value <= 126 ? new String(new byte[]{value}) : "?";
            firstLine.append(character).append("");
            secondLine.append(ByteUtil.oneByteToHexString(value)).append(" ");
            if ((i + 1) % 8 != 0) continue;
            String tmp = String.format("%4s", Integer.toString(i - 7, 16)).replace(" ", "0");
            memoryData.append("").append(tmp).append(" ");
            memoryData.append((CharSequence)firstLine).append(" ");
            memoryData.append((CharSequence)secondLine);
            if (i + 1 < this.softSize) {
                memoryData.append("\n");
            }
            firstLine.setLength(0);
            secondLine.setLength(0);
        }
        return memoryData.toString();
    }

    public int size() {
        return this.softSize;
    }

    public int internalSize() {
        return this.chunks.size() * 1024;
    }

    public List<byte[]> getChunks() {
        return new LinkedList<byte[]>(this.chunks);
    }

    private int captureMax(int chunkIndex, int chunkOffset, int size, byte[] src, int srcPos) {
        byte[] chunk = this.chunks.get(chunkIndex);
        int toCapture = Math.min(size, chunk.length - chunkOffset);
        System.arraycopy(src, srcPos, chunk, chunkOffset, toCapture);
        return toCapture;
    }

    private int grabMax(int chunkIndex, int chunkOffset, int size, byte[] dest, int destPos) {
        byte[] chunk = this.chunks.get(chunkIndex);
        int toGrab = Math.min(size, chunk.length - chunkOffset);
        System.arraycopy(chunk, chunkOffset, dest, destPos, toGrab);
        return toGrab;
    }

    private void addChunks(int num) {
        for (int i = 0; i < num; ++i) {
            this.chunks.add(new byte[1024]);
        }
    }
}

