/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm.program;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteUtil;
import org.tron.core.Wallet;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class InternalTransaction {
    private Protocol.Transaction transaction;
    private byte[] hash;
    private byte[] parentHash;
    private long value;
    private long tokenValue;
    private Map<String, Long> tokenInfo = new HashMap<String, Long>();
    private byte[] receiveAddress;
    private byte[] data;
    private long nonce;
    private byte[] transferToAddress;
    private byte[] sendAddress;
    private int deep;
    private int index;
    private boolean rejected;
    private String note;
    private byte[] protoEncoded;

    public InternalTransaction(Protocol.Transaction trx, TrxType trxType) throws ContractValidateException {
        this.transaction = trx;
        TransactionCapsule trxCap = new TransactionCapsule(trx);
        this.protoEncoded = trxCap.getData();
        this.nonce = 0L;
        this.deep = -1;
        if (trxType == TrxType.TRX_CONTRACT_CREATION_TYPE) {
            Contract.CreateSmartContract contract = ContractCapsule.getSmartContractFromTransaction(trx);
            if (contract == null) {
                throw new ContractValidateException("Invalid CreateSmartContract Protocol");
            }
            this.sendAddress = contract.getOwnerAddress().toByteArray();
            this.receiveAddress = ByteUtil.EMPTY_BYTE_ARRAY;
            this.transferToAddress = Wallet.generateContractAddress(trx);
            this.note = "create";
            this.value = contract.getNewContract().getCallValue();
            this.data = contract.getNewContract().getBytecode().toByteArray();
            this.tokenInfo.put(String.valueOf(contract.getTokenId()), contract.getCallTokenValue());
        } else if (trxType == TrxType.TRX_CONTRACT_CALL_TYPE) {
            Contract.TriggerSmartContract contract = ContractCapsule.getTriggerContractFromTransaction(trx);
            if (contract == null) {
                throw new ContractValidateException("Invalid TriggerSmartContract Protocol");
            }
            this.sendAddress = contract.getOwnerAddress().toByteArray();
            this.receiveAddress = contract.getContractAddress().toByteArray();
            this.transferToAddress = (byte[])this.receiveAddress.clone();
            this.note = "call";
            this.value = contract.getCallValue();
            this.data = contract.getData().toByteArray();
            this.tokenInfo.put(String.valueOf(contract.getTokenId()), contract.getCallTokenValue());
        }
        this.hash = trxCap.getTransactionId().getBytes();
    }

    public InternalTransaction(byte[] parentHash, int deep, int index, byte[] sendAddress, byte[] transferToAddress, long value, byte[] data, String note, long nonce, Map<String, Long> tokenInfo) {
        this.parentHash = (byte[])parentHash.clone();
        this.deep = deep;
        this.index = index;
        this.note = note;
        this.sendAddress = ArrayUtils.nullToEmpty((byte[])sendAddress);
        this.transferToAddress = ArrayUtils.nullToEmpty((byte[])transferToAddress);
        this.receiveAddress = "create".equalsIgnoreCase(note) ? ByteUtil.EMPTY_BYTE_ARRAY : ArrayUtils.nullToEmpty((byte[])transferToAddress);
        this.value = value;
        this.data = ArrayUtils.nullToEmpty((byte[])data);
        this.nonce = nonce;
        this.hash = this.getHash();
        if (tokenInfo != null) {
            this.tokenInfo.putAll(tokenInfo);
        }
    }

    public Protocol.Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Protocol.Transaction transaction) {
        this.transaction = transaction;
    }

    public byte[] getTransferToAddress() {
        return (byte[])this.transferToAddress.clone();
    }

    public void reject() {
        this.rejected = true;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public String getNote() {
        if (this.note == null) {
            return "";
        }
        return this.note;
    }

    public Map<String, Long> getTokenInfo() {
        return this.tokenInfo;
    }

    public byte[] getSender() {
        if (this.sendAddress == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return (byte[])this.sendAddress.clone();
    }

    public byte[] getParentHash() {
        if (this.parentHash == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return (byte[])this.parentHash.clone();
    }

    public long getValue() {
        return this.value;
    }

    public byte[] getData() {
        if (this.data == null) {
            return ByteUtil.EMPTY_BYTE_ARRAY;
        }
        return (byte[])this.data.clone();
    }

    public final byte[] getHash() {
        if (!ArrayUtils.isEmpty((byte[])this.hash)) {
            return Arrays.copyOf(this.hash, this.hash.length);
        }
        byte[] plainMsg = this.getEncoded();
        byte[] nonceByte = Longs.toByteArray((long)this.nonce);
        byte[] forHash = new byte[plainMsg.length + nonceByte.length];
        System.arraycopy(plainMsg, 0, forHash, 0, plainMsg.length);
        System.arraycopy(nonceByte, 0, forHash, plainMsg.length, nonceByte.length);
        this.hash = Hash.sha3(forHash);
        return Arrays.copyOf(this.hash, this.hash.length);
    }

    public long getNonce() {
        return this.nonce;
    }

    public byte[] getEncoded() {
        if (this.protoEncoded != null) {
            return (byte[])this.protoEncoded.clone();
        }
        byte[] parentHashArray = (byte[])this.parentHash.clone();
        if (parentHashArray == null) {
            parentHashArray = ByteUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] valueByte = Longs.toByteArray((long)this.value);
        byte[] raw2 = new byte[parentHashArray.length + this.receiveAddress.length + this.data.length + valueByte.length];
        System.arraycopy(parentHashArray, 0, raw2, 0, parentHashArray.length);
        System.arraycopy(this.receiveAddress, 0, raw2, parentHashArray.length, this.receiveAddress.length);
        System.arraycopy(this.data, 0, raw2, parentHashArray.length + this.receiveAddress.length, this.data.length);
        System.arraycopy(valueByte, 0, raw2, parentHashArray.length + this.receiveAddress.length + this.data.length, valueByte.length);
        this.protoEncoded = raw2;
        return (byte[])this.protoEncoded.clone();
    }

    public int getDeep() {
        return this.deep;
    }

    public int getIndex() {
        return this.index;
    }

    public static enum ExecutorType {
        ET_PRE_TYPE,
        ET_NORMAL_TYPE,
        ET_CONSTANT_TYPE,
        ET_UNKNOWN_TYPE;

    }

    public static enum TrxType {
        TRX_PRECOMPILED_TYPE,
        TRX_CONTRACT_CREATION_TYPE,
        TRX_CONTRACT_CALL_TYPE,
        TRX_UNKNOWN_TYPE;

    }
}

