/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.runtime.config.VMConfig;

public final class VMUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"VM");
    private static final int BUF_SIZE = 4096;

    private VMUtils() {
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File createProgramTraceFile(VMConfig config, String txHash) {
        File result = null;
        if (config.vmTrace()) {
            File file = new File(new File("./", "vm_trace"), txHash + ".json");
            if (file.exists()) {
                if (file.isFile() && file.canWrite()) {
                    result = file;
                }
            } else {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    result = file;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(File file, String data) {
        FileOutputStream out;
        block4: {
            out = null;
            try {
                out = new FileOutputStream(file);
                if (data == null) break block4;
                ((OutputStream)out).write(data.getBytes("UTF-8"));
            }
            catch (Exception e) {
                try {
                    LOGGER.error(String.format("Cannot write to file '%s': ", file.getAbsolutePath()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    VMUtils.closeQuietly(out);
                    throw throwable;
                }
                VMUtils.closeQuietly(out);
            }
        }
        VMUtils.closeQuietly(out);
    }

    public static void saveProgramTraceFile(VMConfig config, String txHash, String content) {
        File file = VMUtils.createProgramTraceFile(config, txHash);
        if (file != null) {
            VMUtils.writeStringToFile(file, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(InputStream in, OutputStream out, int bufSize) throws IOException {
        try {
            byte[] buf = new byte[bufSize];
            int count = in.read(buf);
            while (count != -1) {
                out.write(buf, 0, count);
                count = in.read(buf);
            }
        }
        finally {
            VMUtils.closeQuietly(in);
            VMUtils.closeQuietly(out);
        }
    }

    public static byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)baos, new Deflater(), 4096);
        VMUtils.write(in, out, 4096);
        return baos.toByteArray();
    }

    public static byte[] compress(String content) throws IOException {
        return VMUtils.compress(content.getBytes("UTF-8"));
    }

    public static byte[] decompress(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        InflaterOutputStream out = new InflaterOutputStream(baos, new Inflater(), 4096);
        VMUtils.write(in, out, 4096);
        return baos.toByteArray();
    }

    public static String zipAndEncode(String content) {
        try {
            return Base64.encodeBase64String((byte[])VMUtils.compress(content));
        }
        catch (Exception e) {
            LOGGER.error("Cannot zip or encode: ", (Throwable)e);
            return content;
        }
    }

    public static String unzipAndDecode(String content) {
        try {
            byte[] decoded = Base64.decodeBase64((String)content);
            return new String(VMUtils.decompress(decoded), "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error("Cannot unzip or decode: ", (Throwable)e);
            return content;
        }
    }
}

