/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.tron.common.crypto.ECKey;
import org.tron.common.crypto.zksnark.BN128;
import org.tron.common.crypto.zksnark.BN128Fp;
import org.tron.common.crypto.zksnark.BN128G1;
import org.tron.common.crypto.zksnark.BN128G2;
import org.tron.common.crypto.zksnark.Fp;
import org.tron.common.crypto.zksnark.PairingCheck;
import org.tron.common.runtime.utils.MUtil;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.program.Program;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.common.storage.Deposit;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.Wallet;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.ActuatorFactory;
import org.tron.core.actuator.ProposalApproveActuator;
import org.tron.core.actuator.ProposalCreateActuator;
import org.tron.core.actuator.ProposalDeleteActuator;
import org.tron.core.actuator.VoteWitnessActuator;
import org.tron.core.actuator.WithdrawBalanceActuator;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class PrecompiledContracts {
    private static final Logger logger = LoggerFactory.getLogger(PrecompiledContracts.class);
    private static final ECRecover ecRecover = new ECRecover();
    private static final Sha256 sha256 = new Sha256();
    private static final Ripempd160 ripempd160 = new Ripempd160();
    private static final Identity identity = new Identity();
    private static final ModExp modExp = new ModExp();
    private static final BN128Addition altBN128Add = new BN128Addition();
    private static final BN128Multiplication altBN128Mul = new BN128Multiplication();
    private static final BN128Pairing altBN128Pairing = new BN128Pairing();
    private static final ECKey addressCheckECKey = new ECKey();
    private static final String addressCheckECKeyAddress = Wallet.encode58Check(addressCheckECKey.getAddress());
    private static final DataWord ecRecoverAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000001");
    private static final DataWord sha256Addr = new DataWord("0000000000000000000000000000000000000000000000000000000000000002");
    private static final DataWord ripempd160Addr = new DataWord("0000000000000000000000000000000000000000000000000000000000000003");
    private static final DataWord identityAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000004");
    private static final DataWord modExpAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000005");
    private static final DataWord altBN128AddAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000006");
    private static final DataWord altBN128MulAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000007");
    private static final DataWord altBN128PairingAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000008");

    public static PrecompiledContract getContractForAddress(DataWord address) {
        if (address == null) {
            return identity;
        }
        if (address.equals(ecRecoverAddr)) {
            return ecRecover;
        }
        if (address.equals(sha256Addr)) {
            return sha256;
        }
        if (address.equals(ripempd160Addr)) {
            return ripempd160;
        }
        if (address.equals(identityAddr)) {
            return identity;
        }
        if (address.equals(modExpAddr)) {
            return modExp;
        }
        if (address.equals(altBN128AddAddr)) {
            return altBN128Add;
        }
        if (address.equals(altBN128MulAddr)) {
            return altBN128Mul;
        }
        if (address.equals(altBN128PairingAddr)) {
            return altBN128Pairing;
        }
        return null;
    }

    private static byte[] encodeRes(byte[] w1, byte[] w2) {
        byte[] res = new byte[64];
        w1 = ByteUtil.stripLeadingZeroes(w1);
        w2 = ByteUtil.stripLeadingZeroes(w2);
        System.arraycopy(w1, 0, res, 32 - w1.length, w1.length);
        System.arraycopy(w2, 0, res, 64 - w2.length, w2.length);
        return res;
    }

    public static class GetTransferAssetNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            int length;
            if (data == null || data.length != 64) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            byte[] targetAddress = new byte[32];
            System.arraycopy(data, 0, targetAddress, 0, 32);
            byte[] name = new byte[32];
            System.arraycopy(data, 32, name, 0, 32);
            for (length = name.length; length > 0 && name[length - 1] == 0; --length) {
            }
            name = ByteArray.subArray(name, 0, length);
            long assetBalance = this.getDeposit().getAccount(MUtil.convertToTronAddress(new DataWord(targetAddress).getLast20Bytes())).getAssetMap().get(ByteArray.toStr(name));
            return Pair.of((Object)true, (Object)new DataWord(Longs.toByteArray((long)assetBalance)).getData());
        }
    }

    public static class TransferAssetNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class ConvertFromTronBase58AddressNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            int checklength = addressCheckECKeyAddress.length();
            if (data == null || data.length != checklength) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            String addressBase58 = new String(data);
            byte[] resultBytes = Wallet.decodeFromBase58Check(addressBase58);
            String hexString = Hex.toHexString((byte[])resultBytes);
            return Pair.of((Object)true, (Object)new DataWord(new DataWord(hexString).getLast20Bytes()).getData());
        }
    }

    public static class ConvertFromTronBytesAddressNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            DataWord address = new DataWord(data);
            return Pair.of((Object)true, (Object)new DataWord(address.getLast20Bytes()).getData());
        }
    }

    public static class ProposalDeleteNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (this.isRootCallConstant()) {
                return Pair.of((Object)true, (Object)new DataWord(0).getData());
            }
            if (data == null || data.length != 32) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            Contract.ProposalDeleteContract.Builder builder = Contract.ProposalDeleteContract.newBuilder();
            builder.setOwnerAddress(ByteString.copyFrom((byte[])this.getCallerAddress()));
            builder.setProposalId(ByteArray.toLong(data));
            Contract.ProposalDeleteContract contract = builder.build();
            TransactionCapsule trx = new TransactionCapsule((Message)contract, Protocol.Transaction.Contract.ContractType.ProposalDeleteContract);
            List<Actuator> actuatorList = ActuatorFactory.createActuator(trx, this.getDeposit().getDbManager());
            try {
                if (Objects.isNull(actuatorList) || actuatorList.isEmpty()) {
                    throw new ContractExeException("can't initiate ProposalDeleteActuator for precompiled vm method");
                }
                Optional proposalDeleteOptional = actuatorList.stream().findFirst();
                if (!proposalDeleteOptional.isPresent()) {
                    throw new ContractExeException("can't initiate ProposalDeleteActuator for precompiled vm method");
                }
                ProposalDeleteActuator proposalDeleteActuator = (ProposalDeleteActuator)proposalDeleteOptional.get();
                proposalDeleteActuator.setDeposit(this.getDeposit());
                proposalDeleteActuator.validate();
                proposalDeleteActuator.execute(this.getResult().getRet());
            }
            catch (ContractExeException e) {
                logger.debug("ContractExeException when calling proposalDeleteContract in vm");
                logger.debug("ContractExeException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractExecuteException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            catch (ContractValidateException e) {
                logger.debug("ContractValidateException when calling proposalDeleteContract in vm");
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractValidateException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class ProposalCreateNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (this.isRootCallConstant()) {
                return Pair.of((Object)true, (Object)new DataWord(0).getData());
            }
            if (data == null || data.length == 0 || data.length % 64 != 0) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            HashMap<Long, Long> parametersMap = new HashMap<Long, Long>();
            for (int index = 0; index <= data.length - 1; index += 64) {
                byte[] id = new byte[32];
                System.arraycopy(data, index, id, 0, 32);
                byte[] value = new byte[32];
                System.arraycopy(data, 32 + index, value, 0, 32);
                parametersMap.put(ByteArray.toLong(id), ByteArray.toLong(value));
            }
            Contract.ProposalCreateContract.Builder builder = Contract.ProposalCreateContract.newBuilder();
            ByteString byteAddress = ByteString.copyFrom((byte[])this.getCallerAddress());
            builder.setOwnerAddress(byteAddress);
            builder.putAllParameters(parametersMap);
            Contract.ProposalCreateContract contract = builder.build();
            long id = 0L;
            TransactionCapsule trx = new TransactionCapsule((Message)contract, Protocol.Transaction.Contract.ContractType.ProposalCreateContract);
            List<Actuator> actuatorList = ActuatorFactory.createActuator(trx, this.getDeposit().getDbManager());
            try {
                if (Objects.isNull(actuatorList) || actuatorList.isEmpty()) {
                    throw new ContractExeException("can't initiate ProposalCreateActuator for precompiled vm method");
                }
                Optional proposalCreateOptional = actuatorList.stream().findFirst();
                if (!proposalCreateOptional.isPresent()) {
                    throw new ContractExeException("can't initiate ProposalCreateActuator for precompiled vm method");
                }
                ProposalCreateActuator proposalCreateActuator = (ProposalCreateActuator)proposalCreateOptional.get();
                proposalCreateActuator.setDeposit(this.getDeposit());
                proposalCreateActuator.validate();
                proposalCreateActuator.execute(this.getResult().getRet());
                id = this.getDeposit().getLatestProposalNum();
            }
            catch (ContractExeException e) {
                logger.debug("ContractExeException when calling proposalCreateNative in vm");
                logger.debug("ContractExeException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractExecuteException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            catch (ContractValidateException e) {
                logger.debug("ContractValidateException when calling proposalCreateNative in vm");
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractValidateException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            return Pair.of((Object)true, (Object)new DataWord(id).getData());
        }
    }

    public static class ProposalApproveNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (this.isRootCallConstant()) {
                return Pair.of((Object)true, (Object)new DataWord(0).getData());
            }
            if (data == null || data.length != 64) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            byte[] proposalId = new byte[32];
            System.arraycopy(data, 0, proposalId, 0, 32);
            byte[] isAddApproval = new byte[32];
            System.arraycopy(data, 32, isAddApproval, 0, 32);
            Contract.ProposalApproveContract.Builder builder = Contract.ProposalApproveContract.newBuilder();
            ByteString byteAddress = ByteString.copyFrom((byte[])this.getCallerAddress());
            builder.setOwnerAddress(byteAddress);
            builder.setProposalId(ByteArray.toLong(proposalId));
            builder.setIsAddApproval(ByteArray.toInt(isAddApproval) == 1);
            Contract.ProposalApproveContract contract = builder.build();
            TransactionCapsule trx = new TransactionCapsule((Message)contract, Protocol.Transaction.Contract.ContractType.ProposalApproveContract);
            List<Actuator> actuatorList = ActuatorFactory.createActuator(trx, this.getDeposit().getDbManager());
            try {
                if (Objects.isNull(actuatorList) || actuatorList.isEmpty()) {
                    throw new ContractExeException("can't initiate ProposalApproveActuator for precompiled vm method");
                }
                Optional proposalApproveOptional = actuatorList.stream().findFirst();
                if (!proposalApproveOptional.isPresent()) {
                    throw new ContractExeException("can't initiate ProposalApproveActuator for precompiled vm method");
                }
                ProposalApproveActuator proposalApproveActuator = (ProposalApproveActuator)proposalApproveOptional.get();
                proposalApproveActuator.setDeposit(this.getDeposit());
                proposalApproveActuator.validate();
                proposalApproveActuator.execute(this.getResult().getRet());
            }
            catch (ContractExeException e) {
                logger.debug("ContractExeException when calling proposalApproveNative in vm");
                logger.debug("ContractExeException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractExecuteException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            catch (ContractValidateException e) {
                logger.debug("ContractValidateException when calling proposalApproveNative in vm");
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class WithdrawBalanceNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (this.isRootCallConstant()) {
                return Pair.of((Object)true, (Object)new DataWord(0).getData());
            }
            Contract.WithdrawBalanceContract.Builder builder = Contract.WithdrawBalanceContract.newBuilder();
            ByteString byteAddress = ByteString.copyFrom((byte[])this.getCallerAddress());
            builder.setOwnerAddress(byteAddress);
            Contract.WithdrawBalanceContract contract = builder.build();
            TransactionCapsule trx = new TransactionCapsule((Message)contract, Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract);
            List<Actuator> actuatorList = ActuatorFactory.createActuator(trx, this.getDeposit().getDbManager());
            try {
                if (Objects.isNull(actuatorList) || actuatorList.isEmpty()) {
                    throw new ContractExeException("can't initiate WithdrawBalanceActuator for precompiled vm method");
                }
                Optional withdrawOptional = actuatorList.stream().findFirst();
                if (!withdrawOptional.isPresent()) {
                    throw new ContractExeException("can't initiate WithdrawBalanceActuator for precompiled vm method");
                }
                WithdrawBalanceActuator withdrawBalanceActuator = (WithdrawBalanceActuator)withdrawOptional.get();
                withdrawBalanceActuator.setDeposit(this.getDeposit());
                withdrawBalanceActuator.validate();
                withdrawBalanceActuator.execute(this.getResult().getRet());
            }
            catch (ContractExeException e) {
                logger.debug("ContractExeException when calling withdrawBalanceNative in vm");
                logger.debug("ContractExeException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractExecuteException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            catch (ContractValidateException e) {
                logger.debug("ContractValidateException when calling withdrawBalanceNative in vm");
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractValidateException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class UnfreezeBalanceNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class FreezeBalanceNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class VoteWitnessNative
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 200L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (this.isRootCallConstant()) {
                return Pair.of((Object)true, (Object)new DataWord(0).getData());
            }
            if (data == null || data.length != 64) {
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            byte[] witnessAddress = new byte[32];
            System.arraycopy(data, 0, witnessAddress, 0, 32);
            byte[] value = new byte[8];
            System.arraycopy(data, 56, value, 0, 8);
            Contract.VoteWitnessContract.Builder builder = Contract.VoteWitnessContract.newBuilder();
            builder.setOwnerAddress(ByteString.copyFrom((byte[])this.getCallerAddress()));
            long count = Longs.fromByteArray((byte[])value);
            Contract.VoteWitnessContract.Vote.Builder voteBuilder = Contract.VoteWitnessContract.Vote.newBuilder();
            byte[] witnessAddress20 = new byte[20];
            System.arraycopy(witnessAddress, 12, witnessAddress20, 0, 20);
            voteBuilder.setVoteAddress(ByteString.copyFrom((byte[])MUtil.convertToTronAddress(witnessAddress20)));
            voteBuilder.setVoteCount(count);
            builder.addVotes(voteBuilder.build());
            Contract.VoteWitnessContract contract = builder.build();
            List<Actuator> actuatorList = ActuatorFactory.createActuator(new TransactionCapsule(contract), this.getDeposit().getDbManager());
            try {
                if (Objects.isNull(actuatorList) || actuatorList.isEmpty()) {
                    throw new ContractExeException("can't initiate VoteWitnessActuator for precompiled vm method");
                }
                Optional voteOptional = actuatorList.stream().findFirst();
                if (!voteOptional.isPresent()) {
                    throw new ContractExeException("can't initiate VoteWitnessActuator for precompiled vm method");
                }
                VoteWitnessActuator voteWitnessActuator = (VoteWitnessActuator)voteOptional.get();
                voteWitnessActuator.setDeposit(this.getDeposit());
                voteWitnessActuator.validate();
                voteWitnessActuator.execute(this.getResult().getRet());
            }
            catch (ContractExeException e) {
                logger.debug("ContractExeException when calling voteWitness in vm");
                logger.debug("ContractExeException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractExecuteException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            catch (ContractValidateException e) {
                logger.debug("ContractValidateException when calling voteWitness in vm");
                logger.debug("ContractValidateException: {}", (Object)e.getMessage());
                this.getResult().setException(Program.Exception.contractValidateException(e));
                return Pair.of((Object)false, (Object)new DataWord(0).getData());
            }
            return Pair.of((Object)true, (Object)new DataWord(1).getData());
        }
    }

    public static class BN128Pairing
    extends PrecompiledContract {
        private static final int PAIR_SIZE = 192;

        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 100000L;
            }
            return 80000L * (long)(data.length / 192) + 100000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            if (data.length % 192 > 0) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            PairingCheck check = PairingCheck.create();
            for (int offset = 0; offset < data.length; offset += 192) {
                Pair<BN128G1, BN128G2> pair = this.decodePair(data, offset);
                if (pair == null) {
                    return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
                }
                check.addPair((BN128G1)pair.getLeft(), (BN128G2)pair.getRight());
            }
            check.run();
            int result = check.result();
            return Pair.of((Object)true, (Object)new DataWord(result).getData());
        }

        private Pair<BN128G1, BN128G2> decodePair(byte[] in, int offset) {
            byte[] y;
            byte[] x = ByteUtil.parseWord(in, offset, 0);
            BN128G1 p1 = BN128G1.create(x, y = ByteUtil.parseWord(in, offset, 1));
            if (p1 == null) {
                return null;
            }
            byte[] b = ByteUtil.parseWord(in, offset, 2);
            byte[] a = ByteUtil.parseWord(in, offset, 3);
            byte[] d = ByteUtil.parseWord(in, offset, 4);
            byte[] c = ByteUtil.parseWord(in, offset, 5);
            BN128G2 p2 = BN128G2.create(a, b, c, d);
            if (p2 == null) {
                return null;
            }
            return Pair.of((Object)p1, (Object)p2);
        }
    }

    public static class BN128Multiplication
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 40000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] x = ByteUtil.parseWord(data, 0);
            byte[] y = ByteUtil.parseWord(data, 1);
            byte[] s = ByteUtil.parseWord(data, 2);
            BN128<Fp> p = BN128Fp.create(x, y);
            if (p == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128<Fp> res = p.mul(BIUtil.toBI(s)).toEthNotation();
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(res.x().bytes(), res.y().bytes()));
        }
    }

    public static class BN128Addition
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] x1 = ByteUtil.parseWord(data, 0);
            byte[] y1 = ByteUtil.parseWord(data, 1);
            byte[] x2 = ByteUtil.parseWord(data, 2);
            byte[] y2 = ByteUtil.parseWord(data, 3);
            BN128<Fp> p1 = BN128Fp.create(x1, y1);
            if (p1 == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128<Fp> p2 = BN128Fp.create(x2, y2);
            if (p2 == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128<Fp> res = p1.add(p2).toEthNotation();
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(res.x().bytes(), res.y().bytes()));
        }
    }

    public static class ModExp
    extends PrecompiledContract {
        private static final BigInteger GQUAD_DIVISOR = BigInteger.valueOf(20L);
        private static final int ARGS_OFFSET = 96;

        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            int baseLen = this.parseLen(data, 0);
            int expLen = this.parseLen(data, 1);
            int modLen = this.parseLen(data, 2);
            byte[] expHighBytes = ByteUtil.parseBytes(data, BIUtil.addSafely(96, baseLen), Math.min(expLen, 32));
            long multComplexity = this.getMultComplexity(Math.max(baseLen, modLen));
            long adjExpLen = this.getAdjustedExponentLength(expHighBytes, expLen);
            BigInteger energy = BigInteger.valueOf(multComplexity).multiply(BigInteger.valueOf(Math.max(adjExpLen, 1L))).divide(GQUAD_DIVISOR);
            return BIUtil.isLessThan(energy, BigInteger.valueOf(Long.MAX_VALUE)) ? energy.longValueExact() : Long.MAX_VALUE;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            int baseLen = this.parseLen(data, 0);
            int expLen = this.parseLen(data, 1);
            int modLen = this.parseLen(data, 2);
            BigInteger base = this.parseArg(data, 96, baseLen);
            BigInteger exp = this.parseArg(data, BIUtil.addSafely(96, baseLen), expLen);
            BigInteger mod = this.parseArg(data, BIUtil.addSafely(BIUtil.addSafely(96, baseLen), expLen), modLen);
            if (BIUtil.isZero(mod)) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            byte[] res = ByteUtil.stripLeadingZeroes(base.modPow(exp, mod).toByteArray());
            if (res.length < modLen) {
                byte[] adjRes = new byte[modLen];
                System.arraycopy(res, 0, adjRes, modLen - res.length, res.length);
                return Pair.of((Object)true, (Object)adjRes);
            }
            return Pair.of((Object)true, (Object)res);
        }

        private long getMultComplexity(long x) {
            long x2 = x * x;
            if (x <= 64L) {
                return x2;
            }
            if (x <= 1024L) {
                return x2 / 4L + 96L * x - 3072L;
            }
            return x2 / 16L + 480L * x - 199680L;
        }

        private long getAdjustedExponentLength(byte[] expHighBytes, long expLen) {
            int leadingZeros = ByteUtil.numberOfLeadingZeros(expHighBytes);
            int highestBit = 8 * expHighBytes.length - leadingZeros;
            if (highestBit > 0) {
                --highestBit;
            }
            if (expLen <= 32L) {
                return highestBit;
            }
            return 8L * (expLen - 32L) + (long)highestBit;
        }

        private int parseLen(byte[] data, int idx) {
            byte[] bytes = ByteUtil.parseBytes(data, 32 * idx, 32);
            return new DataWord(bytes).intValueSafe();
        }

        private BigInteger parseArg(byte[] data, int offset, int len) {
            byte[] bytes = ByteUtil.parseBytes(data, offset, len);
            return ByteUtil.bytesToBigInteger(bytes);
        }
    }

    public static class ECRecover
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 3000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] h = new byte[32];
            byte[] v = new byte[32];
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            DataWord out = null;
            try {
                System.arraycopy(data, 0, h, 0, 32);
                System.arraycopy(data, 32, v, 0, 32);
                System.arraycopy(data, 64, r, 0, 32);
                int sLength = data.length < 128 ? data.length - 96 : 32;
                System.arraycopy(data, 96, s, 0, sLength);
                ECKey.ECDSASignature signature = ECKey.ECDSASignature.fromComponents(r, s, v[31]);
                if (ECRecover.validateV(v) && signature.validateComponents()) {
                    out = new DataWord(ECKey.signatureToAddress(h, signature));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (out == null) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return Pair.of((Object)true, (Object)out.getData());
        }

        private static boolean validateV(byte[] v) {
            for (int i = 0; i < v.length - 1; ++i) {
                if (v[i] == 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Ripempd160
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 600L;
            }
            return 600L + (long)((data.length + 31) / 32 * 120);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] target = new byte[20];
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] orig = Sha256Hash.hash(data);
            System.arraycopy(orig, 0, target, 0, 20);
            return Pair.of((Object)true, (Object)Sha256Hash.hash(target));
        }
    }

    public static class Sha256
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 60L;
            }
            return 60L + (long)((data.length + 31) / 32 * 12);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)Sha256Hash.hash(ByteUtil.EMPTY_BYTE_ARRAY));
            }
            return Pair.of((Object)true, (Object)Sha256Hash.hash(data));
        }
    }

    public static class Identity
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 15L;
            }
            return 15L + (long)((data.length + 31) / 32 * 3);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            return Pair.of((Object)true, (Object)data);
        }
    }

    public static abstract class PrecompiledContract {
        private byte[] callerAddress;
        private Deposit deposit;
        private ProgramResult result;
        private boolean isRootCallConstant;

        public abstract long getEnergyForData(byte[] var1);

        public abstract Pair<Boolean, byte[]> execute(byte[] var1);

        public void setCallerAddress(byte[] callerAddress) {
            this.callerAddress = (byte[])callerAddress.clone();
        }

        public void setDeposit(Deposit deposit) {
            this.deposit = deposit;
        }

        public void setResult(ProgramResult result) {
            this.result = result;
        }

        public byte[] getCallerAddress() {
            return (byte[])this.callerAddress.clone();
        }

        public Deposit getDeposit() {
            return this.deposit;
        }

        public ProgramResult getResult() {
            return this.result;
        }

        public boolean isRootCallConstant() {
            return this.isRootCallConstant;
        }

        public void setRootCallConstant(boolean rootCallConstant) {
            this.isRootCallConstant = rootCallConstant;
        }
    }
}

