/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.vm;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum OpCode {
    STOP(0, 0, 0, Tier.ZeroTier, new CallFlags[0]),
    ADD(1, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    MUL(2, 2, 1, Tier.LowTier, new CallFlags[0]),
    SUB(3, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    DIV(4, 2, 1, Tier.LowTier, new CallFlags[0]),
    SDIV(5, 2, 1, Tier.LowTier, new CallFlags[0]),
    MOD(6, 2, 1, Tier.LowTier, new CallFlags[0]),
    SMOD(7, 2, 1, Tier.LowTier, new CallFlags[0]),
    ADDMOD(8, 3, 1, Tier.MidTier, new CallFlags[0]),
    MULMOD(9, 3, 1, Tier.MidTier, new CallFlags[0]),
    EXP(10, 2, 1, Tier.SpecialTier, new CallFlags[0]),
    SIGNEXTEND(11, 2, 1, Tier.LowTier, new CallFlags[0]),
    LT(16, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    GT(17, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    SLT(18, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    SGT(19, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    EQ(20, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    ISZERO(21, 1, 1, Tier.VeryLowTier, new CallFlags[0]),
    AND(22, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    OR(23, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    XOR(24, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    NOT(25, 1, 1, Tier.VeryLowTier, new CallFlags[0]),
    BYTE(26, 2, 1, Tier.VeryLowTier, new CallFlags[0]),
    SHA3(32, 2, 1, Tier.SpecialTier, new CallFlags[0]),
    ADDRESS(48, 0, 1, Tier.BaseTier, new CallFlags[0]),
    BALANCE(49, 1, 1, Tier.ExtTier, new CallFlags[0]),
    ORIGIN(50, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CALLER(51, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CALLVALUE(52, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CALLDATALOAD(53, 1, 1, Tier.VeryLowTier, new CallFlags[0]),
    CALLDATASIZE(54, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CALLDATACOPY(55, 3, 0, Tier.VeryLowTier, new CallFlags[0]),
    CODESIZE(56, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CODECOPY(57, 3, 0, Tier.VeryLowTier, new CallFlags[0]),
    RETURNDATASIZE(61, 0, 1, Tier.BaseTier, new CallFlags[0]),
    RETURNDATACOPY(62, 3, 0, Tier.VeryLowTier, new CallFlags[0]),
    GASPRICE(58, 0, 1, Tier.BaseTier, new CallFlags[0]),
    EXTCODESIZE(59, 1, 1, Tier.ExtTier, new CallFlags[0]),
    EXTCODECOPY(60, 4, 0, Tier.ExtTier, new CallFlags[0]),
    BLOCKHASH(64, 1, 1, Tier.ExtTier, new CallFlags[0]),
    COINBASE(65, 0, 1, Tier.BaseTier, new CallFlags[0]),
    TIMESTAMP(66, 0, 1, Tier.BaseTier, new CallFlags[0]),
    NUMBER(67, 0, 1, Tier.BaseTier, new CallFlags[0]),
    DIFFICULTY(68, 0, 1, Tier.BaseTier, new CallFlags[0]),
    GASLIMIT(69, 0, 1, Tier.BaseTier, new CallFlags[0]),
    POP(80, 1, 0, Tier.BaseTier, new CallFlags[0]),
    MLOAD(81, 1, 1, Tier.VeryLowTier, new CallFlags[0]),
    MSTORE(82, 2, 0, Tier.VeryLowTier, new CallFlags[0]),
    MSTORE8(83, 2, 0, Tier.VeryLowTier, new CallFlags[0]),
    SLOAD(84, 1, 1, Tier.SpecialTier, new CallFlags[0]),
    SSTORE(85, 2, 0, Tier.SpecialTier, new CallFlags[0]),
    JUMP(86, 1, 0, Tier.MidTier, new CallFlags[0]),
    JUMPI(87, 2, 0, Tier.HighTier, new CallFlags[0]),
    PC(88, 0, 1, Tier.BaseTier, new CallFlags[0]),
    MSIZE(89, 0, 1, Tier.BaseTier, new CallFlags[0]),
    GAS(90, 0, 1, Tier.BaseTier, new CallFlags[0]),
    JUMPDEST(91, 0, 0, Tier.SpecialTier, new CallFlags[0]),
    PUSH1(96, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH2(97, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH3(98, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH4(99, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH5(100, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH6(101, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH7(102, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH8(103, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH9(104, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH10(105, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH11(106, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH12(107, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH13(108, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH14(109, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH15(110, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH16(111, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH17(112, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH18(113, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH19(114, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH20(115, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH21(116, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH22(117, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH23(118, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH24(119, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH25(120, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH26(121, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH27(122, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH28(123, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH29(124, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH30(125, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH31(126, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    PUSH32(127, 0, 1, Tier.VeryLowTier, new CallFlags[0]),
    DUP1(128, 1, 2, Tier.VeryLowTier, new CallFlags[0]),
    DUP2(129, 2, 3, Tier.VeryLowTier, new CallFlags[0]),
    DUP3(130, 3, 4, Tier.VeryLowTier, new CallFlags[0]),
    DUP4(131, 4, 5, Tier.VeryLowTier, new CallFlags[0]),
    DUP5(132, 5, 6, Tier.VeryLowTier, new CallFlags[0]),
    DUP6(133, 6, 7, Tier.VeryLowTier, new CallFlags[0]),
    DUP7(134, 7, 8, Tier.VeryLowTier, new CallFlags[0]),
    DUP8(135, 8, 9, Tier.VeryLowTier, new CallFlags[0]),
    DUP9(136, 9, 10, Tier.VeryLowTier, new CallFlags[0]),
    DUP10(137, 10, 11, Tier.VeryLowTier, new CallFlags[0]),
    DUP11(138, 11, 12, Tier.VeryLowTier, new CallFlags[0]),
    DUP12(139, 12, 13, Tier.VeryLowTier, new CallFlags[0]),
    DUP13(140, 13, 14, Tier.VeryLowTier, new CallFlags[0]),
    DUP14(141, 14, 15, Tier.VeryLowTier, new CallFlags[0]),
    DUP15(142, 15, 16, Tier.VeryLowTier, new CallFlags[0]),
    DUP16(143, 16, 17, Tier.VeryLowTier, new CallFlags[0]),
    SWAP1(144, 2, 2, Tier.VeryLowTier, new CallFlags[0]),
    SWAP2(145, 3, 3, Tier.VeryLowTier, new CallFlags[0]),
    SWAP3(146, 4, 4, Tier.VeryLowTier, new CallFlags[0]),
    SWAP4(147, 5, 5, Tier.VeryLowTier, new CallFlags[0]),
    SWAP5(148, 6, 6, Tier.VeryLowTier, new CallFlags[0]),
    SWAP6(149, 7, 7, Tier.VeryLowTier, new CallFlags[0]),
    SWAP7(150, 8, 8, Tier.VeryLowTier, new CallFlags[0]),
    SWAP8(151, 9, 9, Tier.VeryLowTier, new CallFlags[0]),
    SWAP9(152, 10, 10, Tier.VeryLowTier, new CallFlags[0]),
    SWAP10(153, 11, 11, Tier.VeryLowTier, new CallFlags[0]),
    SWAP11(154, 12, 12, Tier.VeryLowTier, new CallFlags[0]),
    SWAP12(155, 13, 13, Tier.VeryLowTier, new CallFlags[0]),
    SWAP13(156, 14, 14, Tier.VeryLowTier, new CallFlags[0]),
    SWAP14(157, 15, 15, Tier.VeryLowTier, new CallFlags[0]),
    SWAP15(158, 16, 16, Tier.VeryLowTier, new CallFlags[0]),
    SWAP16(159, 17, 17, Tier.VeryLowTier, new CallFlags[0]),
    LOG0(160, 2, 0, Tier.SpecialTier, new CallFlags[0]),
    LOG1(161, 3, 0, Tier.SpecialTier, new CallFlags[0]),
    LOG2(162, 4, 0, Tier.SpecialTier, new CallFlags[0]),
    LOG3(163, 5, 0, Tier.SpecialTier, new CallFlags[0]),
    LOG4(164, 6, 0, Tier.SpecialTier, new CallFlags[0]),
    CALLTOKEN(208, 8, 1, Tier.SpecialTier, CallFlags.Call, CallFlags.HasValue),
    TOKENBALANCE(209, 2, 1, Tier.ExtTier, new CallFlags[0]),
    CALLTOKENVALUE(210, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CALLTOKENID(211, 0, 1, Tier.BaseTier, new CallFlags[0]),
    CREATE(240, 3, 1, Tier.SpecialTier, new CallFlags[0]),
    CALL(241, 7, 1, Tier.SpecialTier, CallFlags.Call, CallFlags.HasValue),
    CALLCODE(242, 7, 1, Tier.SpecialTier, CallFlags.Call, CallFlags.HasValue, CallFlags.Stateless),
    RETURN(243, 2, 0, Tier.ZeroTier, new CallFlags[0]),
    DELEGATECALL(244, 6, 1, Tier.SpecialTier, CallFlags.Call, CallFlags.Stateless, CallFlags.Delegate),
    STATICCALL(250, 6, 1, Tier.SpecialTier, CallFlags.Call, CallFlags.Static),
    REVERT(253, 2, 0, Tier.ZeroTier, new CallFlags[0]),
    SUICIDE(255, 1, 0, Tier.ZeroTier, new CallFlags[0]);

    private final byte opcode;
    private final int require;
    private final Tier tier;
    private final int ret;
    private final EnumSet<CallFlags> callFlags;
    private static final OpCode[] intToTypeMap;
    private static final Map<String, Byte> stringToByteMap;

    private OpCode(int op, int require, int ret, Tier tier, CallFlags ... callFlags) {
        this.opcode = (byte)op;
        this.require = require;
        this.tier = tier;
        this.ret = ret;
        this.callFlags = callFlags.length == 0 ? EnumSet.noneOf(CallFlags.class) : EnumSet.copyOf(Arrays.asList(callFlags));
    }

    public byte val() {
        return this.opcode;
    }

    public int require() {
        return this.require;
    }

    public int ret() {
        return this.ret;
    }

    public int asInt() {
        return this.opcode;
    }

    public static boolean contains(String code2) {
        return stringToByteMap.containsKey(code2.trim());
    }

    public static byte byteVal(String code2) {
        return stringToByteMap.get(code2);
    }

    public static OpCode code(byte code2) {
        return intToTypeMap[code2 & 0xFF];
    }

    private EnumSet<CallFlags> getCallFlags() {
        return this.callFlags;
    }

    public boolean isCall() {
        return this.getCallFlags().contains((Object)CallFlags.Call);
    }

    private void checkCall() {
        if (!this.isCall()) {
            throw new RuntimeException("Opcode is not a call: " + (Object)((Object)this));
        }
    }

    public boolean callIsStateless() {
        this.checkCall();
        return this.getCallFlags().contains((Object)CallFlags.Stateless);
    }

    public boolean callHasValue() {
        this.checkCall();
        return this.getCallFlags().contains((Object)CallFlags.HasValue);
    }

    public boolean callIsStatic() {
        this.checkCall();
        return this.getCallFlags().contains((Object)CallFlags.Static);
    }

    public boolean callIsDelegate() {
        this.checkCall();
        return this.getCallFlags().contains((Object)CallFlags.Delegate);
    }

    public Tier getTier() {
        return this.tier;
    }

    static {
        intToTypeMap = new OpCode[256];
        stringToByteMap = new HashMap<String, Byte>();
        OpCode[] opCodeArray = OpCode.values();
        int n = opCodeArray.length;
        for (int i = 0; i < n; ++i) {
            OpCode type;
            OpCode.intToTypeMap[type.opcode & 0xFF] = type = opCodeArray[i];
            stringToByteMap.put(type.name(), type.opcode);
        }
    }

    private static enum CallFlags {
        Call,
        Stateless,
        HasValue,
        Static,
        Delegate;

    }

    public static enum Tier {
        ZeroTier(0),
        BaseTier(2),
        VeryLowTier(3),
        LowTier(5),
        MidTier(8),
        HighTier(10),
        ExtTier(20),
        SpecialTier(1),
        InvalidTier(0);

        private final int level;

        private Tier(int level) {
            this.level = level;
        }

        public int asInt() {
            return this.level;
        }
    }
}

