/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime.config;

import org.tron.common.utils.ForkController;
import org.tron.core.config.args.Args;

public class VMConfig {
    public static final int MAX_CODE_LENGTH = 0x100000;
    public static final int MAX_FEE_LIMIT = 1000000000;
    private boolean vmTraceCompressed = false;
    private boolean vmTrace = Args.getInstance().isVmTrace();
    private static boolean ENERGY_LIMIT_HARD_FORK = false;
    private static boolean ALLOW_TVM_TRANSFER_TRC10 = false;

    private VMConfig() {
    }

    public static VMConfig getInstance() {
        return SystemPropertiesInstance.INSTANCE;
    }

    public boolean vmTrace() {
        return this.vmTrace;
    }

    public boolean vmTraceCompressed() {
        return this.vmTraceCompressed;
    }

    public static void initVmHardFork() {
        ENERGY_LIMIT_HARD_FORK = ForkController.instance().pass(5);
    }

    public static void initAllowTvmTransferTrc10(long allow) {
        ALLOW_TVM_TRANSFER_TRC10 = allow == 1L;
    }

    public static boolean getEnergyLimitHardFork() {
        return ENERGY_LIMIT_HARD_FORK;
    }

    public static boolean allowTvmTransferTrc10() {
        return ALLOW_TVM_TRANSFER_TRC10;
    }

    public static void setENERGY_LIMIT_HARD_FORK(boolean ENERGY_LIMIT_HARD_FORK) {
        VMConfig.ENERGY_LIMIT_HARD_FORK = ENERGY_LIMIT_HARD_FORK;
    }

    public static void setALLOW_TVM_TRANSFER_TRC10(boolean ALLOW_TVM_TRANSFER_TRC10) {
        VMConfig.ALLOW_TVM_TRANSFER_TRC10 = ALLOW_TVM_TRANSFER_TRC10;
    }

    private static class SystemPropertiesInstance {
        private static final VMConfig INSTANCE = new VMConfig();

        private SystemPropertiesInstance() {
        }
    }
}

