/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.client.PeerClient;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeHandler;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.core.config.args.Args;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerConnectionDelegate;

@Component
public class SyncPool {
    public static final Logger logger = LoggerFactory.getLogger((String)"SyncPool");
    private double factor = Args.getInstance().getConnectFactor();
    private double activeFactor = Args.getInstance().getActiveConnectFactor();
    private final List<PeerConnection> activePeers = Collections.synchronizedList(new ArrayList());
    private final AtomicInteger passivePeersCount = new AtomicInteger(0);
    private final AtomicInteger activePeersCount = new AtomicInteger(0);
    private Cache<NodeHandler, Long> nodeHandlerCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(180L, TimeUnit.SECONDS).recordStats().build();
    @Autowired
    private NodeManager nodeManager;
    @Autowired
    private ApplicationContext ctx;
    private ChannelManager channelManager;
    private PeerConnectionDelegate peerDel;
    private Args args = Args.getInstance();
    private int maxActiveNodes = this.args.getNodeMaxActiveNodes();
    private int getMaxActivePeersWithSameIp = this.args.getNodeMaxActiveNodesWithSameIp();
    private ScheduledExecutorService poolLoopExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService logExecutor = Executors.newSingleThreadScheduledExecutor();
    private PeerClient peerClient;

    public void init(PeerConnectionDelegate peerDel) {
        this.peerDel = peerDel;
        this.channelManager = (ChannelManager)this.ctx.getBean(ChannelManager.class);
        this.channelManager.init();
        this.peerClient = (PeerClient)this.ctx.getBean(PeerClient.class);
        for (Node node : this.args.getActiveNodes()) {
            this.nodeManager.getNodeHandler(node).getNodeStatistics().setPredefined(true);
        }
        this.poolLoopExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.fillUp();
            }
            catch (Throwable t) {
                logger.error("Exception in sync worker", t);
            }
        }, 30000L, 3600L, TimeUnit.MILLISECONDS);
        this.logExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.logActivePeers();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 30L, 10L, TimeUnit.SECONDS);
    }

    private void fillUp() {
        int lackSize = Math.max((int)((double)this.maxActiveNodes * this.factor) - this.activePeers.size(), (int)((double)this.maxActiveNodes * this.activeFactor - (double)this.activePeersCount.get()));
        if (lackSize <= 0) {
            return;
        }
        HashSet<String> nodesInUse = new HashSet<String>();
        this.channelManager.getActivePeers().forEach(channel -> nodesInUse.add(channel.getPeerId()));
        nodesInUse.add(this.nodeManager.getPublicHomeNode().getHexId());
        List<NodeHandler> newNodes = this.nodeManager.getNodes(new NodeSelector(nodesInUse), lackSize);
        newNodes.forEach(n -> {
            this.peerClient.connectAsync((NodeHandler)n, false);
            this.nodeHandlerCache.put(n, (Object)System.currentTimeMillis());
        });
    }

    public void addActivePeers(PeerConnection p) {
        this.activePeers.add(p);
    }

    synchronized void logActivePeers() {
        logger.info("-------- active connect channel {}", (Object)this.activePeersCount.get());
        logger.info("-------- passive connect channel {}", (Object)this.passivePeersCount.get());
        logger.info("-------- all connect channel {}", (Object)this.channelManager.getActivePeers().size());
        for (Channel channel : this.channelManager.getActivePeers()) {
            logger.info(channel.toString());
        }
        if (logger.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("Peer stats:\n");
            sb.append("Active peers\n");
            sb.append("============\n");
            HashSet<Node> activeSet = new HashSet<Node>();
            for (PeerConnection peerConnection : new ArrayList<PeerConnection>(this.activePeers)) {
                sb.append(peerConnection.logSyncStats()).append('\n');
                activeSet.add(peerConnection.getNode());
            }
            sb.append("Other connected peers\n");
            sb.append("============\n");
            for (Channel channel : new ArrayList<Channel>(this.channelManager.getActivePeers())) {
                if (activeSet.contains(channel.getNode())) continue;
                sb.append(channel.getNode()).append('\n');
            }
            logger.info(sb.toString());
        }
    }

    public synchronized List<PeerConnection> getActivePeers() {
        ArrayList peers = Lists.newArrayList();
        this.activePeers.forEach(peer -> {
            if (!peer.isDisconnect()) {
                peers.add(peer);
            }
        });
        return peers;
    }

    public synchronized void onConnect(Channel peer) {
        if (!this.activePeers.contains(peer)) {
            if (!peer.isActive()) {
                this.passivePeersCount.incrementAndGet();
            } else {
                this.activePeersCount.incrementAndGet();
            }
            this.activePeers.add((PeerConnection)peer);
            this.activePeers.sort(Comparator.comparingDouble(c -> c.getPeerStats().getAvgLatency()));
            this.peerDel.onConnectPeer((PeerConnection)peer);
        }
    }

    public synchronized void onDisconnect(Channel peer) {
        if (this.activePeers.contains(peer)) {
            if (!peer.isActive()) {
                this.passivePeersCount.decrementAndGet();
            } else {
                this.activePeersCount.decrementAndGet();
            }
            this.activePeers.remove(peer);
            this.peerDel.onDisconnectPeer((PeerConnection)peer);
        }
    }

    public boolean isCanConnect() {
        return !((double)this.passivePeersCount.get() >= (double)this.maxActiveNodes * (1.0 - this.activeFactor));
    }

    public void close() {
        try {
            this.poolLoopExecutor.shutdownNow();
            this.logExecutor.shutdownNow();
        }
        catch (Exception e) {
            logger.warn("Problems shutting down executor", (Throwable)e);
        }
    }

    public AtomicInteger getPassivePeersCount() {
        return this.passivePeersCount;
    }

    public AtomicInteger getActivePeersCount() {
        return this.activePeersCount;
    }

    class NodeSelector
    implements Predicate<NodeHandler> {
        Set<String> nodesInUse;

        public NodeSelector(Set<String> nodesInUse) {
            this.nodesInUse = nodesInUse;
        }

        @Override
        public boolean test(NodeHandler handler) {
            if (handler.getNode().getHost().equals(SyncPool.this.nodeManager.getPublicHomeNode().getHost()) && handler.getNode().getPort() == SyncPool.this.nodeManager.getPublicHomeNode().getPort()) {
                return false;
            }
            if (this.nodesInUse != null && this.nodesInUse.contains(handler.getNode().getHexId())) {
                return false;
            }
            if (handler.getNodeStatistics().getReputation() >= 100000) {
                return true;
            }
            InetAddress inetAddress = handler.getInetSocketAddress().getAddress();
            if (SyncPool.this.channelManager.getRecentlyDisconnected().getIfPresent((Object)inetAddress) != null) {
                return false;
            }
            if (SyncPool.this.channelManager.getBadPeers().getIfPresent((Object)inetAddress) != null) {
                return false;
            }
            if (SyncPool.this.channelManager.getConnectionNum(inetAddress) >= SyncPool.this.getMaxActivePeersWithSameIp) {
                return false;
            }
            if (SyncPool.this.nodeHandlerCache.getIfPresent((Object)handler) != null) {
                return false;
            }
            return handler.getNodeStatistics().getReputation() >= 100;
        }
    }
}

