/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultMessageSizeEstimator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.server.TronChannelInitializer;
import org.tron.core.config.args.Args;
import org.tron.core.net.node.NodeImpl;

@Component
public class PeerServer {
    private static final Logger logger = LoggerFactory.getLogger((String)"PeerServer");
    private Args args = Args.getInstance();
    private ApplicationContext ctx;
    public TronChannelInitializer tronChannelInitializer;
    private boolean listening;
    @Autowired
    private NodeImpl p2pNode;
    EventLoopGroup bossGroup;
    EventLoopGroup workerGroup;
    ChannelFuture channelFuture;

    @Autowired
    public PeerServer(Args args, ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void start(int port) {
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(this.args.getTcpNettyWorkThreadNum());
        this.tronChannelInitializer = (TronChannelInitializer)((Object)this.ctx.getBean(TronChannelInitializer.class, new Object[]{""}));
        this.tronChannelInitializer.setNodeImpl(this.p2pNode);
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group(this.bossGroup, this.workerGroup);
            b.channel(NioServerSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.option(ChannelOption.MESSAGE_SIZE_ESTIMATOR, (Object)DefaultMessageSizeEstimator.DEFAULT);
            b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.args.getNodeConnectionTimeout());
            b.handler((ChannelHandler)new LoggingHandler());
            b.childHandler((ChannelHandler)this.tronChannelInitializer);
            logger.info("TCP listener started, bind port {}", (Object)port);
            this.channelFuture = b.bind(port).sync();
            this.listening = true;
            this.channelFuture.channel().closeFuture().sync();
            logger.info("TCP listener is closed");
        }
        catch (Exception e) {
            logger.error("Start TCP server failed.", (Throwable)e);
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.listening = false;
        }
    }

    public void close() {
        if (this.listening && this.channelFuture != null && this.channelFuture.channel().isOpen()) {
            try {
                logger.info("Closing TCP server...");
                this.channelFuture.channel().close().sync();
            }
            catch (Exception e) {
                logger.warn("Closing TCP server failed.", (Throwable)e);
            }
        }
    }
}

