/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import org.tron.common.overlay.message.Message;

public class MessageRoundtrip {
    private final Message msg;
    long lastTimestamp = 0L;
    long retryTimes = 0L;
    boolean answered = false;

    public MessageRoundtrip(Message msg) {
        this.msg = msg;
        this.saveTime();
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public void answer() {
        this.answered = true;
    }

    public long getRetryTimes() {
        return this.retryTimes;
    }

    public void incRetryTimes() {
        ++this.retryTimes;
    }

    public void saveTime() {
        this.lastTimestamp = System.currentTimeMillis();
    }

    public long getTime() {
        return this.lastTimestamp;
    }

    public boolean hasToRetry() {
        return 20000L < System.currentTimeMillis() - this.lastTimestamp;
    }

    public Message getMsg() {
        return this.msg;
    }
}

