/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.message.DisconnectMessage;
import org.tron.common.overlay.message.HelloMessage;
import org.tron.common.overlay.message.P2pMessage;
import org.tron.common.overlay.message.P2pMessageFactory;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.common.overlay.server.SyncPool;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Component
@Scope(value="prototype")
public class HandshakeHandler
extends ByteToMessageDecoder {
    protected static final Logger logger = LoggerFactory.getLogger((String)"HandshakeHandler");
    private byte[] remoteId;
    protected Channel channel;
    @Autowired
    protected NodeManager nodeManager;
    @Autowired
    protected ChannelManager channelManager;
    @Autowired
    protected Manager manager;
    private P2pMessageFactory messageFactory = new P2pMessageFactory();
    @Autowired
    private SyncPool syncPool;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.info("channel active, {}", (Object)ctx.channel().remoteAddress());
        this.channel.setChannelHandlerContext(ctx);
        if (this.remoteId.length == 64) {
            this.channel.initNode(this.remoteId, ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
            this.sendHelloMsg(ctx, System.currentTimeMillis());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        byte[] encoded = new byte[buffer.readableBytes()];
        buffer.readBytes(encoded);
        P2pMessage msg = this.messageFactory.create(encoded);
        logger.info("Handshake Receive from {}, {}", (Object)ctx.channel().remoteAddress(), (Object)msg);
        switch (msg.getType()) {
            case P2P_HELLO: {
                this.handleHelloMsg(ctx, (HelloMessage)msg);
                break;
            }
            case P2P_DISCONNECT: {
                if (this.channel.getNodeStatistics() != null) {
                    this.channel.getNodeStatistics().nodeDisconnectedRemote(((DisconnectMessage)msg).getReasonCode());
                }
                this.channel.close();
                break;
            }
            default: {
                this.channel.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.channel.processException(cause);
    }

    public void setChannel(Channel channel, String remoteId) {
        this.channel = channel;
        this.remoteId = Hex.decode((String)remoteId);
    }

    protected void sendHelloMsg(ChannelHandlerContext ctx, long time) {
        HelloMessage message = new HelloMessage(this.nodeManager.getPublicHomeNode(), time, this.manager.getGenesisBlockId(), this.manager.getSolidBlockId(), this.manager.getHeadBlockId());
        ctx.writeAndFlush((Object)message.getSendData());
        this.channel.getNodeStatistics().messageStatistics.addTcpOutMessage(message);
        logger.info("Handshake Send to {}, {} ", (Object)ctx.channel().remoteAddress(), (Object)message);
    }

    private void handleHelloMsg(ChannelHandlerContext ctx, HelloMessage msg) {
        this.channel.initNode(msg.getFrom().getId(), msg.getFrom().getPort());
        if (this.remoteId.length != 64) {
            InetAddress address = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
            if (!this.channelManager.getTrustPeers().keySet().contains(address) && !this.syncPool.isCanConnect()) {
                this.channel.disconnect(Protocol.ReasonCode.TOO_MANY_PEERS);
                return;
            }
        }
        if (msg.getVersion() != Args.getInstance().getNodeP2pVersion()) {
            logger.info("Peer {} different p2p version, peer->{}, me->{}", new Object[]{ctx.channel().remoteAddress(), msg.getVersion(), Args.getInstance().getNodeP2pVersion()});
            this.channel.disconnect(Protocol.ReasonCode.INCOMPATIBLE_VERSION);
            return;
        }
        if (!Arrays.equals(this.manager.getGenesisBlockId().getBytes(), msg.getGenesisBlockId().getBytes())) {
            logger.info("Peer {} different genesis block, peer->{}, me->{}", new Object[]{ctx.channel().remoteAddress(), msg.getGenesisBlockId().getString(), this.manager.getGenesisBlockId().getString()});
            this.channel.disconnect(Protocol.ReasonCode.INCOMPATIBLE_CHAIN);
            return;
        }
        if (this.manager.getSolidBlockId().getNum() >= msg.getSolidBlockId().getNum() && !this.manager.containBlockInMainChain(msg.getSolidBlockId())) {
            logger.info("Peer {} different solid block, peer->{}, me->{}", new Object[]{ctx.channel().remoteAddress(), msg.getSolidBlockId().getString(), this.manager.getSolidBlockId().getString()});
            this.channel.disconnect(Protocol.ReasonCode.FORKED);
            return;
        }
        ((PeerConnection)this.channel).setHelloMessage(msg);
        this.channel.getNodeStatistics().messageStatistics.addTcpInMessage(msg);
        this.channel.publicHandshakeFinished(ctx, msg);
        if (!this.channelManager.processPeer(this.channel)) {
            return;
        }
        if (this.remoteId.length != 64) {
            this.sendHelloMsg(ctx, msg.getTimestamp());
        }
        this.syncPool.onConnect(this.channel);
    }
}

