/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.discover.node.Node;
import org.tron.common.overlay.discover.node.NodeManager;
import org.tron.common.overlay.discover.node.statistics.NodeStatistics;
import org.tron.common.overlay.message.DisconnectMessage;
import org.tron.common.overlay.message.HelloMessage;
import org.tron.common.overlay.message.MessageCodec;
import org.tron.common.overlay.message.StaticMessages;
import org.tron.common.overlay.server.ChannelManager;
import org.tron.common.overlay.server.HandshakeHandler;
import org.tron.common.overlay.server.MessageQueue;
import org.tron.common.overlay.server.P2pHandler;
import org.tron.common.overlay.server.PeerStatistics;
import org.tron.common.overlay.server.TrxProtobufVarint32FrameDecoder;
import org.tron.common.overlay.server.WireTrafficStats;
import org.tron.core.db.ByteArrayWrapper;
import org.tron.core.exception.P2pException;
import org.tron.core.net.peer.PeerConnectionDelegate;
import org.tron.core.net.peer.TronHandler;
import org.tron.protos.Protocol;

@Component
@Scope(value="prototype")
public class Channel {
    private static final Logger logger = LoggerFactory.getLogger((String)"Channel");
    @Autowired
    protected MessageQueue msgQueue;
    @Autowired
    private MessageCodec messageCodec;
    @Autowired
    private NodeManager nodeManager;
    @Autowired
    private StaticMessages staticMessages;
    @Autowired
    private WireTrafficStats stats;
    @Autowired
    private HandshakeHandler handshakeHandler;
    @Autowired
    private P2pHandler p2pHandler;
    @Autowired
    private TronHandler tronHandler;
    private ChannelManager channelManager;
    private ChannelHandlerContext ctx;
    private InetSocketAddress inetSocketAddress;
    private Node node;
    private long startTime;
    private PeerConnectionDelegate peerDel;
    private TronState tronState = TronState.INIT;
    protected NodeStatistics nodeStatistics;
    private boolean isActive;
    private volatile boolean isDisconnect;
    private String remoteId;
    private PeerStatistics peerStats = new PeerStatistics();
    private boolean isTrustPeer;

    public void init(ChannelPipeline pipeline, String remoteId, boolean discoveryMode, ChannelManager channelManager, PeerConnectionDelegate peerDel) {
        this.channelManager = channelManager;
        this.remoteId = remoteId;
        this.isActive = remoteId != null && !remoteId.isEmpty();
        this.startTime = System.currentTimeMillis();
        pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(60L, TimeUnit.SECONDS));
        pipeline.addLast(new ChannelHandler[]{this.stats.tcp});
        pipeline.addLast("protoPender", (ChannelHandler)new ProtobufVarint32LengthFieldPrepender());
        pipeline.addLast("lengthDecode", (ChannelHandler)new TrxProtobufVarint32FrameDecoder(this));
        pipeline.addLast("handshakeHandler", (ChannelHandler)this.handshakeHandler);
        this.peerDel = peerDel;
        this.messageCodec.setChannel(this);
        this.msgQueue.setChannel(this);
        this.handshakeHandler.setChannel(this, remoteId);
        this.p2pHandler.setChannel(this);
        this.tronHandler.setChannel(this);
        this.p2pHandler.setMsgQueue(this.msgQueue);
        this.tronHandler.setMsgQueue(this.msgQueue);
        this.tronHandler.setPeerDel(peerDel);
    }

    public void publicHandshakeFinished(ChannelHandlerContext ctx, HelloMessage msg) {
        this.isTrustPeer = this.channelManager.getTrustPeers().containsKey(this.getInetAddress());
        ctx.pipeline().remove((ChannelHandler)this.handshakeHandler);
        this.msgQueue.activate(ctx);
        ctx.pipeline().addLast("messageCodec", (ChannelHandler)this.messageCodec);
        ctx.pipeline().addLast("p2p", (ChannelHandler)this.p2pHandler);
        ctx.pipeline().addLast("data", (ChannelHandler)this.tronHandler);
        this.setStartTime(msg.getTimestamp());
        this.setTronState(TronState.HANDSHAKE_FINISHED);
        this.getNodeStatistics().p2pHandShake.add();
        logger.info("Finish handshake with {}.", (Object)ctx.channel().remoteAddress());
    }

    public void initNode(byte[] nodeId, int remotePort) {
        this.node = new Node(nodeId, this.inetSocketAddress.getHostString(), remotePort);
        this.nodeStatistics = this.nodeManager.getNodeStatistics(this.node);
        this.nodeManager.getNodeHandler(this.node).setNode(this.node);
    }

    public void disconnect(Protocol.ReasonCode reason) {
        this.isDisconnect = true;
        this.channelManager.processDisconnect(this, reason);
        DisconnectMessage msg = new DisconnectMessage(reason);
        logger.info("Send to {}, {}", (Object)this.ctx.channel().remoteAddress(), (Object)msg);
        this.getNodeStatistics().nodeDisconnectedLocal(reason);
        this.ctx.writeAndFlush((Object)msg.getSendData()).addListener(future -> this.close());
    }

    public void processException(Throwable throwable) {
        Throwable baseThrowable = throwable;
        while (baseThrowable.getCause() != null) {
            baseThrowable = baseThrowable.getCause();
        }
        String errMsg = throwable.getMessage();
        SocketAddress address = this.ctx.channel().remoteAddress();
        if (throwable instanceof ReadTimeoutException) {
            logger.error("Read timeout, {}", (Object)address);
        } else if (baseThrowable instanceof P2pException) {
            logger.error("type: {}, info: {}, {}", new Object[]{((P2pException)baseThrowable).getType(), baseThrowable.getMessage(), address});
        } else if (errMsg != null && errMsg.contains("Connection reset by peer")) {
            logger.error("{}, {}", (Object)errMsg, (Object)address);
        } else {
            logger.error("exception caught, {}", (Object)address, (Object)throwable);
        }
        this.close();
    }

    public void close() {
        this.isDisconnect = true;
        this.p2pHandler.close();
        this.msgQueue.close();
        this.ctx.close();
    }

    public PeerStatistics getPeerStats() {
        return this.peerStats;
    }

    public Node getNode() {
        return this.node;
    }

    public byte[] getNodeId() {
        return this.node == null ? null : this.node.getId();
    }

    public ByteArrayWrapper getNodeIdWrapper() {
        return this.node == null ? null : new ByteArrayWrapper(this.node.getId());
    }

    public String getPeerId() {
        return this.node == null ? "<null>" : this.node.getHexId();
    }

    public void setChannelHandlerContext(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.inetSocketAddress = ctx == null ? null : (InetSocketAddress)ctx.channel().remoteAddress();
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public InetAddress getInetAddress() {
        return this.ctx == null ? null : ((InetSocketAddress)this.ctx.channel().remoteAddress()).getAddress();
    }

    public NodeStatistics getNodeStatistics() {
        return this.nodeStatistics;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setTronState(TronState tronState) {
        this.tronState = tronState;
    }

    public TronState getTronState() {
        return this.tronState;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isDisconnect() {
        return this.isDisconnect;
    }

    public boolean isProtocolsInitialized() {
        return this.tronState.ordinal() > TronState.INIT.ordinal();
    }

    public boolean isTrustPeer() {
        return this.isTrustPeer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Channel channel = (Channel)o;
        if (this.inetSocketAddress != null ? !this.inetSocketAddress.equals(channel.inetSocketAddress) : channel.inetSocketAddress != null) {
            return false;
        }
        if (this.node != null ? !this.node.equals(channel.node) : channel.node != null) {
            return false;
        }
        return this == channel;
    }

    public int hashCode() {
        int result = this.inetSocketAddress != null ? this.inetSocketAddress.hashCode() : 0;
        result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s | %s", this.inetSocketAddress, this.getPeerId());
    }

    public static enum TronState {
        INIT,
        HANDSHAKE_FINISHED,
        START_TO_SYNC,
        SYNCING,
        SYNC_COMPLETED,
        SYNC_FAILED;

    }
}

