/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.message;

import org.apache.commons.lang3.ArrayUtils;
import org.tron.common.overlay.message.DisconnectMessage;
import org.tron.common.overlay.message.HelloMessage;
import org.tron.common.overlay.message.MessageFactory;
import org.tron.common.overlay.message.P2pMessage;
import org.tron.common.overlay.message.PingMessage;
import org.tron.common.overlay.message.PongMessage;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.MessageTypes;

public class P2pMessageFactory
extends MessageFactory {
    @Override
    public P2pMessage create(byte[] data) throws Exception {
        if (data.length <= 1) {
            throw new P2pException(P2pException.TypeEnum.MESSAGE_WITH_WRONG_LENGTH, "len=" + data.length + ", MessageType=" + (data.length == 1 ? Byte.valueOf(data[0]) : "unknow"));
        }
        try {
            byte type = data[0];
            byte[] rawData = ArrayUtils.subarray((byte[])data, (int)1, (int)data.length);
            return this.create(type, rawData);
        }
        catch (Exception e) {
            if (e instanceof P2pException) {
                throw e;
            }
            throw new P2pException(P2pException.TypeEnum.PARSE_MESSAGE_FAILED, "type=" + data[0] + ", len=" + data.length);
        }
    }

    private P2pMessage create(byte type, byte[] rawData) throws Exception {
        MessageTypes messageType = MessageTypes.fromByte(type);
        if (messageType == null) {
            throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "type=" + type + ", len=" + rawData.length);
        }
        switch (messageType) {
            case P2P_HELLO: {
                return new HelloMessage(type, rawData);
            }
            case P2P_DISCONNECT: {
                return new DisconnectMessage(type, rawData);
            }
            case P2P_PING: {
                return new PingMessage(type, rawData);
            }
            case P2P_PONG: {
                return new PongMessage(type, rawData);
            }
        }
        throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, messageType.toString() + ", len=" + rawData.length);
    }
}

