/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.message;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.common.overlay.message.P2pMessageFactory;
import org.tron.common.overlay.server.Channel;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessageFactory;

@Component
@Scope(value="prototype")
public class MessageCodec
extends ByteToMessageDecoder {
    private Channel channel;
    private P2pMessageFactory p2pMessageFactory = new P2pMessageFactory();
    private TronMessageFactory tronMessageFactory = new TronMessageFactory();

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        int length = buffer.readableBytes();
        byte[] encoded = new byte[length];
        buffer.readBytes(encoded);
        try {
            Message msg = this.createMessage(encoded);
            this.channel.getNodeStatistics().tcpFlow.add(length);
            out.add(msg);
        }
        catch (Exception e) {
            this.channel.processException(e);
        }
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    private Message createMessage(byte[] encoded) throws Exception {
        byte type = encoded[0];
        if (MessageTypes.inP2pRange(type)) {
            return this.p2pMessageFactory.create(encoded);
        }
        if (MessageTypes.inTronRange(type)) {
            return this.tronMessageFactory.create(encoded);
        }
        throw new P2pException(P2pException.TypeEnum.NO_SUCH_MESSAGE, "type=" + encoded[0]);
    }
}

