/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.table;

import org.tron.common.overlay.discover.node.Node;

public class NodeEntry {
    private byte[] ownerId;
    Node node;
    private String entryId;
    private int distance;
    private long modified;

    public NodeEntry(Node n) {
        this.node = n;
        this.ownerId = n.getId();
        this.entryId = n.getHost();
        this.distance = NodeEntry.distance(this.ownerId, n.getId());
        this.touch();
    }

    public NodeEntry(byte[] ownerId, Node n) {
        this.node = n;
        this.ownerId = ownerId;
        this.entryId = n.getHost();
        this.distance = NodeEntry.distance(ownerId, n.getId());
        this.touch();
    }

    public void touch() {
        this.modified = System.currentTimeMillis();
    }

    public int getDistance() {
        return this.distance;
    }

    public String getId() {
        return this.entryId;
    }

    public Node getNode() {
        return this.node;
    }

    public long getModified() {
        return this.modified;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null && this.getClass() == o.getClass()) {
            NodeEntry e = (NodeEntry)o;
            ret = this.getId().equals(e.getId());
        }
        return ret;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public static int distance(byte[] ownerId, byte[] targetId) {
        byte[] h1 = targetId;
        byte[] h2 = ownerId;
        byte[] hash = new byte[Math.min(h1.length, h2.length)];
        for (int i = 0; i < hash.length; ++i) {
            hash[i] = (byte)(h1[i] ^ h2[i]);
        }
        int d = 256;
        for (byte b : hash) {
            if (b == 0) {
                d -= 8;
                continue;
            }
            int count = 0;
            for (int i = 7; i >= 0; --i) {
                boolean a;
                boolean bl = a = (b & 1 << i) == 0;
                if (!a) break;
                ++count;
            }
            d -= count;
            break;
        }
        return d;
    }
}

