/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tron.common.overlay.discover.table.NodeEntry;
import org.tron.common.overlay.discover.table.TimeComparator;

public class NodeBucket {
    private final int depth;
    private List<NodeEntry> nodes = new ArrayList<NodeEntry>();

    NodeBucket(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public synchronized NodeEntry addNode(NodeEntry e) {
        if (!this.nodes.contains(e)) {
            if (this.nodes.size() >= 16) {
                return this.getLastSeen();
            }
            this.nodes.add(e);
        }
        return null;
    }

    private NodeEntry getLastSeen() {
        List<NodeEntry> sorted = this.nodes;
        Collections.sort(sorted, new TimeComparator());
        return sorted.get(0);
    }

    public synchronized void dropNode(NodeEntry entry) {
        for (NodeEntry e : this.nodes) {
            if (!e.getId().equals(entry.getId())) continue;
            this.nodes.remove(e);
            break;
        }
    }

    public int getNodesCount() {
        return this.nodes.size();
    }

    public List<NodeEntry> getNodes() {
        return this.nodes;
    }
}

