/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node.statistics;

import java.util.ArrayList;
import java.util.List;
import org.tron.common.overlay.discover.node.statistics.MessageStatistics;
import org.tron.common.overlay.discover.node.statistics.NodeStatistics;
import org.tron.protos.Protocol;

public class Reputation {
    private List<Score> scoreList = new ArrayList<Score>();

    public Reputation(NodeStatistics nodeStatistics) {
        DiscoverScore discoverScore = new DiscoverScore(nodeStatistics.messageStatistics);
        OtherScore otherScore = new OtherScore(nodeStatistics);
        TcpScore tcpScore = new TcpScore(nodeStatistics);
        DisConnectScore disconnectScore = new DisConnectScore(nodeStatistics);
        this.scoreList.add(discoverScore);
        this.scoreList.add(tcpScore);
        this.scoreList.add(otherScore);
        this.scoreList.add(disconnectScore);
    }

    public int calculate() {
        int scoreNumber = 0;
        for (Score score : this.scoreList) {
            scoreNumber = score.calculate(scoreNumber);
            if (score.isContinue()) continue;
            break;
        }
        return scoreNumber > 0 ? scoreNumber : 0;
    }

    public class OtherScore
    extends Score<NodeStatistics> {
        public OtherScore(NodeStatistics nodeStatistics) {
            super(nodeStatistics);
        }

        @Override
        int calculate(int baseScore) {
            baseScore = (int)((double)baseScore + ((int)((NodeStatistics)this.t).discoverMessageLatency.getAvrg() == 0 ? 0.0 : Math.min(1000.0 / ((NodeStatistics)this.t).discoverMessageLatency.getAvrg(), 20.0)));
            return baseScore;
        }
    }

    public class DisConnectScore
    extends Score<NodeStatistics> {
        public DisConnectScore(NodeStatistics nodeStatistics) {
            super(nodeStatistics);
        }

        @Override
        int calculate(int baseScore) {
            if (((NodeStatistics)this.t).wasDisconnected()) {
                if (((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == null && ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == null) {
                    baseScore = (int)((double)baseScore * 0.8);
                } else if (((NodeStatistics)this.t).getTronLastLocalDisconnectReason() != Protocol.ReasonCode.REQUESTED) {
                    if (((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.TOO_MANY_PEERS || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.TOO_MANY_PEERS || ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.TOO_MANY_PEERS_WITH_SAME_IP || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.TOO_MANY_PEERS_WITH_SAME_IP || ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.DUPLICATE_PEER || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.DUPLICATE_PEER || ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.TIME_OUT || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.TIME_OUT || ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.PING_TIMEOUT || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.PING_TIMEOUT || ((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() == Protocol.ReasonCode.CONNECT_FAIL || ((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.CONNECT_FAIL) {
                        baseScore = (int)((double)baseScore * 0.9);
                    } else if (((NodeStatistics)this.t).getTronLastLocalDisconnectReason() == Protocol.ReasonCode.RESET) {
                        baseScore = (int)((double)baseScore * 0.95);
                    } else if (((NodeStatistics)this.t).getTronLastRemoteDisconnectReason() != Protocol.ReasonCode.REQUESTED) {
                        baseScore = (int)((double)baseScore * 0.7);
                    }
                }
            }
            if (((NodeStatistics)this.t).getDisconnectTimes() > 20) {
                return 0;
            }
            int score = baseScore - (int)Math.pow(2.0, ((NodeStatistics)this.t).getDisconnectTimes()) * (((NodeStatistics)this.t).getDisconnectTimes() > 0 ? 10 : 0);
            return score;
        }
    }

    public class TcpScore
    extends Score<NodeStatistics> {
        public TcpScore(NodeStatistics nodeStatistics) {
            super(nodeStatistics);
        }

        @Override
        int calculate(int baseScore) {
            int reput = baseScore;
            reput += ((NodeStatistics)this.t).p2pHandShake.getTotalCount() > 0L ? 10 : 0;
            reput = (int)((long)reput + Math.min(((NodeStatistics)this.t).tcpFlow.getTotalCount() / 10240L, 20L));
            return reput += ((NodeStatistics)this.t).messageStatistics.p2pOutPing.getTotalCount() == ((NodeStatistics)this.t).messageStatistics.p2pInPong.getTotalCount() ? 10 : 0;
        }
    }

    public class DiscoverScore
    extends Score<MessageStatistics> {
        public DiscoverScore(MessageStatistics messageStatistics) {
            super(messageStatistics);
        }

        @Override
        int calculate(int baseScore) {
            int discoverReput = baseScore;
            discoverReput = (int)((long)discoverReput + Math.min(((MessageStatistics)this.t).discoverInPong.getTotalCount(), 1L) * (long)(((MessageStatistics)this.t).discoverOutPing.getTotalCount() == ((MessageStatistics)this.t).discoverInPong.getTotalCount() ? 101 : 1));
            discoverReput = (int)((long)discoverReput + Math.min(((MessageStatistics)this.t).discoverInNeighbours.getTotalCount(), 1L) * (long)(((MessageStatistics)this.t).discoverOutFindNode.getTotalCount() == ((MessageStatistics)this.t).discoverInNeighbours.getTotalCount() ? 10 : 1));
            return discoverReput;
        }

        @Override
        public boolean isContinue() {
            return ((MessageStatistics)this.t).discoverOutPing.getTotalCount() == ((MessageStatistics)this.t).discoverInPong.getTotalCount() && ((MessageStatistics)this.t).discoverInNeighbours.getTotalCount() <= ((MessageStatistics)this.t).discoverOutFindNode.getTotalCount();
        }
    }

    public abstract class Score<T>
    implements Comparable<Score> {
        protected T t;

        public Score(T t) {
            this.t = t;
        }

        abstract int calculate(int var1);

        public boolean isContinue() {
            return true;
        }

        public int getOrder() {
            return 0;
        }

        @Override
        public int compareTo(Score score) {
            if (this.getOrder() > score.getOrder()) {
                return 1;
            }
            if (this.getOrder() < score.getOrder()) {
                return -1;
            }
            return 0;
        }
    }
}

