/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node.statistics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.net.udp.message.UdpMessageTypeEnum;
import org.tron.common.overlay.discover.node.statistics.MessageCount;
import org.tron.common.overlay.message.Message;
import org.tron.core.net.message.FetchInvDataMessage;
import org.tron.core.net.message.InventoryMessage;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TransactionsMessage;

public class MessageStatistics {
    private static final Logger logger = LoggerFactory.getLogger(MessageStatistics.class);
    public final MessageCount discoverInPing = new MessageCount();
    public final MessageCount discoverOutPing = new MessageCount();
    public final MessageCount discoverInPong = new MessageCount();
    public final MessageCount discoverOutPong = new MessageCount();
    public final MessageCount discoverInFindNode = new MessageCount();
    public final MessageCount discoverOutFindNode = new MessageCount();
    public final MessageCount discoverInNeighbours = new MessageCount();
    public final MessageCount discoverOutNeighbours = new MessageCount();
    public final MessageCount p2pInHello = new MessageCount();
    public final MessageCount p2pOutHello = new MessageCount();
    public final MessageCount p2pInPing = new MessageCount();
    public final MessageCount p2pOutPing = new MessageCount();
    public final MessageCount p2pInPong = new MessageCount();
    public final MessageCount p2pOutPong = new MessageCount();
    public final MessageCount p2pInDisconnect = new MessageCount();
    public final MessageCount p2pOutDisconnect = new MessageCount();
    public final MessageCount tronInMessage = new MessageCount();
    public final MessageCount tronOutMessage = new MessageCount();
    public final MessageCount tronInSyncBlockChain = new MessageCount();
    public final MessageCount tronOutSyncBlockChain = new MessageCount();
    public final MessageCount tronInBlockChainInventory = new MessageCount();
    public final MessageCount tronOutBlockChainInventory = new MessageCount();
    public final MessageCount tronInTrxInventory = new MessageCount();
    public final MessageCount tronOutTrxInventory = new MessageCount();
    public final MessageCount tronInTrxInventoryElement = new MessageCount();
    public final MessageCount tronOutTrxInventoryElement = new MessageCount();
    public final MessageCount tronInBlockInventory = new MessageCount();
    public final MessageCount tronOutBlockInventory = new MessageCount();
    public final MessageCount tronInBlockInventoryElement = new MessageCount();
    public final MessageCount tronOutBlockInventoryElement = new MessageCount();
    public final MessageCount tronInTrxFetchInvData = new MessageCount();
    public final MessageCount tronOutTrxFetchInvData = new MessageCount();
    public final MessageCount tronInTrxFetchInvDataElement = new MessageCount();
    public final MessageCount tronOutTrxFetchInvDataElement = new MessageCount();
    public final MessageCount tronInBlockFetchInvData = new MessageCount();
    public final MessageCount tronOutBlockFetchInvData = new MessageCount();
    public final MessageCount tronInBlockFetchInvDataElement = new MessageCount();
    public final MessageCount tronOutBlockFetchInvDataElement = new MessageCount();
    public final MessageCount tronInTrx = new MessageCount();
    public final MessageCount tronOutTrx = new MessageCount();
    public final MessageCount tronInTrxs = new MessageCount();
    public final MessageCount tronOutTrxs = new MessageCount();
    public final MessageCount tronInBlock = new MessageCount();
    public final MessageCount tronOutBlock = new MessageCount();
    public final MessageCount tronOutAdvBlock = new MessageCount();

    public void addUdpInMessage(UdpMessageTypeEnum type) {
        this.addUdpMessage(type, true);
    }

    public void addUdpOutMessage(UdpMessageTypeEnum type) {
        this.addUdpMessage(type, false);
    }

    public void addTcpInMessage(Message msg) {
        this.addTcpMessage(msg, true);
    }

    public void addTcpOutMessage(Message msg) {
        this.addTcpMessage(msg, false);
    }

    private void addUdpMessage(UdpMessageTypeEnum type, boolean flag) {
        switch (type) {
            case DISCOVER_PING: {
                if (flag) {
                    this.discoverInPing.add();
                    break;
                }
                this.discoverOutPing.add();
                break;
            }
            case DISCOVER_PONG: {
                if (flag) {
                    this.discoverInPong.add();
                    break;
                }
                this.discoverOutPong.add();
                break;
            }
            case DISCOVER_FIND_NODE: {
                if (flag) {
                    this.discoverInFindNode.add();
                    break;
                }
                this.discoverOutFindNode.add();
                break;
            }
            case DISCOVER_NEIGHBORS: {
                if (flag) {
                    this.discoverInNeighbours.add();
                    break;
                }
                this.discoverOutNeighbours.add();
                break;
            }
        }
    }

    private void addTcpMessage(Message msg, boolean flag) {
        if (flag) {
            this.tronInMessage.add();
        } else {
            this.tronOutMessage.add();
        }
        switch (msg.getType()) {
            case P2P_HELLO: {
                if (flag) {
                    this.p2pInHello.add();
                    break;
                }
                this.p2pOutHello.add();
                break;
            }
            case P2P_PING: {
                if (flag) {
                    this.p2pInPing.add();
                    break;
                }
                this.p2pOutPing.add();
                break;
            }
            case P2P_PONG: {
                if (flag) {
                    this.p2pInPong.add();
                    break;
                }
                this.p2pOutPong.add();
                break;
            }
            case P2P_DISCONNECT: {
                if (flag) {
                    this.p2pInDisconnect.add();
                    break;
                }
                this.p2pOutDisconnect.add();
                break;
            }
            case SYNC_BLOCK_CHAIN: {
                if (flag) {
                    this.tronInSyncBlockChain.add();
                    break;
                }
                this.tronOutSyncBlockChain.add();
                break;
            }
            case BLOCK_CHAIN_INVENTORY: {
                if (flag) {
                    this.tronInBlockChainInventory.add();
                    break;
                }
                this.tronOutBlockChainInventory.add();
                break;
            }
            case INVENTORY: {
                InventoryMessage inventoryMessage = (InventoryMessage)msg;
                int inventorySize = inventoryMessage.getInventory().getIdsCount();
                if (flag) {
                    if (inventoryMessage.getInvMessageType() == MessageTypes.TRX) {
                        this.tronInTrxInventory.add();
                        this.tronInTrxInventoryElement.add(inventorySize);
                        break;
                    }
                    this.tronInBlockInventory.add();
                    this.tronInBlockInventoryElement.add(inventorySize);
                    break;
                }
                if (inventoryMessage.getInvMessageType() == MessageTypes.TRX) {
                    this.tronOutTrxInventory.add();
                    this.tronOutTrxInventoryElement.add(inventorySize);
                    break;
                }
                this.tronOutBlockInventory.add();
                this.tronOutBlockInventoryElement.add(inventorySize);
                break;
            }
            case FETCH_INV_DATA: {
                FetchInvDataMessage fetchInvDataMessage = (FetchInvDataMessage)msg;
                int fetchSize = fetchInvDataMessage.getInventory().getIdsCount();
                if (flag) {
                    if (fetchInvDataMessage.getInvMessageType() == MessageTypes.TRX) {
                        this.tronInTrxFetchInvData.add();
                        this.tronInTrxFetchInvDataElement.add(fetchSize);
                        break;
                    }
                    this.tronInBlockFetchInvData.add();
                    this.tronInBlockFetchInvDataElement.add(fetchSize);
                    break;
                }
                if (fetchInvDataMessage.getInvMessageType() == MessageTypes.TRX) {
                    this.tronOutTrxFetchInvData.add();
                    this.tronOutTrxFetchInvDataElement.add(fetchSize);
                    break;
                }
                this.tronOutBlockFetchInvData.add();
                this.tronOutBlockFetchInvDataElement.add(fetchSize);
                break;
            }
            case TRXS: {
                TransactionsMessage transactionsMessage = (TransactionsMessage)msg;
                if (flag) {
                    this.tronInTrxs.add();
                    this.tronInTrx.add(transactionsMessage.getTransactions().getTransactionsCount());
                    break;
                }
                this.tronOutTrxs.add();
                this.tronOutTrx.add(transactionsMessage.getTransactions().getTransactionsCount());
                break;
            }
            case TRX: {
                if (flag) {
                    this.tronInMessage.add();
                    break;
                }
                this.tronOutMessage.add();
                break;
            }
            case BLOCK: {
                if (flag) {
                    this.tronInBlock.add();
                }
                this.tronOutBlock.add();
                break;
            }
        }
    }
}

