/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.discover.node.statistics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCount {
    private static final Logger logger = LoggerFactory.getLogger(MessageCount.class);
    private static int SIZE = 60;
    private int[] szCount = new int[SIZE];
    private long indexTime = System.currentTimeMillis() / 1000L;
    private int index = (int)(this.indexTime % (long)SIZE);
    private long totalCount = 0L;

    private void update() {
        int k;
        long time = System.currentTimeMillis() / 1000L;
        long gap = time - this.indexTime;
        int n = k = gap > (long)SIZE ? SIZE : (int)gap;
        if (k > 0) {
            for (int i = 1; i <= k; ++i) {
                this.szCount[(this.index + i) % MessageCount.SIZE] = 0;
            }
            this.index = (int)(time % (long)SIZE);
            this.indexTime = time;
        }
    }

    public void add() {
        this.update();
        int n = this.index;
        this.szCount[n] = this.szCount[n] + 1;
        ++this.totalCount;
    }

    public void add(int count) {
        this.update();
        int n = this.index;
        this.szCount[n] = this.szCount[n] + count;
        this.totalCount += (long)count;
    }

    public int getCount(int interval) {
        if (interval > SIZE) {
            logger.warn("Param interval({}) is gt SIZE({})", (Object)interval, (Object)SIZE);
            return 0;
        }
        this.update();
        int count = 0;
        for (int i = 0; i < interval; ++i) {
            count += this.szCount[(SIZE + this.index - i) % SIZE];
        }
        return count;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void reset() {
        this.totalCount = 0L;
    }

    public String toString() {
        return String.valueOf(this.totalCount);
    }
}

